unit unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls, zlibar,
  Buttons, ComCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    ListBox1: TListBox;
    ListBox2: TListBox;
    OpenDialog1: TOpenDialog;
    OpenDialog2: TOpenDialog;
    ExtractProgBar: TProgressBar;
    CurrentProgBar: TProgressBar;
    AllProgBar: TProgressBar;
    SaveDialog1: TSaveDialog;
    SaveDialog2: TSaveDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Form1Create(Sender: TObject);
  private
    { private declarations }
    procedure CompressProgress(Sender: TObject; FileIndex: Integer; FileSize, FilePos: Int64);
    procedure ExtractProgress (Sender: TObject; FileSize, FilePos: Int64);
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 
  ZReadArc: TZlibReadArchive;

implementation

{ TForm1 }

procedure TForm1.Button2Click(Sender: TObject);
var
X:Integer;
begin
  if OpenDialog1.Execute then begin
    for X := 0 to OpenDialog1.Files.Count-1 do begin
      ListBox1.Items.Add(OpenDialog1.Files.Strings[X]);
    end;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
X: Integer;
Stream: TMemoryStream;
begin
  if OpenDialog2.Execute = False then Exit;
  ListBox2.Clear;
  Stream := TMemoryStream.Create;
  Stream.LoadFromFile(OpenDialog2.FileName);
  ZReadArc.InStream := Stream;
  for X := 0 to ZReadArc.Count-1 do begin
    ListBox2.Items.AddObject(ZReadArc.FilesInArchive[X].FileName, TObject(X));
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
Stream: TMemoryStream;
begin
  if ListBox2.ItemIndex = -1 then Exit;
  if SaveDialog2.Execute = False then Exit;
  Stream := TMemoryStream.Create;
  ZReadArc.OnExtract := @ExtractProgress;
  ZReadArc.ExtractFileToStream(Integer(ListBox2.Items.Objects[ListBox2.ItemIndex]), Stream);
  Stream.SaveToFile(SaveDialog2.FileName);
  Stream.Free;
end;

procedure TForm1.Form1Create(Sender: TObject);
begin
  ZReadArc := TZLibReadArchive.Create;
end;

procedure TForm1.CompressProgress(Sender: TObject; FileIndex: Integer;
  FileSize, FilePos: Int64);
begin
  if FileIndex <> AllProgBar.Position then
    CurrentProgBar.Max := FileSize;
  CurrentProgBar.Position := FilePos;
  AllProgBar.Position := FileIndex;
  Application.ProcessMessages;
end;

procedure TForm1.ExtractProgress(Sender: TObject; FileSize, FilePos: Int64);
begin
  ExtractProgBar.Max := FileSize;
  ExtractProgBar.Position := FilePos;
  Application.ProcessMessages;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
Zar: TZlibWriteArchive;
Stream: TMemoryStream;
X: Integer;
begin
  if not SaveDialog1.Execute then Exit;
  Stream := TMemoryStream.Create;
  Zar := TZlibWriteArchive.Create;
  Zar.OnCompress := @CompressProgress;
  Zar.OutStream := Stream;
  AllProgBar.Max := ListBox1.Items.Count-1;
  for X := 0 to ListBox1.Items.Count -1 do
    Zar.InputFiles.Add(ListBox1.Items.Strings[X]);
  Zar.CreateArchive;
  TMemoryStream(Zar.OutStream).SaveToFile(SaveDialog1.FileName);
  Zar.Free;
  Stream.Free;

end;

initialization
  {$I unit1.lrs}

end.

