unit IFSI_Registry;
{
This file has been generated by UnitParser v0.4b, written by M. Knight
and updated by NP. v/d Spek.
Source Code from Carlo Kok has been used to implement various sections of
UnitParser. Components of ifps3 are used in the construction of UnitParser,
code implementing the class wrapper is taken from Carlo Kok''s conv unility

}
{$I ifps3_def.inc}
interface
 
uses
   SysUtils
  ,Classes
  ,IFPS3CompExec
  ,ifpscomp
  ,ifps3
  ;
 
type 
(*----------------------------------------------------------------------------*)
  TIFPS3CE_Registry = class(TIFPS3Plugin)
  protected
    procedure CompOnUses(CompExec: TIFPS3CompExec); override;
    procedure ExecOnUses(CompExec: TIFPS3CompExec); override;
    procedure CompileImport1(CompExec: TIFPS3CompExec); override;
    procedure CompileImport2(CompExec: TIFPS3CompExec); override;
    procedure ExecImport1(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter); override;
    procedure ExecImport2(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter); override;
  end;
 
 
(*
{ compile-time registration functions }
procedure SIRegister_TRegistryIniFile(CL: TIFPSPascalCompiler);
procedure SIRegister_TRegIniFile(CL: TIFPSPascalCompiler);
procedure SIRegister_TRegistry(CL: TIFPSPascalCompiler);
procedure SIRegister_Registry(CL: TIFPSPascalCompiler);
 
{ run-time registration functions }
procedure RIRegister_TRegistryIniFile(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TRegIniFile(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TRegistry(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_Registry(CL: TIFPSRuntimeClassImporter);
*)


implementation


uses
   Windows
  ,IniFiles
  ,Registry
  ;
 
 
{ compile-time importer function }
(*----------------------------------------------------------------------------
 Sometimes the CL.AddClassN() fails to correctly register a class, 
 for unknown (at least to me) reasons
 So, you may use the below RegClassS() replacing the CL.AddClassN()
 of the various SIRegister_XXXX calls 
 ----------------------------------------------------------------------------*)
function RegClassS(CL: TIFPSPascalCompiler; const InheritsFrom, Classname: string): TIFPSCompileTimeClass;
begin
  Result := CL.FindClass(Classname);
  if Result = nil then
    Result := CL.AddClassN(CL.FindClass(InheritsFrom), Classname)
  else Result.ClassInheritsFrom := CL.FindClass(InheritsFrom);
end;
  
  
(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TRegistryIniFile(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomIniFile', 'TRegistryIniFile') do
  with CL.AddClassN(CL.FindClass('TCustomIniFile'),'TRegistryIniFile') do
  begin
    RegisterMethod('Constructor Create( const FileName : string);');
    RegisterMethod('Constructor CreateA( const FileName : string; AAccess : LongWord);');
    RegisterProperty('RegIniFile', 'TRegIniFile', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TRegIniFile(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TRegistry', 'TRegIniFile') do
  with CL.AddClassN(CL.FindClass('TRegistry'),'TRegIniFile') do
  begin
    RegisterMethod('Constructor Create( const FileName : string);');
    RegisterMethod('Constructor CreateA( const FileName : string; AAccess : LongWord);');
    RegisterMethod('Function ReadString( const Section, Ident, Default : string) : string');
    RegisterMethod('Function ReadInteger( const Section, Ident : string; Default : Longint) : Longint');
    RegisterMethod('Procedure WriteInteger( const Section, Ident : string; Value : Longint)');
    RegisterMethod('Procedure WriteString( const Section, Ident, Value : String)');
    RegisterMethod('Function ReadBool( const Section, Ident : string; Default : Boolean) : Boolean');
    RegisterMethod('Procedure WriteBool( const Section, Ident : string; Value : Boolean)');
    RegisterMethod('Procedure ReadSection( const Section : string; Strings : TStrings)');
    RegisterMethod('Procedure ReadSections( Strings : TStrings)');
    RegisterMethod('Procedure ReadSectionValues( const Section : string; Strings : TStrings)');
    RegisterMethod('Procedure EraseSection( const Section : string)');
    RegisterMethod('Procedure DeleteKey( const Section, Ident : String)');
    RegisterProperty('FileName', 'string', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TRegistry(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TObject', 'TRegistry') do
  with CL.AddClassN(CL.FindClass('TObject'),'TRegistry') do
  begin
    RegisterMethod('Constructor Create;');
    RegisterMethod('Constructor CreateA( AAccess : LongWord);');
    RegisterMethod('Procedure CloseKey');
    RegisterMethod('Function CreateKey( const Key : string) : Boolean');
    RegisterMethod('Function DeleteKey( const Key : string) : Boolean');
    RegisterMethod('Function DeleteValue( const Name : string) : Boolean');
    RegisterMethod('Function GetDataInfo( const ValueName : string; var Value : TRegDataInfo) : Boolean');
    RegisterMethod('Function GetDataSize( const ValueName : string) : Integer');
    RegisterMethod('Function GetDataType( const ValueName : string) : TRegDataType');
    RegisterMethod('Function GetKeyInfo( var Value : TRegKeyInfo) : Boolean');
    RegisterMethod('Procedure GetKeyNames( Strings : TStrings)');
    RegisterMethod('Procedure GetValueNames( Strings : TStrings)');
    RegisterMethod('Function HasSubKeys : Boolean');
    RegisterMethod('Function KeyExists( const Key : string) : Boolean');
    RegisterMethod('Function LoadKey( const Key, FileName : string) : Boolean');
    RegisterMethod('Procedure MoveKey( const OldName, NewName : string; Delete : Boolean)');
    RegisterMethod('Function OpenKey( const Key : string; CanCreate : Boolean) : Boolean');
    RegisterMethod('Function OpenKeyReadOnly( const Key : String) : Boolean');
    RegisterMethod('Function ReadCurrency( const Name : string) : Currency');
    RegisterMethod('Function ReadBool( const Name : string) : Boolean');
    RegisterMethod('Function ReadDate( const Name : string) : TDateTime');
    RegisterMethod('Function ReadDateTime( const Name : string) : TDateTime');
    RegisterMethod('Function ReadFloat( const Name : string) : Double');
    RegisterMethod('Function ReadInteger( const Name : string) : Integer');
    RegisterMethod('Function ReadString( const Name : string) : string');
    RegisterMethod('Function ReadTime( const Name : string) : TDateTime');
    RegisterMethod('Function RegistryConnect( const UNCName : string) : Boolean');
    RegisterMethod('Procedure RenameValue( const OldName, NewName : string)');
    RegisterMethod('Function ReplaceKey( const Key, FileName, BackUpFileName : string) : Boolean');
    RegisterMethod('Function RestoreKey( const Key, FileName : string) : Boolean');
    RegisterMethod('Function SaveKey( const Key, FileName : string) : Boolean');
    RegisterMethod('Function UnLoadKey( const Key : string) : Boolean');
    RegisterMethod('Function ValueExists( const Name : string) : Boolean');
    RegisterMethod('Procedure WriteCurrency( const Name : string; Value : Currency)');
    RegisterMethod('Procedure WriteBool( const Name : string; Value : Boolean)');
    RegisterMethod('Procedure WriteDate( const Name : string; Value : TDateTime)');
    RegisterMethod('Procedure WriteDateTime( const Name : string; Value : TDateTime)');
    RegisterMethod('Procedure WriteFloat( const Name : string; Value : Double)');
    RegisterMethod('Procedure WriteInteger( const Name : string; Value : Integer)');
    RegisterMethod('Procedure WriteString( const Name, Value : string)');
    RegisterMethod('Procedure WriteExpandString( const Name, Value : string)');
    RegisterMethod('Procedure WriteTime( const Name : string; Value : TDateTime)');
    RegisterProperty('CurrentKey', 'HKEY', iptr);
    RegisterProperty('CurrentPath', 'string', iptr);
    RegisterProperty('LazyWrite', 'Boolean', iptrw);
    RegisterProperty('RootKey', 'HKEY', iptrw);
    RegisterProperty('Access', 'LongWord', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_Registry(CL: TIFPSPascalCompiler);
begin
  CL.AddClassN(CL.FindClass('TOBJECT'),'ERegistryException');
  SIRegister_TRegistry(CL);
  SIRegister_TRegIniFile(CL);
  SIRegister_TRegistryIniFile(CL);
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TRegistryIniFileRegIniFile_R(Self: TRegistryIniFile; var T: TRegIniFile);
begin T := Self.RegIniFile; end;

(*----------------------------------------------------------------------------*)
Function TRegistryIniFileCreateA_P(Self: TClass; CreateNewInstance: Boolean;  const FileName : string; AAccess : LongWord):TObject;
Begin Result := TRegistryIniFile.Create(FileName, AAccess); END;

(*----------------------------------------------------------------------------*)
Function TRegistryIniFileCreate_P(Self: TClass; CreateNewInstance: Boolean;  const FileName : string):TObject;
Begin Result := TRegistryIniFile.Create(FileName); END;

(*----------------------------------------------------------------------------*)
procedure TRegIniFileFileName_R(Self: TRegIniFile; var T: string);
begin T := Self.FileName; end;

(*----------------------------------------------------------------------------*)
Function TRegIniFileCreateA_P(Self: TClass; CreateNewInstance: Boolean;  const FileName : string; AAccess : LongWord):TObject;
Begin Result := TRegIniFile.Create(FileName, AAccess); END;

(*----------------------------------------------------------------------------*)
Function TRegIniFileCreate_P(Self: TClass; CreateNewInstance: Boolean;  const FileName : string):TObject;
Begin Result := TRegIniFile.Create(FileName); END;

(*----------------------------------------------------------------------------*)
procedure TRegistryAccess_W(Self: TRegistry; const T: LongWord);
begin Self.Access := T; end;

(*----------------------------------------------------------------------------*)
procedure TRegistryAccess_R(Self: TRegistry; var T: LongWord);
begin T := Self.Access; end;

(*----------------------------------------------------------------------------*)
procedure TRegistryRootKey_W(Self: TRegistry; const T: HKEY);
begin Self.RootKey := T; end;

(*----------------------------------------------------------------------------*)
procedure TRegistryRootKey_R(Self: TRegistry; var T: HKEY);
begin T := Self.RootKey; end;

(*----------------------------------------------------------------------------*)
procedure TRegistryLazyWrite_W(Self: TRegistry; const T: Boolean);
begin Self.LazyWrite := T; end;

(*----------------------------------------------------------------------------*)
procedure TRegistryLazyWrite_R(Self: TRegistry; var T: Boolean);
begin T := Self.LazyWrite; end;

(*----------------------------------------------------------------------------*)
procedure TRegistryCurrentPath_R(Self: TRegistry; var T: string);
begin T := Self.CurrentPath; end;

(*----------------------------------------------------------------------------*)
procedure TRegistryCurrentKey_R(Self: TRegistry; var T: HKEY);
begin T := Self.CurrentKey; end;

(*----------------------------------------------------------------------------*)
Function TRegistryCreateA_P(Self: TClass; CreateNewInstance: Boolean;  AAccess : LongWord):TObject;
Begin Result := TRegistry.Create(AAccess); END;

(*----------------------------------------------------------------------------*)
Function TRegistryCreate_P(Self: TClass; CreateNewInstance: Boolean):TObject;
Begin Result := TRegistry.Create; END;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TRegistryIniFile(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TRegistryIniFile) do
  begin
    RegisterConstructor(@TRegistryIniFileCreate_P, 'Create');
    RegisterConstructor(@TRegistryIniFileCreateA_P, 'CreateA');
    RegisterPropertyHelper(@TRegistryIniFileRegIniFile_R,nil,'RegIniFile');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TRegIniFile(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TRegIniFile) do
  begin
    RegisterConstructor(@TRegIniFileCreate_P, 'Create');
    RegisterConstructor(@TRegIniFileCreateA_P, 'CreateA');
    RegisterMethod(@TRegIniFile.ReadString, 'ReadString');
    RegisterMethod(@TRegIniFile.ReadInteger, 'ReadInteger');
    RegisterMethod(@TRegIniFile.WriteInteger, 'WriteInteger');
    RegisterMethod(@TRegIniFile.WriteString, 'WriteString');
    RegisterMethod(@TRegIniFile.ReadBool, 'ReadBool');
    RegisterMethod(@TRegIniFile.WriteBool, 'WriteBool');
    RegisterMethod(@TRegIniFile.ReadSection, 'ReadSection');
    RegisterMethod(@TRegIniFile.ReadSections, 'ReadSections');
    RegisterMethod(@TRegIniFile.ReadSectionValues, 'ReadSectionValues');
    RegisterMethod(@TRegIniFile.EraseSection, 'EraseSection');
    RegisterMethod(@TRegIniFile.DeleteKey, 'DeleteKey');
    RegisterPropertyHelper(@TRegIniFileFileName_R,nil,'FileName');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TRegistry(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TRegistry) do
  begin
    RegisterConstructor(@TRegistryCreateA_P, 'CreateA');
    RegisterConstructor(@TRegistryCreate_P, 'Create');
    RegisterMethod(@TRegistry.CloseKey, 'CloseKey');
    RegisterMethod(@TRegistry.CreateKey, 'CreateKey');
    RegisterMethod(@TRegistry.DeleteKey, 'DeleteKey');
    RegisterMethod(@TRegistry.DeleteValue, 'DeleteValue');
    RegisterMethod(@TRegistry.GetDataInfo, 'GetDataInfo');
    RegisterMethod(@TRegistry.GetDataSize, 'GetDataSize');
    RegisterMethod(@TRegistry.GetDataType, 'GetDataType');
    RegisterMethod(@TRegistry.GetKeyInfo, 'GetKeyInfo');
    RegisterMethod(@TRegistry.GetKeyNames, 'GetKeyNames');
    RegisterMethod(@TRegistry.GetValueNames, 'GetValueNames');
    RegisterMethod(@TRegistry.HasSubKeys, 'HasSubKeys');
    RegisterMethod(@TRegistry.KeyExists, 'KeyExists');
    RegisterMethod(@TRegistry.LoadKey, 'LoadKey');
    RegisterMethod(@TRegistry.MoveKey, 'MoveKey');
    RegisterMethod(@TRegistry.OpenKey, 'OpenKey');
    RegisterMethod(@TRegistry.OpenKeyReadOnly, 'OpenKeyReadOnly');
    RegisterMethod(@TRegistry.ReadCurrency, 'ReadCurrency');
    RegisterMethod(@TRegistry.ReadBool, 'ReadBool');
    RegisterMethod(@TRegistry.ReadDate, 'ReadDate');
    RegisterMethod(@TRegistry.ReadDateTime, 'ReadDateTime');
    RegisterMethod(@TRegistry.ReadFloat, 'ReadFloat');
    RegisterMethod(@TRegistry.ReadInteger, 'ReadInteger');
    RegisterMethod(@TRegistry.ReadString, 'ReadString');
    RegisterMethod(@TRegistry.ReadTime, 'ReadTime');
    RegisterMethod(@TRegistry.RegistryConnect, 'RegistryConnect');
    RegisterMethod(@TRegistry.RenameValue, 'RenameValue');
    RegisterMethod(@TRegistry.ReplaceKey, 'ReplaceKey');
    RegisterMethod(@TRegistry.RestoreKey, 'RestoreKey');
    RegisterMethod(@TRegistry.SaveKey, 'SaveKey');
    RegisterMethod(@TRegistry.UnLoadKey, 'UnLoadKey');
    RegisterMethod(@TRegistry.ValueExists, 'ValueExists');
    RegisterMethod(@TRegistry.WriteCurrency, 'WriteCurrency');
    RegisterMethod(@TRegistry.WriteBool, 'WriteBool');
    RegisterMethod(@TRegistry.WriteDate, 'WriteDate');
    RegisterMethod(@TRegistry.WriteDateTime, 'WriteDateTime');
    RegisterMethod(@TRegistry.WriteFloat, 'WriteFloat');
    RegisterMethod(@TRegistry.WriteInteger, 'WriteInteger');
    RegisterMethod(@TRegistry.WriteString, 'WriteString');
    RegisterMethod(@TRegistry.WriteExpandString, 'WriteExpandString');
    RegisterMethod(@TRegistry.WriteTime, 'WriteTime');
    RegisterPropertyHelper(@TRegistryCurrentKey_R,nil,'CurrentKey');
    RegisterPropertyHelper(@TRegistryCurrentPath_R,nil,'CurrentPath');
    RegisterPropertyHelper(@TRegistryLazyWrite_R,@TRegistryLazyWrite_W,'LazyWrite');
    RegisterPropertyHelper(@TRegistryRootKey_R,@TRegistryRootKey_W,'RootKey');
    RegisterPropertyHelper(@TRegistryAccess_R,@TRegistryAccess_W,'Access');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_Registry(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(ERegistryException) do
  RIRegister_TRegistry(CL);
  RIRegister_TRegIniFile(CL);
  RIRegister_TRegistryIniFile(CL);
end;

(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TMemIniFile(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomIniFile', 'TMemIniFile') do
  with CL.AddClassN(CL.FindClass('TCustomIniFile'),'TMemIniFile') do
  begin
    RegisterMethod('Constructor Create( const FileName : string)');
    RegisterMethod('Procedure Clear');
    RegisterMethod('Procedure GetStrings( List : TStrings)');
    RegisterMethod('Procedure Rename( const FileName : string; Reload : Boolean)');
    RegisterMethod('Procedure SetStrings( List : TStrings)');
  end;
end;


(*----------------------------------------------------------------------------*)
procedure SIRegister_TIniFile(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomIniFile', 'TIniFile') do
  with CL.AddClassN(CL.FindClass('TCustomIniFile'),'TIniFile') do
  begin
    RegisterMethod('Function ReadString( const Section, Ident, Default : string) : string');
    RegisterMethod('Procedure WriteString( const Section, Ident, Value : String)');
    RegisterMethod('Procedure ReadSection( const Section : string; Strings : TStrings)');
    RegisterMethod('Procedure ReadSections( Strings : TStrings)');
    RegisterMethod('Procedure ReadSectionValues( const Section : string; Strings : TStrings)');
    RegisterMethod('Procedure EraseSection( const Section : string)');
    RegisterMethod('Procedure DeleteKey( const Section, Ident : String)');
    RegisterMethod('Procedure UpdateFile');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TCustomIniFile(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TObject', 'TCustomIniFile') do
  with CL.AddClassN(CL.FindClass('TObject'),'TCustomIniFile') do
  begin
    RegisterMethod('Constructor Create( const FileName : string)');
    RegisterMethod('Function SectionExists( const Section : string) : Boolean');
//    RegisterMethod('Function ReadString( const Section, Ident, Default : string) : string');
//    RegisterMethod('Procedure WriteString( const Section, Ident, Value : String)');
    RegisterMethod('Function ReadInteger( const Section, Ident : string; Default : Longint) : Longint');
    RegisterMethod('Procedure WriteInteger( const Section, Ident : string; Value : Longint)');
    RegisterMethod('Function ReadBool( const Section, Ident : string; Default : Boolean) : Boolean');
    RegisterMethod('Procedure WriteBool( const Section, Ident : string; Value : Boolean)');
    RegisterMethod('Function ReadDate( const Section, Name : string; Default : TDateTime) : TDateTime');
    RegisterMethod('Function ReadDateTime( const Section, Name : string; Default : TDateTime) : TDateTime');
    RegisterMethod('Function ReadFloat( const Section, Name : string; Default : Double) : Double');
    RegisterMethod('Function ReadTime( const Section, Name : string; Default : TDateTime) : TDateTime');
    RegisterMethod('Procedure WriteDate( const Section, Name : string; Value : TDateTime)');
    RegisterMethod('Procedure WriteDateTime( const Section, Name : string; Value : TDateTime)');
    RegisterMethod('Procedure WriteFloat( const Section, Name : string; Value : Double)');
    RegisterMethod('Procedure WriteTime( const Section, Name : string; Value : TDateTime)');
//    RegisterMethod('Procedure ReadSection( const Section : string; Strings : TStrings)');
//    RegisterMethod('Procedure ReadSections( Strings : TStrings)');
//    RegisterMethod('Procedure ReadSectionValues( const Section : string; Strings : TStrings)');
//    RegisterMethod('Procedure EraseSection( const Section : string)');
//    RegisterMethod('Procedure DeleteKey( const Section, Ident : String)');
//    RegisterMethod('Procedure UpdateFile');
    RegisterMethod('Function ValueExists( const Section, Ident : string) : Boolean');
    RegisterProperty('FileName', 'string', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_IniFiles(CL: TIFPSPascalCompiler);
begin
  SIRegister_TCustomIniFile(CL);
  SIRegister_TIniFile(CL);
  SIRegister_TMemIniFile(CL);
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TCustomIniFileFileName_R(Self: TCustomIniFile; var T: string);
begin T := Self.FileName; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TMemIniFile(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TMemIniFile) do
  begin
    RegisterConstructor(@TMemIniFile.Create, 'Create');
    RegisterMethod(@TMemIniFile.Clear, 'Clear');
    RegisterMethod(@TMemIniFile.GetStrings, 'GetStrings');
    RegisterMethod(@TMemIniFile.Rename, 'Rename');
    RegisterMethod(@TMemIniFile.SetStrings, 'SetStrings');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIniFile(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIniFile) do
  begin
    RegisterMethod(@TIniFile.ReadString, 'ReadString');
    RegisterMethod(@TIniFile.WriteString, 'WriteString');
    RegisterMethod(@TIniFile.ReadSection, 'ReadSection');
    RegisterMethod(@TIniFile.ReadSections, 'ReadSections');
    RegisterMethod(@TIniFile.ReadSectionValues, 'ReadSectionValues');
    RegisterMethod(@TIniFile.EraseSection, 'EraseSection');
    RegisterMethod(@TIniFile.DeleteKey, 'DeleteKey');
    RegisterMethod(@TIniFile.UpdateFile, 'UpdateFile');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TCustomIniFile(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TCustomIniFile) do
  begin
    RegisterConstructor(@TCustomIniFile.Create, 'Create');
    RegisterMethod(@TCustomIniFile.SectionExists, 'SectionExists');
//    RegisterVirtualAbstractMethod(@TCustomIniFile, @!.ReadString, 'ReadString');
//    RegisterVirtualAbstractMethod(@TCustomIniFile, @!.WriteString, 'WriteString');
    RegisterVirtualMethod(@TCustomIniFile.ReadInteger, 'ReadInteger');
    RegisterVirtualMethod(@TCustomIniFile.WriteInteger, 'WriteInteger');
    RegisterVirtualMethod(@TCustomIniFile.ReadBool, 'ReadBool');
    RegisterVirtualMethod(@TCustomIniFile.WriteBool, 'WriteBool');
    RegisterVirtualMethod(@TCustomIniFile.ReadDate, 'ReadDate');
    RegisterVirtualMethod(@TCustomIniFile.ReadDateTime, 'ReadDateTime');
    RegisterVirtualMethod(@TCustomIniFile.ReadFloat, 'ReadFloat');
    RegisterVirtualMethod(@TCustomIniFile.ReadTime, 'ReadTime');
    RegisterVirtualMethod(@TCustomIniFile.WriteDate, 'WriteDate');
    RegisterVirtualMethod(@TCustomIniFile.WriteDateTime, 'WriteDateTime');
    RegisterVirtualMethod(@TCustomIniFile.WriteFloat, 'WriteFloat');
    RegisterVirtualMethod(@TCustomIniFile.WriteTime, 'WriteTime');
//  RegisterVirtualAbstractMethod(@TCustomIniFile, @!.ReadSection, 'ReadSection');
//  RegisterVirtualAbstractMethod(@TCustomIniFile, @!.ReadSections, 'ReadSections');
//  RegisterVirtualAbstractMethod(@TCustomIniFile, @!.ReadSectionValues, 'ReadSectionValues');
//  RegisterVirtualAbstractMethod(@TCustomIniFile, @!.EraseSection, 'EraseSection');
//  RegisterVirtualAbstractMethod(@TCustomIniFile, @!.DeleteKey, 'DeleteKey');
//  RegisterVirtualAbstractMethod(@TCustomIniFile, @!.UpdateFile, 'UpdateFile');
    RegisterMethod(@TCustomIniFile.ValueExists, 'ValueExists');
    RegisterPropertyHelper(@TCustomIniFileFileName_R,nil,'FileName');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IniFiles(CL: TIFPSRuntimeClassImporter);
begin
  RIRegister_TCustomIniFile(CL);
  RIRegister_TIniFile(CL);
  RIRegister_TMemIniFile(CL);
end;

{ TIFPS3CE_Registry }
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_Registry.CompOnUses(CompExec: TIFPS3CompExec);
begin
  { nothing }
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_Registry.ExecOnUses(CompExec: TIFPS3CompExec);
begin
  { nothing }
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_Registry.CompileImport1(CompExec: TIFPS3CompExec);
begin
  SIRegister_Registry(CompExec.Comp);
  SIRegister_IniFiles(CompExec.Comp);
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_Registry.CompileImport2(CompExec: TIFPS3CompExec);
begin
  { nothing }
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_Registry.ExecImport1(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter);
begin
  RIRegister_Registry(ri);
  RIRegister_IniFiles(ri);
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_Registry.ExecImport2(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter);
begin
  { nothing }
end;


initialization
 (**)
{$IFDEF USEIMPORTER}
  CIImporter.AddCallBack(@SIRegister_Registry,PT_ClassImport);
{$ENDIF}
finalization
 (**)

end.
