unit IFSI_IBSQL;
{
This file has been generated by UnitParser v0.4, written by M. Knight.
Source Code from Carlo Kok has been used to implement various sections of
UnitParser. Components of ifps3 are used in the construction of UnitParser,
code implementing the class wrapper is taken from Carlo Kok''s conv unility

}
{$I ifps3_def.inc}
interface
 
uses
   SysUtils
  ,Classes
  ,IFPS3CompExec
  ,ifpscomp
  ,ifps3
  ;
 
type 
(*----------------------------------------------------------------------------*)
  TIFPS3CE_IBSQL = class(TIFPS3Plugin)
  protected
    procedure CompOnUses(CompExec: TIFPS3CompExec); override;
    procedure ExecOnUses(CompExec: TIFPS3CompExec); override;
    procedure CompileImport1(CompExec: TIFPS3CompExec); override;
    procedure CompileImport2(CompExec: TIFPS3CompExec); override;
    procedure ExecImport1(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter); override;
    procedure ExecImport2(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter); override;
  end;
 
 
(*
{ compile-time registration functions }
procedure SIRegister_TIBSQL(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBOUTPUTXML(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBINPUTRAWFILE(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBOUTPUTRAWFILE(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBINPUTDELIMITEDFILE(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBOUTPUTDELIMITEDFILE(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBBATCHOUTPUT(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBBATCHINPUT(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBBATCH(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBXSQLDA(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBXSQLVAR(CL: TIFPSPascalCompiler);
procedure SIRegister_IBSQL(CL: TIFPSPascalCompiler);
 
{ run-time registration functions }
procedure RIRegister_IBSQL_Routines(S: TIFPSExec);
procedure RIRegister_TIBSQL(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBOUTPUTXML(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBINPUTRAWFILE(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBOUTPUTRAWFILE(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBINPUTDELIMITEDFILE(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBOUTPUTDELIMITEDFILE(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBBATCHOUTPUT(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBBATCHINPUT(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBBATCH(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBXSQLDA(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBXSQLVAR(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_IBSQL(CL: TIFPSRuntimeClassImporter);
*)


implementation


uses
   WINDOWS
  ,FORMS
  ,CONTROLS
  ,IBHEADER
  ,IBERRORCODES
  ,IBEXTERNALS
  ,DB
  ,IB
  ,IBDATABASE
  ,IBUTILS
  ,IBXCONST
  ,IBSQL
  ;
 
 
{ compile-time importer function }
(*----------------------------------------------------------------------------
 Sometimes the CL.AddClassN() fails to correctly register a class, 
 for unknown (at least to me) reasons
 So, you may use the below RegClassS() replacing the CL.AddClassN()
 of the various SIRegister_XXXX calls 
 ----------------------------------------------------------------------------*)
function RegClassS(CL: TIFPSPascalCompiler; const InheritsFrom, Classname: string): TIFPSCompileTimeClass;
begin
  Result := CL.FindClass(Classname);
  if Result = nil then
    Result := CL.AddClassN(CL.FindClass(InheritsFrom), Classname)
  else Result.ClassInheritsFrom := CL.FindClass(InheritsFrom);
end;
  
  
(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBSQL(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TCOMPONENT', 'TIBSQL') do
  with CL.AddClassN(CL.FindClass('TCOMPONENT'),'TIBSQL') do
  begin
    RegisterMethod('Procedure BATCHINPUT( INPUTOBJECT : TIBBATCHINPUT)');
    RegisterMethod('Procedure BATCHOUTPUT( OUTPUTOBJECT : TIBBATCHOUTPUT)');
    RegisterMethod('Function CALL( ERRCODE : ISC_STATUS; RAISEERROR : BOOLEAN) : ISC_STATUS');
    RegisterMethod('Procedure CHECKCLOSED');
    RegisterMethod('Procedure CHECKOPEN');
    RegisterMethod('Procedure CHECKVALIDSTATEMENT');
    RegisterMethod('Procedure CLOSE');
    RegisterMethod('Function CURRENT : TIBXSQLDA');
    RegisterMethod('Procedure EXECQUERY');
    RegisterMethod('Function FIELDBYNAME( FIELDNAME : STRING) : TIBXSQLVAR');
    RegisterMethod('Procedure FREEHANDLE');
    RegisterMethod('Function NEXT : TIBXSQLDA');
    RegisterMethod('Procedure PREPARE');
    RegisterMethod('Function GETUNIQUERELATIONNAME : STRING');
    RegisterMethod('Function PARAMBYNAME( IDX : STRING) : TIBXSQLVAR');
    RegisterProperty('BOF', 'BOOLEAN', iptr);
    RegisterProperty('DBHANDLE', 'PISC_DB_HANDLE', iptr);
    RegisterProperty('EOF', 'BOOLEAN', iptr);
    RegisterProperty('FIELDS', 'TIBXSQLVAR INTEGER', iptr);
    RegisterProperty('FIELDINDEX', 'INTEGER STRING', iptr);
    RegisterProperty('OPEN', 'BOOLEAN', iptr);
    RegisterProperty('PARAMS', 'TIBXSQLDA', iptr);
    RegisterProperty('PLAN', 'STRING', iptr);
    RegisterProperty('PREPARED', 'BOOLEAN', iptr);
    RegisterProperty('RECORDCOUNT', 'INTEGER', iptr);
    RegisterProperty('ROWSAFFECTED', 'INTEGER', iptr);
    RegisterProperty('SQLTYPE', 'TIBSQLTYPES', iptr);
    RegisterProperty('TRHANDLE', 'PISC_TR_HANDLE', iptr);
    RegisterProperty('HANDLE', 'TISC_STMT_HANDLE', iptr);
    RegisterProperty('GENERATEPARAMNAMES', 'BOOLEAN', iptrw);
    RegisterProperty('UNIQUERELATIONNAME', 'STRING', iptr);
    RegisterProperty('DATABASE', 'TIBDATABASE', iptrw);
    RegisterProperty('GOTOFIRSTRECORDONEXECUTE', 'BOOLEAN', iptrw);
    RegisterProperty('PARAMCHECK', 'BOOLEAN', iptrw);
    RegisterProperty('SQL', 'TSTRINGS', iptrw);
    RegisterProperty('TRANSACTION', 'TIBTRANSACTION', iptrw);
    RegisterProperty('ONSQLCHANGING', 'TNOTIFYEVENT', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBOUTPUTXML(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TOBJECT', 'TIBOUTPUTXML') do
  with CL.AddClassN(CL.FindClass('TOBJECT'),'TIBOUTPUTXML') do
  begin
    RegisterMethod('Procedure WRITEXML( SQL : TIBSQL)');
    RegisterProperty('HEADERTAG', 'STRING', iptrw);
    RegisterProperty('DATABASETAG', 'STRING', iptrw);
    RegisterProperty('STREAM', 'TSTREAM', iptrw);
    RegisterProperty('TABLETAG', 'STRING', iptrw);
    RegisterProperty('ROWTAG', 'STRING', iptrw);
    RegisterProperty('FLAGS', 'TIBXMLFLAGS', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBINPUTRAWFILE(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBATCHINPUT', 'TIBINPUTRAWFILE') do
  with CL.AddClassN(CL.FindClass('TIBBATCHINPUT'),'TIBINPUTRAWFILE') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBOUTPUTRAWFILE(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBATCHOUTPUT', 'TIBOUTPUTRAWFILE') do
  with CL.AddClassN(CL.FindClass('TIBBATCHOUTPUT'),'TIBOUTPUTRAWFILE') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBINPUTDELIMITEDFILE(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBATCHINPUT', 'TIBINPUTDELIMITEDFILE') do
  with CL.AddClassN(CL.FindClass('TIBBATCHINPUT'),'TIBINPUTDELIMITEDFILE') do
  begin
    RegisterMethod('Function GETCOLUMN( var COL : STRING) : INTEGER');
    RegisterProperty('COLDELIMITER', 'STRING', iptrw);
    RegisterProperty('READBLANKSASNULL', 'BOOLEAN', iptrw);
    RegisterProperty('ROWDELIMITER', 'STRING', iptrw);
    RegisterProperty('SKIPTITLES', 'BOOLEAN', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBOUTPUTDELIMITEDFILE(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBATCHOUTPUT', 'TIBOUTPUTDELIMITEDFILE') do
  with CL.AddClassN(CL.FindClass('TIBBATCHOUTPUT'),'TIBOUTPUTDELIMITEDFILE') do
  begin
    RegisterProperty('COLDELIMITER', 'STRING', iptrw);
    RegisterProperty('OUTPUTTITLES', 'BOOLEAN', iptrw);
    RegisterProperty('ROWDELIMITER', 'STRING', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBBATCHOUTPUT(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBATCH', 'TIBBATCHOUTPUT') do
  with CL.AddClassN(CL.FindClass('TIBBATCH'),'TIBBATCHOUTPUT') do
  begin
    RegisterMethod('Function WRITECOLUMNS : BOOLEAN');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBBATCHINPUT(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBATCH', 'TIBBATCHINPUT') do
  with CL.AddClassN(CL.FindClass('TIBBATCH'),'TIBBATCHINPUT') do
  begin
    RegisterMethod('Function READPARAMETERS : BOOLEAN');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBBATCH(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TOBJECT', 'TIBBATCH') do
  with CL.AddClassN(CL.FindClass('TOBJECT'),'TIBBATCH') do
  begin
    RegisterMethod('Procedure READYFILE');
    RegisterProperty('COLUMNS', 'TIBXSQLDA', iptrw);
    RegisterProperty('FILENAME', 'STRING', iptrw);
    RegisterProperty('PARAMS', 'TIBXSQLDA', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBXSQLDA(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TOBJECT', 'TIBXSQLDA') do
  with CL.AddClassN(CL.FindClass('TOBJECT'),'TIBXSQLDA') do
  begin
    RegisterMethod('Constructor CREATE( QUERY : TIBSQL)');
    RegisterMethod('Procedure ADDNAME( FIELDNAME : STRING; IDX : INTEGER)');
    RegisterMethod('Function BYNAME( IDX : STRING) : TIBXSQLVAR');
    RegisterProperty('ASXSQLDA', 'PXSQLDA', iptr);
    RegisterProperty('COUNT', 'INTEGER', iptrw);
    RegisterProperty('MODIFIED', 'BOOLEAN', iptr);
    RegisterProperty('NAMES', 'STRING', iptr);
    RegisterProperty('RECORDSIZE', 'INTEGER', iptr);
    RegisterProperty('VARS', 'TIBXSQLVAR INTEGER', iptr);
    SetDefaultPropery('VARS');
    RegisterProperty('UNIQUERELATIONNAME', 'STRING', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBXSQLVAR(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TOBJECT', 'TIBXSQLVAR') do
  with CL.AddClassN(CL.FindClass('TOBJECT'),'TIBXSQLVAR') do
  begin
    RegisterMethod('Constructor CREATE( PARENT : TIBXSQLDA; QUERY : TIBSQL)');
    RegisterMethod('Procedure ASSIGN( SOURCE : TIBXSQLVAR)');
    RegisterMethod('Procedure LOADFROMFILE( const FILENAME : STRING)');
    RegisterMethod('Procedure LOADFROMSTREAM( STREAM : TSTREAM)');
    RegisterMethod('Procedure SAVETOFILE( const FILENAME : STRING)');
    RegisterMethod('Procedure SAVETOSTREAM( STREAM : TSTREAM)');
    RegisterMethod('Procedure CLEAR');
    RegisterProperty('ASDATE', 'TDATETIME', iptrw);
    RegisterProperty('ASTIME', 'TDATETIME', iptrw);
    RegisterProperty('ASDATETIME', 'TDATETIME', iptrw);
    RegisterProperty('ASDOUBLE', 'DOUBLE', iptrw);
    RegisterProperty('ASFLOAT', 'FLOAT', iptrw);
    RegisterProperty('ASCURRENCY', 'CURRENCY', iptrw);
    RegisterProperty('ASINT64', 'INT64', iptrw);
    RegisterProperty('ASINTEGER', 'INTEGER', iptrw);
    RegisterProperty('ASLONG', 'LONG', iptrw);
    RegisterProperty('ASPOINTER', 'POINTER', iptrw);
    RegisterProperty('ASQUAD', 'TISC_QUAD', iptrw);
    RegisterProperty('ASSHORT', 'SHORT', iptrw);
    RegisterProperty('ASSTRING', 'STRING', iptrw);
    RegisterProperty('ASTRIMSTRING', 'STRING', iptrw);
    RegisterProperty('ASVARIANT', 'VARIANT', iptrw);
    RegisterProperty('ASXSQLVAR', 'PXSQLVAR', iptrw);
    RegisterProperty('DATA', 'PXSQLVAR', iptrw);
    RegisterProperty('ISNULL', 'BOOLEAN', iptrw);
    RegisterProperty('ISNULLABLE', 'BOOLEAN', iptrw);
    RegisterProperty('INDEX', 'INTEGER', iptr);
    RegisterProperty('MODIFIED', 'BOOLEAN', iptrw);
    RegisterProperty('NAME', 'STRING', iptr);
    RegisterProperty('SIZE', 'INTEGER', iptr);
    RegisterProperty('SQLTYPE', 'INTEGER', iptr);
    RegisterProperty('VALUE', 'VARIANT', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_IBSQL(CL: TIFPSPascalCompiler);
begin
  CL.AddClassN(CL.FindClass('TOBJECT'),'TIBSQL');
  CL.AddClassN(CL.FindClass('TOBJECT'),'TIBXSQLDA');
  SIRegister_TIBXSQLVAR(CL);
  CL.AddTypeS('TIBXSQLVARARRAY', 'array of TIBXSQLVAR');
  SIRegister_TIBXSQLDA(CL);
  SIRegister_TIBBATCH(CL);
  SIRegister_TIBBATCHINPUT(CL);
  SIRegister_TIBBATCHOUTPUT(CL);
  SIRegister_TIBOUTPUTDELIMITEDFILE(CL);
  SIRegister_TIBINPUTDELIMITEDFILE(CL);
  SIRegister_TIBOUTPUTRAWFILE(CL);
  SIRegister_TIBINPUTRAWFILE(CL);
  CL.AddTypeS('TIBXMLFLAG', '( XMLATTRIBUTE, XMLDISPLAYNULL, XMLNOHEADER )');
  CL.AddTypeS('TIBXMLFLAGS', 'set of TIBXMLFLAG');
  SIRegister_TIBOUTPUTXML(CL);
  CL.AddTypeS('TIBSQLTYPES', '( SQLUNKNOWN, SQLSELECT, SQLINSERT, SQLUPDATE, SQ'
   +'LDELETE, SQLDDL, SQLGETSEGMENT, SQLPUTSEGMENT, SQLEXECPROCEDURE, SQLSTARTT'
   +'RANSACTION, SQLCOMMIT, SQLROLLBACK, SQLSELECTFORUPDATE, SQLSETGENERATOR )');
  SIRegister_TIBSQL(CL);
 CL.AddDelphiFunction('Procedure OUTPUTXML( SQLOBJECT : TIBSQL; OUTPUTOBJECT : TIBOUTPUTXML)');
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TIBSQLONSQLCHANGING_W(Self: TIBSQL; const T: TNOTIFYEVENT);
begin Self.ONSQLCHANGING := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLONSQLCHANGING_R(Self: TIBSQL; var T: TNOTIFYEVENT);
begin T := Self.ONSQLCHANGING; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLTRANSACTION_W(Self: TIBSQL; const T: TIBTRANSACTION);
begin Self.TRANSACTION := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLTRANSACTION_R(Self: TIBSQL; var T: TIBTRANSACTION);
begin T := Self.TRANSACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLSQL_W(Self: TIBSQL; const T: TSTRINGS);
begin Self.SQL := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLSQL_R(Self: TIBSQL; var T: TSTRINGS);
begin T := Self.SQL; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPARAMCHECK_W(Self: TIBSQL; const T: BOOLEAN);
begin Self.PARAMCHECK := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPARAMCHECK_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.PARAMCHECK; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLGOTOFIRSTRECORDONEXECUTE_W(Self: TIBSQL; const T: BOOLEAN);
begin Self.GOTOFIRSTRECORDONEXECUTE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLGOTOFIRSTRECORDONEXECUTE_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.GOTOFIRSTRECORDONEXECUTE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLDATABASE_W(Self: TIBSQL; const T: TIBDATABASE);
begin Self.DATABASE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLDATABASE_R(Self: TIBSQL; var T: TIBDATABASE);
begin T := Self.DATABASE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLUNIQUERELATIONNAME_R(Self: TIBSQL; var T: STRING);
begin T := Self.UNIQUERELATIONNAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLGENERATEPARAMNAMES_W(Self: TIBSQL; const T: BOOLEAN);
begin Self.GENERATEPARAMNAMES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLGENERATEPARAMNAMES_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.GENERATEPARAMNAMES; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLHANDLE_R(Self: TIBSQL; var T: TISC_STMT_HANDLE);
begin T := Self.HANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLTRHANDLE_R(Self: TIBSQL; var T: PISC_TR_HANDLE);
begin T := Self.TRHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLSQLTYPE_R(Self: TIBSQL; var T: TIBSQLTYPES);
begin T := Self.SQLTYPE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLROWSAFFECTED_R(Self: TIBSQL; var T: INTEGER);
begin T := Self.ROWSAFFECTED; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLRECORDCOUNT_R(Self: TIBSQL; var T: INTEGER);
begin T := Self.RECORDCOUNT; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPREPARED_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.PREPARED; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPLAN_R(Self: TIBSQL; var T: STRING);
begin T := Self.PLAN; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPARAMS_R(Self: TIBSQL; var T: TIBXSQLDA);
begin T := Self.PARAMS; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLOPEN_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.OPEN; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLFIELDINDEX_R(Self: TIBSQL; var T: INTEGER; const t1: STRING);
begin T := Self.FIELDINDEX[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLFIELDS_R(Self: TIBSQL; var T: TIBXSQLVAR; const t1: INTEGER);
begin T := Self.FIELDS[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLEOF_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.EOF; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLDBHANDLE_R(Self: TIBSQL; var T: PISC_DB_HANDLE);
begin T := Self.DBHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLBOF_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.BOF; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLFLAGS_W(Self: TIBOUTPUTXML; const T: TIBXMLFLAGS);
begin Self.FLAGS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLFLAGS_R(Self: TIBOUTPUTXML; var T: TIBXMLFLAGS);
begin T := Self.FLAGS; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLROWTAG_W(Self: TIBOUTPUTXML; const T: STRING);
begin Self.ROWTAG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLROWTAG_R(Self: TIBOUTPUTXML; var T: STRING);
begin T := Self.ROWTAG; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLTABLETAG_W(Self: TIBOUTPUTXML; const T: STRING);
begin Self.TABLETAG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLTABLETAG_R(Self: TIBOUTPUTXML; var T: STRING);
begin T := Self.TABLETAG; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLSTREAM_W(Self: TIBOUTPUTXML; const T: TSTREAM);
begin Self.STREAM := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLSTREAM_R(Self: TIBOUTPUTXML; var T: TSTREAM);
begin T := Self.STREAM; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLDATABASETAG_W(Self: TIBOUTPUTXML; const T: STRING);
begin Self.DATABASETAG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLDATABASETAG_R(Self: TIBOUTPUTXML; var T: STRING);
begin T := Self.DATABASETAG; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLHEADERTAG_W(Self: TIBOUTPUTXML; const T: STRING);
begin Self.HEADERTAG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLHEADERTAG_R(Self: TIBOUTPUTXML; var T: STRING);
begin T := Self.HEADERTAG; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILESKIPTITLES_W(Self: TIBINPUTDELIMITEDFILE; const T: BOOLEAN);
begin Self.SKIPTITLES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILESKIPTITLES_R(Self: TIBINPUTDELIMITEDFILE; var T: BOOLEAN);
begin T := Self.SKIPTITLES; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILEROWDELIMITER_W(Self: TIBINPUTDELIMITEDFILE; const T: STRING);
begin Self.ROWDELIMITER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILEROWDELIMITER_R(Self: TIBINPUTDELIMITEDFILE; var T: STRING);
begin T := Self.ROWDELIMITER; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILEREADBLANKSASNULL_W(Self: TIBINPUTDELIMITEDFILE; const T: BOOLEAN);
begin Self.READBLANKSASNULL := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILEREADBLANKSASNULL_R(Self: TIBINPUTDELIMITEDFILE; var T: BOOLEAN);
begin T := Self.READBLANKSASNULL; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILECOLDELIMITER_W(Self: TIBINPUTDELIMITEDFILE; const T: STRING);
begin Self.COLDELIMITER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILECOLDELIMITER_R(Self: TIBINPUTDELIMITEDFILE; var T: STRING);
begin T := Self.COLDELIMITER; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILEROWDELIMITER_W(Self: TIBOUTPUTDELIMITEDFILE; const T: STRING);
begin Self.ROWDELIMITER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILEROWDELIMITER_R(Self: TIBOUTPUTDELIMITEDFILE; var T: STRING);
begin T := Self.ROWDELIMITER; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILEOUTPUTTITLES_W(Self: TIBOUTPUTDELIMITEDFILE; const T: BOOLEAN);
begin Self.OUTPUTTITLES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILEOUTPUTTITLES_R(Self: TIBOUTPUTDELIMITEDFILE; var T: BOOLEAN);
begin T := Self.OUTPUTTITLES; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILECOLDELIMITER_W(Self: TIBOUTPUTDELIMITEDFILE; const T: STRING);
begin Self.COLDELIMITER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILECOLDELIMITER_R(Self: TIBOUTPUTDELIMITEDFILE; var T: STRING);
begin T := Self.COLDELIMITER; end;

(*----------------------------------------------------------------------------*)
procedure TIBBATCHPARAMS_W(Self: TIBBATCH; const T: TIBXSQLDA);
begin Self.PARAMS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBATCHPARAMS_R(Self: TIBBATCH; var T: TIBXSQLDA);
begin T := Self.PARAMS; end;

(*----------------------------------------------------------------------------*)
procedure TIBBATCHFILENAME_W(Self: TIBBATCH; const T: STRING);
begin Self.FILENAME := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBATCHFILENAME_R(Self: TIBBATCH; var T: STRING);
begin T := Self.FILENAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBBATCHCOLUMNS_W(Self: TIBBATCH; const T: TIBXSQLDA);
begin Self.COLUMNS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBATCHCOLUMNS_R(Self: TIBBATCH; var T: TIBXSQLDA);
begin T := Self.COLUMNS; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDAUNIQUERELATIONNAME_R(Self: TIBXSQLDA; var T: STRING);
begin T := Self.UNIQUERELATIONNAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDAVARS_R(Self: TIBXSQLDA; var T: TIBXSQLVAR; const t1: INTEGER);
begin T := Self.VARS[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDARECORDSIZE_R(Self: TIBXSQLDA; var T: INTEGER);
begin T := Self.RECORDSIZE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDANAMES_R(Self: TIBXSQLDA; var T: STRING);
begin T := Self.NAMES; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDAMODIFIED_R(Self: TIBXSQLDA; var T: BOOLEAN);
begin T := Self.MODIFIED; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDACOUNT_W(Self: TIBXSQLDA; const T: INTEGER);
begin Self.COUNT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDACOUNT_R(Self: TIBXSQLDA; var T: INTEGER);
begin T := Self.COUNT; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDAASXSQLDA_R(Self: TIBXSQLDA; var T: PXSQLDA);
begin T := Self.ASXSQLDA; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARVALUE_W(Self: TIBXSQLVAR; const T: VARIANT);
begin Self.VALUE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARVALUE_R(Self: TIBXSQLVAR; var T: VARIANT);
begin T := Self.VALUE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARSQLTYPE_R(Self: TIBXSQLVAR; var T: INTEGER);
begin T := Self.SQLTYPE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARSIZE_R(Self: TIBXSQLVAR; var T: INTEGER);
begin T := Self.SIZE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARNAME_R(Self: TIBXSQLVAR; var T: STRING);
begin T := Self.NAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARMODIFIED_W(Self: TIBXSQLVAR; const T: BOOLEAN);
begin Self.MODIFIED := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARMODIFIED_R(Self: TIBXSQLVAR; var T: BOOLEAN);
begin T := Self.MODIFIED; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARINDEX_R(Self: TIBXSQLVAR; var T: INTEGER);
begin T := Self.INDEX; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARISNULLABLE_W(Self: TIBXSQLVAR; const T: BOOLEAN);
begin Self.ISNULLABLE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARISNULLABLE_R(Self: TIBXSQLVAR; var T: BOOLEAN);
begin T := Self.ISNULLABLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARISNULL_W(Self: TIBXSQLVAR; const T: BOOLEAN);
begin Self.ISNULL := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARISNULL_R(Self: TIBXSQLVAR; var T: BOOLEAN);
begin T := Self.ISNULL; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARDATA_W(Self: TIBXSQLVAR; const T: PXSQLVAR);
begin Self.DATA := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARDATA_R(Self: TIBXSQLVAR; var T: PXSQLVAR);
begin T := Self.DATA; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASXSQLVAR_W(Self: TIBXSQLVAR; const T: PXSQLVAR);
begin Self.ASXSQLVAR := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASXSQLVAR_R(Self: TIBXSQLVAR; var T: PXSQLVAR);
begin T := Self.ASXSQLVAR; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASVARIANT_W(Self: TIBXSQLVAR; const T: VARIANT);
begin Self.ASVARIANT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASVARIANT_R(Self: TIBXSQLVAR; var T: VARIANT);
begin T := Self.ASVARIANT; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASTRIMSTRING_W(Self: TIBXSQLVAR; const T: STRING);
begin Self.ASTRIMSTRING := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASTRIMSTRING_R(Self: TIBXSQLVAR; var T: STRING);
begin T := Self.ASTRIMSTRING; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASSTRING_W(Self: TIBXSQLVAR; const T: STRING);
begin Self.ASSTRING := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASSTRING_R(Self: TIBXSQLVAR; var T: STRING);
begin T := Self.ASSTRING; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASSHORT_W(Self: TIBXSQLVAR; const T: SHORT);
begin Self.ASSHORT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASSHORT_R(Self: TIBXSQLVAR; var T: SHORT);
begin T := Self.ASSHORT; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASQUAD_W(Self: TIBXSQLVAR; const T: TISC_QUAD);
begin Self.ASQUAD := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASQUAD_R(Self: TIBXSQLVAR; var T: TISC_QUAD);
begin T := Self.ASQUAD; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASPOINTER_W(Self: TIBXSQLVAR; const T: POINTER);
begin Self.ASPOINTER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASPOINTER_R(Self: TIBXSQLVAR; var T: POINTER);
begin T := Self.ASPOINTER; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASLONG_W(Self: TIBXSQLVAR; const T: LONG);
begin Self.ASLONG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASLONG_R(Self: TIBXSQLVAR; var T: LONG);
begin T := Self.ASLONG; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASINTEGER_W(Self: TIBXSQLVAR; const T: INTEGER);
begin Self.ASINTEGER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASINTEGER_R(Self: TIBXSQLVAR; var T: INTEGER);
begin T := Self.ASINTEGER; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASINT64_W(Self: TIBXSQLVAR; const T: INT64);
begin Self.ASINT64 := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASINT64_R(Self: TIBXSQLVAR; var T: INT64);
begin T := Self.ASINT64; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASCURRENCY_W(Self: TIBXSQLVAR; const T: CURRENCY);
begin Self.ASCURRENCY := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASCURRENCY_R(Self: TIBXSQLVAR; var T: CURRENCY);
begin T := Self.ASCURRENCY; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASFLOAT_W(Self: TIBXSQLVAR; const T: FLOAT);
begin Self.ASFLOAT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASFLOAT_R(Self: TIBXSQLVAR; var T: FLOAT);
begin T := Self.ASFLOAT; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDOUBLE_W(Self: TIBXSQLVAR; const T: DOUBLE);
begin Self.ASDOUBLE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDOUBLE_R(Self: TIBXSQLVAR; var T: DOUBLE);
begin T := Self.ASDOUBLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDATETIME_W(Self: TIBXSQLVAR; const T: TDATETIME);
begin Self.ASDATETIME := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDATETIME_R(Self: TIBXSQLVAR; var T: TDATETIME);
begin T := Self.ASDATETIME; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASTIME_W(Self: TIBXSQLVAR; const T: TDATETIME);
begin Self.ASTIME := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASTIME_R(Self: TIBXSQLVAR; var T: TDATETIME);
begin T := Self.ASTIME; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDATE_W(Self: TIBXSQLVAR; const T: TDATETIME);
begin Self.ASDATE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDATE_R(Self: TIBXSQLVAR; var T: TDATETIME);
begin T := Self.ASDATE; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IBSQL_Routines(S: TIFPSExec);
begin
 S.RegisterDelphiFunction(@OUTPUTXML, 'OUTPUTXML', cdRegister);
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBSQL(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBSQL) do
  begin
    RegisterMethod(@TIBSQL.BATCHINPUT, 'BATCHINPUT');
    RegisterMethod(@TIBSQL.BATCHOUTPUT, 'BATCHOUTPUT');
    RegisterMethod(@TIBSQL.CALL, 'CALL');
    RegisterMethod(@TIBSQL.CHECKCLOSED, 'CHECKCLOSED');
    RegisterMethod(@TIBSQL.CHECKOPEN, 'CHECKOPEN');
    RegisterMethod(@TIBSQL.CHECKVALIDSTATEMENT, 'CHECKVALIDSTATEMENT');
    RegisterMethod(@TIBSQL.CLOSE, 'CLOSE');
    RegisterMethod(@TIBSQL.CURRENT, 'CURRENT');
    RegisterMethod(@TIBSQL.EXECQUERY, 'EXECQUERY');
    RegisterMethod(@TIBSQL.FIELDBYNAME, 'FIELDBYNAME');
    RegisterMethod(@TIBSQL.FREEHANDLE, 'FREEHANDLE');
    RegisterMethod(@TIBSQL.NEXT, 'NEXT');
    RegisterMethod(@TIBSQL.PREPARE, 'PREPARE');
    RegisterMethod(@TIBSQL.GETUNIQUERELATIONNAME, 'GETUNIQUERELATIONNAME');
    RegisterMethod(@TIBSQL.PARAMBYNAME, 'PARAMBYNAME');
    RegisterPropertyHelper(@TIBSQLBOF_R,nil,'BOF');
    RegisterPropertyHelper(@TIBSQLDBHANDLE_R,nil,'DBHANDLE');
    RegisterPropertyHelper(@TIBSQLEOF_R,nil,'EOF');
    RegisterPropertyHelper(@TIBSQLFIELDS_R,nil,'FIELDS');
    RegisterPropertyHelper(@TIBSQLFIELDINDEX_R,nil,'FIELDINDEX');
    RegisterPropertyHelper(@TIBSQLOPEN_R,nil,'OPEN');
    RegisterPropertyHelper(@TIBSQLPARAMS_R,nil,'PARAMS');
    RegisterPropertyHelper(@TIBSQLPLAN_R,nil,'PLAN');
    RegisterPropertyHelper(@TIBSQLPREPARED_R,nil,'PREPARED');
    RegisterPropertyHelper(@TIBSQLRECORDCOUNT_R,nil,'RECORDCOUNT');
    RegisterPropertyHelper(@TIBSQLROWSAFFECTED_R,nil,'ROWSAFFECTED');
    RegisterPropertyHelper(@TIBSQLSQLTYPE_R,nil,'SQLTYPE');
    RegisterPropertyHelper(@TIBSQLTRHANDLE_R,nil,'TRHANDLE');
    RegisterPropertyHelper(@TIBSQLHANDLE_R,nil,'HANDLE');
    RegisterPropertyHelper(@TIBSQLGENERATEPARAMNAMES_R,@TIBSQLGENERATEPARAMNAMES_W,'GENERATEPARAMNAMES');
    RegisterPropertyHelper(@TIBSQLUNIQUERELATIONNAME_R,nil,'UNIQUERELATIONNAME');
    RegisterPropertyHelper(@TIBSQLDATABASE_R,@TIBSQLDATABASE_W,'DATABASE');
    RegisterPropertyHelper(@TIBSQLGOTOFIRSTRECORDONEXECUTE_R,@TIBSQLGOTOFIRSTRECORDONEXECUTE_W,'GOTOFIRSTRECORDONEXECUTE');
    RegisterPropertyHelper(@TIBSQLPARAMCHECK_R,@TIBSQLPARAMCHECK_W,'PARAMCHECK');
    RegisterPropertyHelper(@TIBSQLSQL_R,@TIBSQLSQL_W,'SQL');
    RegisterPropertyHelper(@TIBSQLTRANSACTION_R,@TIBSQLTRANSACTION_W,'TRANSACTION');
    RegisterEventPropertyHelper(@TIBSQLONSQLCHANGING_R,@TIBSQLONSQLCHANGING_W,'ONSQLCHANGING');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBOUTPUTXML(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBOUTPUTXML) do
  begin
    RegisterMethod(@TIBOUTPUTXML.WRITEXML, 'WRITEXML');
    RegisterPropertyHelper(@TIBOUTPUTXMLHEADERTAG_R,@TIBOUTPUTXMLHEADERTAG_W,'HEADERTAG');
    RegisterPropertyHelper(@TIBOUTPUTXMLDATABASETAG_R,@TIBOUTPUTXMLDATABASETAG_W,'DATABASETAG');
    RegisterPropertyHelper(@TIBOUTPUTXMLSTREAM_R,@TIBOUTPUTXMLSTREAM_W,'STREAM');
    RegisterPropertyHelper(@TIBOUTPUTXMLTABLETAG_R,@TIBOUTPUTXMLTABLETAG_W,'TABLETAG');
    RegisterPropertyHelper(@TIBOUTPUTXMLROWTAG_R,@TIBOUTPUTXMLROWTAG_W,'ROWTAG');
    RegisterPropertyHelper(@TIBOUTPUTXMLFLAGS_R,@TIBOUTPUTXMLFLAGS_W,'FLAGS');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBINPUTRAWFILE(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBINPUTRAWFILE) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBOUTPUTRAWFILE(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBOUTPUTRAWFILE) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBINPUTDELIMITEDFILE(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBINPUTDELIMITEDFILE) do
  begin
    RegisterMethod(@TIBINPUTDELIMITEDFILE.GETCOLUMN, 'GETCOLUMN');
    RegisterPropertyHelper(@TIBINPUTDELIMITEDFILECOLDELIMITER_R,@TIBINPUTDELIMITEDFILECOLDELIMITER_W,'COLDELIMITER');
    RegisterPropertyHelper(@TIBINPUTDELIMITEDFILEREADBLANKSASNULL_R,@TIBINPUTDELIMITEDFILEREADBLANKSASNULL_W,'READBLANKSASNULL');
    RegisterPropertyHelper(@TIBINPUTDELIMITEDFILEROWDELIMITER_R,@TIBINPUTDELIMITEDFILEROWDELIMITER_W,'ROWDELIMITER');
    RegisterPropertyHelper(@TIBINPUTDELIMITEDFILESKIPTITLES_R,@TIBINPUTDELIMITEDFILESKIPTITLES_W,'SKIPTITLES');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBOUTPUTDELIMITEDFILE(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBOUTPUTDELIMITEDFILE) do
  begin
    RegisterPropertyHelper(@TIBOUTPUTDELIMITEDFILECOLDELIMITER_R,@TIBOUTPUTDELIMITEDFILECOLDELIMITER_W,'COLDELIMITER');
    RegisterPropertyHelper(@TIBOUTPUTDELIMITEDFILEOUTPUTTITLES_R,@TIBOUTPUTDELIMITEDFILEOUTPUTTITLES_W,'OUTPUTTITLES');
    RegisterPropertyHelper(@TIBOUTPUTDELIMITEDFILEROWDELIMITER_R,@TIBOUTPUTDELIMITEDFILEROWDELIMITER_W,'ROWDELIMITER');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBBATCHOUTPUT(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBBATCHOUTPUT) do
  begin
    RegisterVirtualAbstractMethod(@TIBBATCHOUTPUT, @!.WRITECOLUMNS, 'WRITECOLUMNS');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBBATCHINPUT(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBBATCHINPUT) do
  begin
    RegisterVirtualAbstractMethod(@TIBBATCHINPUT, @!.READPARAMETERS, 'READPARAMETERS');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBBATCH(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBBATCH) do
  begin
    RegisterVirtualAbstractMethod(@TIBBATCH, @!.READYFILE, 'READYFILE');
    RegisterPropertyHelper(@TIBBATCHCOLUMNS_R,@TIBBATCHCOLUMNS_W,'COLUMNS');
    RegisterPropertyHelper(@TIBBATCHFILENAME_R,@TIBBATCHFILENAME_W,'FILENAME');
    RegisterPropertyHelper(@TIBBATCHPARAMS_R,@TIBBATCHPARAMS_W,'PARAMS');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBXSQLDA(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBXSQLDA) do
  begin
    RegisterConstructor(@TIBXSQLDA.CREATE, 'CREATE');
    RegisterMethod(@TIBXSQLDA.ADDNAME, 'ADDNAME');
    RegisterMethod(@TIBXSQLDA.BYNAME, 'BYNAME');
    RegisterPropertyHelper(@TIBXSQLDAASXSQLDA_R,nil,'ASXSQLDA');
    RegisterPropertyHelper(@TIBXSQLDACOUNT_R,@TIBXSQLDACOUNT_W,'COUNT');
    RegisterPropertyHelper(@TIBXSQLDAMODIFIED_R,nil,'MODIFIED');
    RegisterPropertyHelper(@TIBXSQLDANAMES_R,nil,'NAMES');
    RegisterPropertyHelper(@TIBXSQLDARECORDSIZE_R,nil,'RECORDSIZE');
    RegisterPropertyHelper(@TIBXSQLDAVARS_R,nil,'VARS');
    RegisterPropertyHelper(@TIBXSQLDAUNIQUERELATIONNAME_R,nil,'UNIQUERELATIONNAME');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBXSQLVAR(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBXSQLVAR) do
  begin
    RegisterConstructor(@TIBXSQLVAR.CREATE, 'CREATE');
    RegisterMethod(@TIBXSQLVAR.ASSIGN, 'ASSIGN');
    RegisterMethod(@TIBXSQLVAR.LOADFROMFILE, 'LOADFROMFILE');
    RegisterMethod(@TIBXSQLVAR.LOADFROMSTREAM, 'LOADFROMSTREAM');
    RegisterMethod(@TIBXSQLVAR.SAVETOFILE, 'SAVETOFILE');
    RegisterMethod(@TIBXSQLVAR.SAVETOSTREAM, 'SAVETOSTREAM');
    RegisterMethod(@TIBXSQLVAR.CLEAR, 'CLEAR');
    RegisterPropertyHelper(@TIBXSQLVARASDATE_R,@TIBXSQLVARASDATE_W,'ASDATE');
    RegisterPropertyHelper(@TIBXSQLVARASTIME_R,@TIBXSQLVARASTIME_W,'ASTIME');
    RegisterPropertyHelper(@TIBXSQLVARASDATETIME_R,@TIBXSQLVARASDATETIME_W,'ASDATETIME');
    RegisterPropertyHelper(@TIBXSQLVARASDOUBLE_R,@TIBXSQLVARASDOUBLE_W,'ASDOUBLE');
    RegisterPropertyHelper(@TIBXSQLVARASFLOAT_R,@TIBXSQLVARASFLOAT_W,'ASFLOAT');
    RegisterPropertyHelper(@TIBXSQLVARASCURRENCY_R,@TIBXSQLVARASCURRENCY_W,'ASCURRENCY');
    RegisterPropertyHelper(@TIBXSQLVARASINT64_R,@TIBXSQLVARASINT64_W,'ASINT64');
    RegisterPropertyHelper(@TIBXSQLVARASINTEGER_R,@TIBXSQLVARASINTEGER_W,'ASINTEGER');
    RegisterPropertyHelper(@TIBXSQLVARASLONG_R,@TIBXSQLVARASLONG_W,'ASLONG');
    RegisterPropertyHelper(@TIBXSQLVARASPOINTER_R,@TIBXSQLVARASPOINTER_W,'ASPOINTER');
    RegisterPropertyHelper(@TIBXSQLVARASQUAD_R,@TIBXSQLVARASQUAD_W,'ASQUAD');
    RegisterPropertyHelper(@TIBXSQLVARASSHORT_R,@TIBXSQLVARASSHORT_W,'ASSHORT');
    RegisterPropertyHelper(@TIBXSQLVARASSTRING_R,@TIBXSQLVARASSTRING_W,'ASSTRING');
    RegisterPropertyHelper(@TIBXSQLVARASTRIMSTRING_R,@TIBXSQLVARASTRIMSTRING_W,'ASTRIMSTRING');
    RegisterPropertyHelper(@TIBXSQLVARASVARIANT_R,@TIBXSQLVARASVARIANT_W,'ASVARIANT');
    RegisterPropertyHelper(@TIBXSQLVARASXSQLVAR_R,@TIBXSQLVARASXSQLVAR_W,'ASXSQLVAR');
    RegisterPropertyHelper(@TIBXSQLVARDATA_R,@TIBXSQLVARDATA_W,'DATA');
    RegisterPropertyHelper(@TIBXSQLVARISNULL_R,@TIBXSQLVARISNULL_W,'ISNULL');
    RegisterPropertyHelper(@TIBXSQLVARISNULLABLE_R,@TIBXSQLVARISNULLABLE_W,'ISNULLABLE');
    RegisterPropertyHelper(@TIBXSQLVARINDEX_R,nil,'INDEX');
    RegisterPropertyHelper(@TIBXSQLVARMODIFIED_R,@TIBXSQLVARMODIFIED_W,'MODIFIED');
    RegisterPropertyHelper(@TIBXSQLVARNAME_R,nil,'NAME');
    RegisterPropertyHelper(@TIBXSQLVARSIZE_R,nil,'SIZE');
    RegisterPropertyHelper(@TIBXSQLVARSQLTYPE_R,nil,'SQLTYPE');
    RegisterPropertyHelper(@TIBXSQLVARVALUE_R,@TIBXSQLVARVALUE_W,'VALUE');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IBSQL(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBSQL) do
  with CL.Add(TIBXSQLDA) do
  RIRegister_TIBXSQLVAR(CL);
  RIRegister_TIBXSQLDA(CL);
  RIRegister_TIBBATCH(CL);
  RIRegister_TIBBATCHINPUT(CL);
  RIRegister_TIBBATCHOUTPUT(CL);
  RIRegister_TIBOUTPUTDELIMITEDFILE(CL);
  RIRegister_TIBINPUTDELIMITEDFILE(CL);
  RIRegister_TIBOUTPUTRAWFILE(CL);
  RIRegister_TIBINPUTRAWFILE(CL);
  RIRegister_TIBOUTPUTXML(CL);
  RIRegister_TIBSQL(CL);
end;

 
 
{ TIFPS3CE_IBSQL }
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBSQL.CompOnUses(CompExec: TIFPS3CompExec);
begin
  { nothing } 
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBSQL.ExecOnUses(CompExec: TIFPS3CompExec);
begin
  { nothing } 
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBSQL.CompileImport1(CompExec: TIFPS3CompExec);
begin
  SIRegister_IBSQL(CompExec.Comp);
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBSQL.CompileImport2(CompExec: TIFPS3CompExec);
begin
  { nothing } 
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBSQL.ExecImport1(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter);
begin
  RIRegister_IBSQL(ri);
  RIRegister_IBSQL_Routines(CompExec.Exec); // comment it if no routines
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBSQL.ExecImport2(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter);
begin
  { nothing } 
end;
 
 
initialization
 (**) 
{$IFDEF USEIMPORTER}
CIImporter.AddCallBack(@SIRegister_IBSQL,PT_ClassImport);
{$ENDIF}
finalization
 (**) 
 
end.
