unit uPSI_IBX;
{
This file has been generated by UnitParser v0.4, written by M. Knight.
Source Code from Carlo Kok has been used to implement various sections of
UnitParser. Components of ifps3 are used in the construction of UnitParser,
code implementing the class wrapper is taken from Carlo Kok''s conv unility
}

interface

uses
  SysUtils, Classes, uPSComponent, uPSCompiler, uPSRuntime;

type
  TPSImport_IBX = class(TPSPlugin)
  public
    procedure CompOnUses(CompExec: TPSScript); override;
    procedure ExecOnUses(CompExec: TPSScript); override;
    procedure CompileImport1(CompExec: TPSScript); override;
    procedure CompileImport2(CompExec: TPSScript); override;
    procedure ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter); override;
    procedure ExecImport2(CompExec: TPSScript; const ri: TPSRuntimeClassImporter); override;
  end;



implementation


uses
   WINDOWS
  ,CONTROLS
  ,IBEXTERNALS
  ,IB
  ,IBDatabase
  ,IBHEADER
  ,STDVCL
  ,IBSQL
  ,DB
  ,IBUTILS
  ,IBBLOB
  ,IBCustomDataSet
  ,IBTable
  ,IBQuery
  ;

(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBDATASET(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBCustomDataSet', 'TIBDataSet') do
  with CL.AddClassN(CL.FindClass('TIBCustomDataSet'),'TIBDataSet') do
  begin
    RegisterMethod('procedure Prepare');
    RegisterMethod('procedure UnPrepare');
    RegisterMethod('procedure BatchInput(InputObject: TIBBatchInput)');
    RegisterMethod('procedure BatchOutput(OutputObject: TIBBatchOutput)');
    RegisterMethod('procedure ExecSQL');
    RegisterMethod('function ParamByName(Idx: string): TIBXSQLVAR');
    RegisterProperty('Prepared', 'Boolean', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBCUSTOMDATASET(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TDataSet', 'TIBCustomDataSet') do
  with CL.AddClassN(CL.FindClass('TDataSet'),'TIBCustomDataSet') do
  begin
    RegisterMethod('procedure ApplyUpdates');
    RegisterMethod('function CachedUpdateStatus: TCachedUpdateStatus');
    RegisterMethod('procedure CancelUpdates');
    RegisterMethod('procedure FetchAll');
    RegisterMethod('function LocateNext(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean');
//    RegisterMethod('function Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean');
    RegisterMethod('procedure RecordModified(Value: Boolean)');
    RegisterMethod('procedure RevertRecord');
    RegisterMethod('procedure Undelete');
    RegisterMethod('function Current: TIBXSQLDA');
    RegisterMethod('function SqlType: TIBSQLTypes');
    RegisterProperty('DBHandle', 'PISC_DB_HANDLE', iptr);
    RegisterProperty('TRHandle', 'PISC_TR_HANDLE', iptr);
    RegisterProperty('UpdateObject', 'TIBDataSetUpdateObject', iptrw);
    RegisterProperty('UpdatesPending', 'Boolean', iptr);
    RegisterProperty('UpdateRecordTypes', 'TIBUpdateRecordTypes', iptrw);
    RegisterProperty('RowsAffected', 'Integer', iptr);
    RegisterProperty('Plan', 'string', iptr);
    RegisterProperty('Database', 'TIBDatabase', iptrw);
    RegisterProperty('Transaction', 'TIBTransaction', iptrw);
    RegisterProperty('ForcedRefresh', 'Boolean', iptrw);
    RegisterProperty('OnUpdateError', 'TIBUpdateErrorEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBGENERATORFIELD(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TPersistent', 'TIBGeneratorField') do
  with CL.AddClassN(CL.FindClass('TPersistent'),'TIBGeneratorField') do
  begin
    RegisterMethod('constructor Create(ADataSet: TIBCustomDataSet)');
    RegisterMethod('function ValueName: string');
    RegisterMethod('procedure Apply');
    RegisterProperty('Field', 'string', iptrw);
    RegisterProperty('Generator', 'string', iptrw);
    RegisterProperty('IncrementBy', 'Integer', iptrw);
    RegisterProperty('ApplyEvent', 'TIBGeneratorApplyEvent', iptrw);
  end;
end;

(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBBASE(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TObject', 'TIBBase') do
  with CL.AddClassN(CL.FindClass('TObject'),'TIBBase') do
  begin
    RegisterMethod('constructor Create(AOwner: TObject)');
    RegisterMethod('procedure CheckDatabase');
    RegisterMethod('procedure CheckTransaction');
    RegisterProperty('BeforeDatabaseDisconnect', 'TNotifyEvent', iptrw);
    RegisterProperty('AfterDatabaseDisconnect', 'TNotifyEvent', iptrw);
    RegisterProperty('OnDatabaseFree', 'TNotifyEvent', iptrw);
    RegisterProperty('BeforeTransactionEnd', 'TNotifyEvent', iptrw);
    RegisterProperty('AfterTransactionEnd', 'TNotifyEvent', iptrw);
    RegisterProperty('OnTransactionFree', 'TNotifyEvent', iptrw);
    RegisterProperty('Database', 'TIBDatabase', iptrw);
    RegisterProperty('DBHandle', 'PISC_DB_HANDLE', iptr);
    RegisterProperty('Owner', 'TObject', iptr);
    RegisterProperty('TRHandle', 'PISC_TR_HANDLE', iptr);
    RegisterProperty('Transaction', 'TIBTransaction', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBTRANSACTION(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TComponent', 'TIBTransaction') do
  with CL.AddClassN(CL.FindClass('TComponent'),'TIBTransaction') do
  begin
    RegisterMethod('function Call(ErrCode: ISC_STATUS; RaiseError: Boolean): ISC_STATUS');
    RegisterMethod('procedure Commit');
    RegisterMethod('procedure CommitRetaining');
    RegisterMethod('procedure Rollback');
    RegisterMethod('procedure RollbackRetaining');
    RegisterMethod('procedure StartTransaction');
    RegisterMethod('procedure CheckInTransaction');
    RegisterMethod('procedure CheckNotInTransaction');
    RegisterMethod('procedure CheckAutoStop');
    RegisterMethod('function AddDatabase(DB: TIBDatabase): Integer');
    RegisterMethod('function FindDatabase(DB: TIBDatabase): Integer');
    RegisterMethod('function FindDefaultDatabase: TIBDatabase');
    RegisterMethod('procedure RemoveDatabase(Idx: Integer)');
    RegisterMethod('procedure RemoveDatabases');
    RegisterMethod('procedure CheckDatabasesInList');
    RegisterProperty('DatabaseCount', 'Integer', iptr);
    RegisterProperty('Databases', 'TIBDatabase Integer', iptr);
    RegisterProperty('SQLObjectCount', 'Integer', iptr);
    RegisterProperty('SQLObjects', 'TIBBase Integer', iptr);
    RegisterProperty('Handle', 'TISC_TR_HANDLE', iptr);
    RegisterProperty('HandleIsShared', 'Boolean', iptr);
    RegisterProperty('InTransaction', 'Boolean', iptr);
    RegisterProperty('TPB', 'PChar', iptr);
    RegisterProperty('TPBLength', 'SHORT', iptr);
    RegisterProperty('Active', 'Boolean', iptrw);
    RegisterProperty('DefaultDatabase', 'TIBDatabase', iptrw);
    RegisterProperty('IdleTimer', 'Integer', iptrw);
    RegisterProperty('DefaultAction', 'TTransactionAction', iptrw);
    RegisterProperty('Params', 'TStrings', iptrw);
    RegisterProperty('AutoStopAction', 'TAutoStopAction', iptrw);
    RegisterProperty('OnIdleTimer', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBDATABASE(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TCustomConnection', 'TIBDatabase') do
  with CL.AddClassN(CL.FindClass('TCustomConnection'),'TIBDatabase') do
  begin
    RegisterMethod('procedure AddEventNotifier(Notifier: IIBEventNotifier)');
    RegisterMethod('procedure RemoveEventNotifier(Notifier: IIBEventNotifier)');
    RegisterMethod('procedure ApplyUpdates(const DATASETS: array of TDataSet)');
    RegisterMethod('procedure CloseDataSets');
    RegisterMethod('procedure CheckActive');
    RegisterMethod('procedure CheckInactive');
    RegisterMethod('procedure CreateDatabase');
    RegisterMethod('procedure DropDatabase');
    RegisterMethod('procedure ForceClose');
    RegisterMethod('procedure GetFieldNames(const TableName: string; List: TStrings)');
    RegisterMethod('procedure GetTableNames(List: TStrings; SystemTables: Boolean)');
    RegisterMethod('function IndexOfDBConst(ST: string): Integer');
    RegisterMethod('function TestConnected: Boolean');
    RegisterMethod('procedure CheckDatabaseName');
    RegisterMethod('function Call(ErrCode: ISC_STATUS; RaiseError: Boolean): ISC_STATUS');
    RegisterMethod('function AddTransaction(TR: TIBTransaction): Integer');
    RegisterMethod('function FindTransaction(TR: TIBTransaction): Integer');
    RegisterMethod('function FindDefaultTransaction(): TIBTransaction');
    RegisterMethod('procedure RemoveTransaction(Idx: Integer)');
    RegisterMethod('procedure RemoveTransactions');
    RegisterMethod('procedure SetHandle(Value: TISC_DB_HANDLE)');
    RegisterMethod('procedure Open');
    RegisterMethod('procedure Close');
    RegisterProperty('Connected','Boolean',iptrw);
    RegisterProperty('Handle', 'TISC_DB_HANDLE', iptr);
    RegisterProperty('IsReadOnly', 'Boolean', iptr);
    RegisterProperty('DBParamByDPB', 'string Integer', iptrw);
    RegisterProperty('SQLObjectCount', 'Integer', iptr);
    RegisterProperty('SQLObjects', 'TIBBase Integer', iptr);
    RegisterProperty('HandleIsShared', 'Boolean', iptr);
    RegisterProperty('TransactionCount', 'Integer', iptr);
    RegisterProperty('Transactions', 'TIBTransaction Integer', iptr);
    RegisterProperty('InternalTransaction', 'TIBTransaction', iptr);
    RegisterMethod('function Has_DEFAULT_VALUE(Relation, Field: string): Boolean');
    RegisterMethod('function Has_COMPUTED_BLR(Relation, Field: string): Boolean');
    RegisterMethod('procedure FlushSchema');
    RegisterProperty('DatabaseName', 'TIBFileName', iptrw);
    RegisterProperty('Params', 'TStrings', iptrw);
    RegisterProperty('DefaultTransaction', 'TIBTransaction', iptrw);
    RegisterProperty('IdleTimer', 'Integer', iptrw);
    RegisterProperty('SQLDialect', 'Integer', iptrw);
    RegisterProperty('DBSQLDialect', 'Integer', iptr);
    RegisterProperty('TraceFlags', 'TTraceFlags', iptrw);
    RegisterProperty('AllowStreamedConnected', 'Boolean', iptrw);
    RegisterProperty('OnLogin', 'TIBDatabaseLoginEvent', iptrw);
    RegisterProperty('OnIdleTimer', 'TNotifyEvent', iptrw);
    RegisterProperty('OnDialectDowngradeWarning', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBSCHEMA(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TObject', 'TIBSchema') do
  with CL.AddClassN(CL.FindClass('TObject'),'TIBSchema') do
  begin
    RegisterMethod('procedure FreeNodes');
    RegisterMethod('function Has_DEFAULT_VALUE(Relation, Field: string): Boolean');
    RegisterMethod('function Has_COMPUTED_BLR(Relation, Field: string): Boolean');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_IBDatabase(CL: TPSPascalCompiler);
begin
  CL.AddClassN(CL.FindClass('TObject'),'TIBDatabase');
  CL.AddClassN(CL.FindClass('TObject'),'TIBTransaction');
  CL.AddClassN(CL.FindClass('TObject'),'TIBBase');
  CL.AddTypeS('TIBDatabaseLoginEvent', 'procedure (Database: TIBDatabase; LoginParams: TStrings)');

  SIRegister_TIBSCHEMA(CL);
  CL.AddTypeS('TIBFileName', 'string');
  SIRegister_TIBDATABASE(CL);
  CL.AddTypeS('TTransactionAction', '(TARollback, TACommit, TARollbackRetaining, TACommitRetaining)');

  CL.AddTypeS('TAutoStopAction', '(saNone, saRollback, saCommit, saRollbackRetaining, saCommitRetaining)');

  SIRegister_TIBTRANSACTION(CL);
  SIRegister_TIBBASE(CL);
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TIBBASETRANSACTION_W(Self: TIBBASE; const T: TIBTRANSACTION);
begin Self.TRANSACTION := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASETRANSACTION_R(Self: TIBBASE; var T: TIBTRANSACTION);
begin T := Self.TRANSACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASETRHANDLE_R(Self: TIBBASE; var T: PISC_TR_HANDLE);
begin T := Self.TRHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEOWNER_R(Self: TIBBASE; var T: TOBJECT);
begin T := Self.OWNER; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEDBHANDLE_R(Self: TIBBASE; var T: PISC_DB_HANDLE);
begin T := Self.DBHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEDATABASE_W(Self: TIBBASE; const T: TIBDATABASE);
begin Self.DATABASE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEDATABASE_R(Self: TIBBASE; var T: TIBDATABASE);
begin T := Self.DATABASE; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEONTRANSACTIONFREE_W(Self: TIBBASE; const T: TNOTIFYEVENT);
begin Self.ONTRANSACTIONFREE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEONTRANSACTIONFREE_R(Self: TIBBASE; var T: TNOTIFYEVENT);
begin T := Self.ONTRANSACTIONFREE; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEAFTERTRANSACTIONEND_W(Self: TIBBASE; const T: TNOTIFYEVENT);
begin Self.AFTERTRANSACTIONEND := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEAFTERTRANSACTIONEND_R(Self: TIBBASE; var T: TNOTIFYEVENT);
begin T := Self.AFTERTRANSACTIONEND; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEBEFORETRANSACTIONEND_W(Self: TIBBASE; const T: TNOTIFYEVENT);
begin Self.BEFORETRANSACTIONEND := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEBEFORETRANSACTIONEND_R(Self: TIBBASE; var T: TNOTIFYEVENT);
begin T := Self.BEFORETRANSACTIONEND; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEONDATABASEFREE_W(Self: TIBBASE; const T: TNOTIFYEVENT);
begin Self.ONDATABASEFREE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEONDATABASEFREE_R(Self: TIBBASE; var T: TNOTIFYEVENT);
begin T := Self.ONDATABASEFREE; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEAFTERDATABASEDISCONNECT_W(Self: TIBBASE; const T: TNOTIFYEVENT);
begin Self.AFTERDATABASEDISCONNECT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEAFTERDATABASEDISCONNECT_R(Self: TIBBASE; var T: TNOTIFYEVENT);
begin T := Self.AFTERDATABASEDISCONNECT; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEBEFOREDATABASEDISCONNECT_W(Self: TIBBASE; const T: TNOTIFYEVENT);
begin Self.BEFOREDATABASEDISCONNECT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBBASEBEFOREDATABASEDISCONNECT_R(Self: TIBBASE; var T: TNOTIFYEVENT);
begin T := Self.BEFOREDATABASEDISCONNECT; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONONIDLETIMER_W(Self: TIBTRANSACTION; const T: TNOTIFYEVENT);
begin Self.ONIDLETIMER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONONIDLETIMER_R(Self: TIBTRANSACTION; var T: TNOTIFYEVENT);
begin T := Self.ONIDLETIMER; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONAUTOSTOPACTION_W(Self: TIBTRANSACTION; const T: TAUTOSTOPACTION);
begin Self.AUTOSTOPACTION := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONAUTOSTOPACTION_R(Self: TIBTRANSACTION; var T: TAUTOSTOPACTION);
begin T := Self.AUTOSTOPACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONPARAMS_W(Self: TIBTRANSACTION; const T: TSTRINGS);
begin Self.PARAMS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONPARAMS_R(Self: TIBTRANSACTION; var T: TSTRINGS);
begin T := Self.PARAMS; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONDEFAULTACTION_W(Self: TIBTRANSACTION; const T: TTRANSACTIONACTION);
begin Self.DEFAULTACTION := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONDEFAULTACTION_R(Self: TIBTRANSACTION; var T: TTRANSACTIONACTION);
begin T := Self.DEFAULTACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONIDLETIMER_W(Self: TIBTRANSACTION; const T: INTEGER);
begin Self.IDLETIMER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONIDLETIMER_R(Self: TIBTRANSACTION; var T: INTEGER);
begin T := Self.IDLETIMER; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONDEFAULTDATABASE_W(Self: TIBTRANSACTION; const T: TIBDATABASE);
begin Self.DEFAULTDATABASE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONDEFAULTDATABASE_R(Self: TIBTRANSACTION; var T: TIBDATABASE);
begin T := Self.DEFAULTDATABASE; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONACTIVE_W(Self: TIBTRANSACTION; const T: BOOLEAN);
begin Self.ACTIVE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONACTIVE_R(Self: TIBTRANSACTION; var T: BOOLEAN);
begin T := Self.ACTIVE; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONTPBLENGTH_R(Self: TIBTRANSACTION; var T: SHORT);
begin T := Self.TPBLENGTH; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONTPB_R(Self: TIBTRANSACTION; var T: PCHAR);
begin T := Self.TPB; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONINTRANSACTION_R(Self: TIBTRANSACTION; var T: BOOLEAN);
begin T := Self.INTRANSACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONHANDLEISSHARED_R(Self: TIBTRANSACTION; var T: BOOLEAN);
begin T := Self.HANDLEISSHARED; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONHANDLE_R(Self: TIBTRANSACTION; var T: TISC_TR_HANDLE);
begin T := Self.HANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONSQLOBJECTS_R(Self: TIBTRANSACTION; var T: TIBBASE; const t1: INTEGER);
begin T := Self.SQLOBJECTS[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONSQLOBJECTCOUNT_R(Self: TIBTRANSACTION; var T: INTEGER);
begin T := Self.SQLOBJECTCOUNT; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONDATABASES_R(Self: TIBTRANSACTION; var T: TIBDATABASE; const t1: INTEGER);
begin T := Self.DATABASES[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBTRANSACTIONDATABASECOUNT_R(Self: TIBTRANSACTION; var T: INTEGER);
begin T := Self.DATABASECOUNT; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEONDIALECTDOWNGRADEWARNING_W(Self: TIBDATABASE; const T: TNOTIFYEVENT);
begin Self.ONDIALECTDOWNGRADEWARNING := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEONDIALECTDOWNGRADEWARNING_R(Self: TIBDATABASE; var T: TNOTIFYEVENT);
begin T := Self.ONDIALECTDOWNGRADEWARNING; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEONIDLETIMER_W(Self: TIBDATABASE; const T: TNOTIFYEVENT);
begin Self.ONIDLETIMER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEONIDLETIMER_R(Self: TIBDATABASE; var T: TNOTIFYEVENT);
begin T := Self.ONIDLETIMER; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEONLOGIN_W(Self: TIBDATABASE; const T: TIBDATABASELOGINEVENT);
begin Self.ONLOGIN := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEONLOGIN_R(Self: TIBDATABASE; var T: TIBDATABASELOGINEVENT);
begin T := Self.ONLOGIN; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASECONNECTED_W(Self: TIBDATABASE; const T: Boolean);
begin Self.Connected := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASECONNECTED_R(Self: TIBDATABASE; var T: Boolean);
begin T := Self.Connected; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEALLOWSTREAMEDCONNECTED_W(Self: TIBDATABASE; const T: BOOLEAN);
begin Self.ALLOWSTREAMEDCONNECTED := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEALLOWSTREAMEDCONNECTED_R(Self: TIBDATABASE; var T: BOOLEAN);
begin T := Self.ALLOWSTREAMEDCONNECTED; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASETRACEFLAGS_W(Self: TIBDATABASE; const T: TTRACEFLAGS);
begin Self.TRACEFLAGS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASETRACEFLAGS_R(Self: TIBDATABASE; var T: TTRACEFLAGS);
begin T := Self.TRACEFLAGS; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEDBSQLDIALECT_R(Self: TIBDATABASE; var T: INTEGER);
begin T := Self.DBSQLDIALECT; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASESQLDIALECT_W(Self: TIBDATABASE; const T: INTEGER);
begin Self.SQLDIALECT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASESQLDIALECT_R(Self: TIBDATABASE; var T: INTEGER);
begin T := Self.SQLDIALECT; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEIDLETIMER_W(Self: TIBDATABASE; const T: INTEGER);
begin Self.IDLETIMER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEIDLETIMER_R(Self: TIBDATABASE; var T: INTEGER);
begin T := Self.IDLETIMER; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEDEFAULTTRANSACTION_W(Self: TIBDATABASE; const T: TIBTRANSACTION);
begin Self.DEFAULTTRANSACTION := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEDEFAULTTRANSACTION_R(Self: TIBDATABASE; var T: TIBTRANSACTION);
begin T := Self.DEFAULTTRANSACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEPARAMS_W(Self: TIBDATABASE; const T: TSTRINGS);
begin Self.PARAMS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEPARAMS_R(Self: TIBDATABASE; var T: TSTRINGS);
begin T := Self.PARAMS; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEDATABASENAME_W(Self: TIBDATABASE; const T: TIBFILENAME);
begin Self.DATABASENAME := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEDATABASENAME_R(Self: TIBDATABASE; var T: TIBFILENAME);
begin T := Self.DATABASENAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEINTERNALTRANSACTION_R(Self: TIBDATABASE; var T: TIBTRANSACTION);
begin T := Self.INTERNALTRANSACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASETRANSACTIONS_R(Self: TIBDATABASE; var T: TIBTRANSACTION; const t1: INTEGER);
begin T := Self.TRANSACTIONS[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASETRANSACTIONCOUNT_R(Self: TIBDATABASE; var T: INTEGER);
begin T := Self.TRANSACTIONCOUNT; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEHANDLEISSHARED_R(Self: TIBDATABASE; var T: BOOLEAN);
begin T := Self.HANDLEISSHARED; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASESQLOBJECTS_R(Self: TIBDATABASE; var T: TIBBASE; const t1: INTEGER);
begin T := Self.SQLOBJECTS[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASESQLOBJECTCOUNT_R(Self: TIBDATABASE; var T: INTEGER);
begin T := Self.SQLOBJECTCOUNT; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEDBPARAMBYDPB_W(Self: TIBDATABASE; const T: STRING; const t1: INTEGER);
begin Self.DBPARAMBYDPB[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEDBPARAMBYDPB_R(Self: TIBDATABASE; var T: STRING; const t1: INTEGER);
begin T := Self.DBPARAMBYDPB[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEISREADONLY_R(Self: TIBDATABASE; var T: BOOLEAN);
begin T := Self.ISREADONLY; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATABASEHANDLE_R(Self: TIBDATABASE; var T: TISC_DB_HANDLE);
begin T := Self.HANDLE; end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBDATALINK(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TDetailDataLink', 'TIBDataLink') do
  with CL.AddClassN(CL.FindClass('TDetailDataLink'),'TIBDataLink') do
  begin
    RegisterMethod('constructor Create(ADataSet: TIBCustomDataSet)');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBBCDFIELD(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TBCDField', 'TIBBCDField') do
  with CL.AddClassN(CL.FindClass('TBCDField'),'TIBBCDField') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBSTRINGFIELD(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TStringField', 'TIBStringField') do
  with CL.AddClassN(CL.FindClass('TStringField'),'TIBStringField') do
  begin
    RegisterMethod('function GetValue(var Value: string): Boolean');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBDATASETUPDATEOBJECT(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TComponent', 'TIBDataSetUpdateObject') do
  with CL.AddClassN(CL.FindClass('TComponent'),'TIBDataSetUpdateObject') do
  begin
    RegisterProperty('RefreshSQL', 'TStrings', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_IBCustomDataSet(CL: TPSPascalCompiler);
begin
 CL.AddConstantN('BufferCacheSize','LongInt').SetInt( 1000);
 CL.AddConstantN('UniCache','LongInt').SetInt( 2);
  CL.AddClassN(CL.FindClass('TObject'),'TIBCustomDataSet');
  CL.AddClassN(CL.FindClass('TObject'),'TIBDataSet');
  SIRegister_TIBDATASETUPDATEOBJECT(CL);
  CL.AddTypeS('TCachedUpdateStatus', '(cusUnmodified, cusModified, cusInserted, cusDeleted, cusUninserted)');

  SIRegister_TIBSTRINGFIELD(CL);
  SIRegister_TIBBCDFIELD(CL);
  SIRegister_TIBDATALINK(CL);
  CL.AddTypeS('TIBGeneratorApplyEvent', '(gamOnNewRecord, gamOnPost, gamOnServer)');

  SIRegister_TIBGENERATORFIELD(CL);
  CL.AddTypeS('TIBUpdateAction', '(uaFail, uaAbort, uaSkip, uaRetry, uaApply, uaApplied)');

  CL.AddTypeS('TIBUpdateRecordTypes', 'set of TCachedUpdateStatus');
  CL.AddTypeS('TLiveMode', '(lmInsert, lmModify, lmDelete, lmRefresh)');
  CL.AddTypeS('TLiveModes', 'set of TLiveMode');
  SIRegister_TIBCUSTOMDATASET(CL);
  SIRegister_TIBDATASET(CL);
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TIBDATASETPREPARED_R(Self: TIBDATASET; var T: BOOLEAN);
begin T := Self.PREPARED; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETFORCEDREFRESH_W(Self: TIBCUSTOMDATASET; const T: BOOLEAN);
begin Self.FORCEDREFRESH := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETFORCEDREFRESH_R(Self: TIBCUSTOMDATASET; var T: BOOLEAN);
begin T := Self.FORCEDREFRESH; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETTRANSACTION_W(Self: TIBCUSTOMDATASET; const T: TIBTRANSACTION);
begin Self.TRANSACTION := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETTRANSACTION_R(Self: TIBCUSTOMDATASET; var T: TIBTRANSACTION);
begin T := Self.TRANSACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETDATABASE_W(Self: TIBCUSTOMDATASET; const T: TIBDATABASE);
begin Self.DATABASE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETDATABASE_R(Self: TIBCUSTOMDATASET; var T: TIBDATABASE);
begin T := Self.DATABASE; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETPLAN_R(Self: TIBCUSTOMDATASET; var T: STRING);
begin T := Self.PLAN; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETROWSAFFECTED_R(Self: TIBCUSTOMDATASET; var T: INTEGER);
begin T := Self.ROWSAFFECTED; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATERECORDTYPES_W(Self: TIBCUSTOMDATASET; const T: TIBUPDATERECORDTYPES);
begin Self.UPDATERECORDTYPES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATERECORDTYPES_R(Self: TIBCUSTOMDATASET; var T: TIBUPDATERECORDTYPES);
begin T := Self.UPDATERECORDTYPES; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATESPENDING_R(Self: TIBCUSTOMDATASET; var T: BOOLEAN);
begin T := Self.UPDATESPENDING; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATEOBJECT_W(Self: TIBCUSTOMDATASET; const T: TIBDATASETUPDATEOBJECT);
begin Self.UPDATEOBJECT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATEOBJECT_R(Self: TIBCUSTOMDATASET; var T: TIBDATASETUPDATEOBJECT);
begin T := Self.UPDATEOBJECT; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETTRHANDLE_R(Self: TIBCUSTOMDATASET; var T: PISC_TR_HANDLE);
begin T := Self.TRHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETDBHANDLE_R(Self: TIBCUSTOMDATASET; var T: PISC_DB_HANDLE);
begin T := Self.DBHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDAPPLYEVENT_W(Self: TIBGENERATORFIELD; const T: TIBGENERATORAPPLYEVENT);
begin Self.APPLYEVENT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDAPPLYEVENT_R(Self: TIBGENERATORFIELD; var T: TIBGENERATORAPPLYEVENT);
begin T := Self.APPLYEVENT; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDINCREMENTBY_W(Self: TIBGENERATORFIELD; const T: INTEGER);
begin Self.INCREMENTBY := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDINCREMENTBY_R(Self: TIBGENERATORFIELD; var T: INTEGER);
begin T := Self.INCREMENTBY; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDGENERATOR_W(Self: TIBGENERATORFIELD; const T: STRING);
begin Self.GENERATOR := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDGENERATOR_R(Self: TIBGENERATORFIELD; var T: STRING);
begin T := Self.GENERATOR; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDFIELD_W(Self: TIBGENERATORFIELD; const T: STRING);
begin Self.FIELD := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDFIELD_R(Self: TIBGENERATORFIELD; var T: STRING);
begin T := Self.FIELD; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATASETUPDATEOBJECTREFRESHSQL_W(Self: TIBDATASETUPDATEOBJECT; const T: TSTRINGS);
begin Self.REFRESHSQL := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATASETUPDATEOBJECTREFRESHSQL_R(Self: TIBDATASETUPDATEOBJECT; var T: TSTRINGS);
begin T := Self.REFRESHSQL; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBDATASET(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBDATASET) do
  begin
    RegisterMethod(@TIBDATASET.PREPARE, 'Prepare');
    RegisterMethod(@TIBDATASET.UNPREPARE, 'UnPrepare');
    RegisterMethod(@TIBDATASET.BATCHINPUT, 'BatchInput');
    RegisterMethod(@TIBDATASET.BATCHOUTPUT, 'BatchOutput');
    RegisterMethod(@TIBDATASET.EXECSQL, 'ExecSQL');
    RegisterMethod(@TIBDATASET.PARAMBYNAME, 'ParamByName');
    RegisterPropertyHelper(@TIBDATASETPREPARED_R,nil,'Prepared');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBCUSTOMDATASET(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBCUSTOMDATASET) do
  begin
    RegisterMethod(@TIBCUSTOMDATASET.APPLYUPDATES, 'ApplyUpdates');
    RegisterMethod(@TIBCUSTOMDATASET.CACHEDUPDATESTATUS, 'CachedUpdateStatus');
    RegisterMethod(@TIBCUSTOMDATASET.CANCELUPDATES, 'CancelUpdates');
    RegisterMethod(@TIBCUSTOMDATASET.FETCHALL, 'FetchAll');
    RegisterMethod(@TIBCUSTOMDATASET.LOCATENEXT, 'LocateNext');
//    RegisterMethod(@TIBCUSTOMDATASET.LOCATE, 'Locate');
    RegisterMethod(@TIBCUSTOMDATASET.RECORDMODIFIED, 'RecordModified');
    RegisterMethod(@TIBCUSTOMDATASET.REVERTRECORD, 'RevertRecord');
    RegisterMethod(@TIBCUSTOMDATASET.UNDELETE, 'Undelete');
    RegisterMethod(@TIBCUSTOMDATASET.CURRENT, 'Current');
    RegisterMethod(@TIBCUSTOMDATASET.SQLTYPE, 'SqlType');
    RegisterPropertyHelper(@TIBCUSTOMDATASETDBHANDLE_R,nil,'DBHandle');
    RegisterPropertyHelper(@TIBCUSTOMDATASETTRHANDLE_R,nil,'TRHandle');
    RegisterPropertyHelper(@TIBCUSTOMDATASETUPDATEOBJECT_R,@TIBCUSTOMDATASETUPDATEOBJECT_W,'UpdateObject');
    RegisterPropertyHelper(@TIBCUSTOMDATASETUPDATESPENDING_R,nil,'UpdatesPending');
    RegisterPropertyHelper(@TIBCUSTOMDATASETUPDATERECORDTYPES_R,@TIBCUSTOMDATASETUPDATERECORDTYPES_W,'UpdateRecordTypes');
    RegisterPropertyHelper(@TIBCUSTOMDATASETROWSAFFECTED_R,nil,'RowsAffected');
    RegisterPropertyHelper(@TIBCUSTOMDATASETPLAN_R,nil,'Plan');
    RegisterPropertyHelper(@TIBCUSTOMDATASETDATABASE_R,@TIBCUSTOMDATASETDATABASE_W,'Database');
    RegisterPropertyHelper(@TIBCUSTOMDATASETTRANSACTION_R,@TIBCUSTOMDATASETTRANSACTION_W,'Transaction');
    RegisterPropertyHelper(@TIBCUSTOMDATASETFORCEDREFRESH_R,@TIBCUSTOMDATASETFORCEDREFRESH_W,'ForcedRefresh');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBGENERATORFIELD(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBGENERATORFIELD) do
  begin
    RegisterConstructor(@TIBGENERATORFIELD.CREATE, 'Create');
    RegisterMethod(@TIBGENERATORFIELD.VALUENAME, 'ValueName');
    RegisterMethod(@TIBGENERATORFIELD.APPLY, 'Apply');
    RegisterPropertyHelper(@TIBGENERATORFIELDFIELD_R,@TIBGENERATORFIELDFIELD_W,'Field');
    RegisterPropertyHelper(@TIBGENERATORFIELDGENERATOR_R,@TIBGENERATORFIELDGENERATOR_W,'Generator');
    RegisterPropertyHelper(@TIBGENERATORFIELDINCREMENTBY_R,@TIBGENERATORFIELDINCREMENTBY_W,'IncrementBy');
    RegisterPropertyHelper(@TIBGENERATORFIELDAPPLYEVENT_R,@TIBGENERATORFIELDAPPLYEVENT_W,'ApplyEvent');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBDATALINK(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBDATALINK) do
  begin
    RegisterConstructor(@TIBDATALINK.CREATE, 'Create');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBBCDFIELD(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBBCDFIELD) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBSTRINGFIELD(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBSTRINGFIELD) do
  begin
    RegisterMethod(@TIBSTRINGFIELD.GETVALUE, 'GetValue');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBDATASETUPDATEOBJECT(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBDATASETUPDATEOBJECT) do
  begin
    RegisterPropertyHelper(@TIBDATASETUPDATEOBJECTREFRESHSQL_R,@TIBDATASETUPDATEOBJECTREFRESHSQL_W,'RefreshSQL');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IBCustomDataSet(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBCUSTOMDATASET) do
  with CL.Add(TIBDATASET) do
  RIRegister_TIBDATASETUPDATEOBJECT(CL);
  RIRegister_TIBSTRINGFIELD(CL);
  RIRegister_TIBBCDFIELD(CL);
  RIRegister_TIBDATALINK(CL);
  RIRegister_TIBGENERATORFIELD(CL);
  RIRegister_TIBCUSTOMDATASET(CL);
  RIRegister_TIBDATASET(CL);
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBBASE(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBBASE) do
  begin
    RegisterConstructor(@TIBBASE.CREATE, 'Create');
    RegisterVirtualMethod(@TIBBASE.CHECKDATABASE, 'CheckDatabase');
    RegisterVirtualMethod(@TIBBASE.CHECKTRANSACTION, 'CheckTransaction');
    RegisterPropertyHelper(@TIBBASEBEFOREDATABASEDISCONNECT_R,@TIBBASEBEFOREDATABASEDISCONNECT_W,'BeforeDatabaseDisconnect');
    RegisterPropertyHelper(@TIBBASEAFTERDATABASEDISCONNECT_R,@TIBBASEAFTERDATABASEDISCONNECT_W,'AfterDatabaseDisconnect');
    RegisterEventPropertyHelper(@TIBBASEONDATABASEFREE_R,@TIBBASEONDATABASEFREE_W,'OnDatabaseFree');
    RegisterPropertyHelper(@TIBBASEBEFORETRANSACTIONEND_R,@TIBBASEBEFORETRANSACTIONEND_W,'BeforeTransactionEnd');
    RegisterPropertyHelper(@TIBBASEAFTERTRANSACTIONEND_R,@TIBBASEAFTERTRANSACTIONEND_W,'AfterTransactionEnd');
    RegisterEventPropertyHelper(@TIBBASEONTRANSACTIONFREE_R,@TIBBASEONTRANSACTIONFREE_W,'OnTransactionFree');
    RegisterPropertyHelper(@TIBBASEDATABASE_R,@TIBBASEDATABASE_W,'Database');
    RegisterPropertyHelper(@TIBBASEDBHANDLE_R,nil,'DBHandle');
    RegisterPropertyHelper(@TIBBASEOWNER_R,nil,'Owner');
    RegisterPropertyHelper(@TIBBASETRHANDLE_R,nil,'TRHandle');
    RegisterPropertyHelper(@TIBBASETRANSACTION_R,@TIBBASETRANSACTION_W,'Transaction');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBTRANSACTION(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBTRANSACTION) do
  begin
    RegisterMethod(@TIBTRANSACTION.CALL, 'Call');
    RegisterMethod(@TIBTRANSACTION.COMMIT, 'Commit');
    RegisterMethod(@TIBTRANSACTION.COMMITRETAINING, 'CommitRetaining');
    RegisterMethod(@TIBTRANSACTION.ROLLBACK, 'Rollback');
    RegisterMethod(@TIBTRANSACTION.ROLLBACKRETAINING, 'RollbackRetaining');
    RegisterMethod(@TIBTRANSACTION.STARTTRANSACTION, 'StartTransaction');
    RegisterMethod(@TIBTRANSACTION.CHECKINTRANSACTION, 'CheckInTransaction');
    RegisterMethod(@TIBTRANSACTION.CHECKNOTINTRANSACTION, 'CheckNotInTransaction');
    RegisterMethod(@TIBTRANSACTION.CHECKAUTOSTOP, 'CheckAutoStop');
    RegisterMethod(@TIBTRANSACTION.ADDDATABASE, 'AddDatabase');
    RegisterMethod(@TIBTRANSACTION.FINDDATABASE, 'FindDatabase');
    RegisterMethod(@TIBTRANSACTION.FINDDEFAULTDATABASE, 'FindDefaultDatabase');
    RegisterMethod(@TIBTRANSACTION.REMOVEDATABASE, 'RemoveDatabase');
    RegisterMethod(@TIBTRANSACTION.REMOVEDATABASES, 'RemoveDatabases');
    RegisterMethod(@TIBTRANSACTION.CHECKDATABASESINLIST, 'CheckDatabasesInList');
    RegisterPropertyHelper(@TIBTRANSACTIONDATABASECOUNT_R,nil,'DatabaseCount');
    RegisterPropertyHelper(@TIBTRANSACTIONDATABASES_R,nil,'Databases');
    RegisterPropertyHelper(@TIBTRANSACTIONSQLOBJECTCOUNT_R,nil,'SQLObjectCount');
    RegisterPropertyHelper(@TIBTRANSACTIONSQLOBJECTS_R,nil,'SQLObjects');
    RegisterPropertyHelper(@TIBTRANSACTIONHANDLE_R,nil,'Handle');
    RegisterPropertyHelper(@TIBTRANSACTIONHANDLEISSHARED_R,nil,'HandleIsShared');
    RegisterPropertyHelper(@TIBTRANSACTIONINTRANSACTION_R,nil,'InTransaction');
    RegisterPropertyHelper(@TIBTRANSACTIONTPB_R,nil,'TPB');
    RegisterPropertyHelper(@TIBTRANSACTIONTPBLENGTH_R,nil,'TPBLength');
    RegisterPropertyHelper(@TIBTRANSACTIONACTIVE_R,@TIBTRANSACTIONACTIVE_W,'Active');
    RegisterPropertyHelper(@TIBTRANSACTIONDEFAULTDATABASE_R,@TIBTRANSACTIONDEFAULTDATABASE_W,'DefaultDatabase');
    RegisterPropertyHelper(@TIBTRANSACTIONIDLETIMER_R,@TIBTRANSACTIONIDLETIMER_W,'IdleTimer');
    RegisterPropertyHelper(@TIBTRANSACTIONDEFAULTACTION_R,@TIBTRANSACTIONDEFAULTACTION_W,'DefaultAction');
    RegisterPropertyHelper(@TIBTRANSACTIONPARAMS_R,@TIBTRANSACTIONPARAMS_W,'Params');
    RegisterPropertyHelper(@TIBTRANSACTIONAUTOSTOPACTION_R,@TIBTRANSACTIONAUTOSTOPACTION_W,'AutoStopAction');
    RegisterEventPropertyHelper(@TIBTRANSACTIONONIDLETIMER_R,@TIBTRANSACTIONONIDLETIMER_W,'OnIdleTimer');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBDATABASE(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBDATABASE) do
  begin
    RegisterMethod(@TIBDATABASE.ADDEVENTNOTIFIER, 'AddEventNotifier');
    RegisterMethod(@TIBDATABASE.REMOVEEVENTNOTIFIER, 'RemoveEventNotifier');
    RegisterMethod(@TIBDATABASE.APPLYUPDATES, 'ApplyUpdates');
    RegisterMethod(@TIBDATABASE.CLOSEDATASETS, 'CloseDataSets');
    RegisterMethod(@TIBDATABASE.CHECKACTIVE, 'CheckActive');
    RegisterMethod(@TIBDATABASE.CHECKINACTIVE, 'CheckInactive');
    RegisterMethod(@TIBDATABASE.CREATEDATABASE, 'CreateDatabase');
    RegisterMethod(@TIBDATABASE.DROPDATABASE, 'DropDatabase');
    RegisterMethod(@TIBDATABASE.FORCECLOSE, 'ForceClose');
    RegisterMethod(@TIBDATABASE.GETFIELDNAMES, 'GetFieldNames');
    RegisterMethod(@TIBDATABASE.GETTABLENAMES, 'GetTableNames');
    RegisterMethod(@TIBDATABASE.INDEXOFDBCONST, 'IndexOfDBConst');
    RegisterMethod(@TIBDATABASE.TESTCONNECTED, 'TestConnected');
    RegisterMethod(@TIBDATABASE.CHECKDATABASENAME, 'CheckDatabaseName');
    RegisterMethod(@TIBDATABASE.CALL, 'Call');
    RegisterMethod(@TIBDATABASE.Open, 'Open');
    RegisterMethod(@TIBDATABASE.Close, 'Close');
    RegisterMethod(@TIBDATABASE.ADDTRANSACTION, 'AddTransaction');
    RegisterMethod(@TIBDATABASE.FINDTRANSACTION, 'FindTransaction');
    RegisterMethod(@TIBDATABASE.FINDDEFAULTTRANSACTION, 'FindDefaultTransaction');
    RegisterMethod(@TIBDATABASE.REMOVETRANSACTION, 'RemoveTransaction');
    RegisterMethod(@TIBDATABASE.REMOVETRANSACTIONS, 'RemoveTransactions');
    RegisterMethod(@TIBDATABASE.SETHANDLE, 'SetHandle');
    RegisterPropertyHelper(@TIBDATABASEHANDLE_R,nil,'Handle');
    RegisterPropertyHelper(@TIBDATABASEISREADONLY_R,nil,'IsReadOnly');
    RegisterPropertyHelper(@TIBDATABASEDBPARAMBYDPB_R,@TIBDATABASEDBPARAMBYDPB_W,'DBParamByDPB');
    RegisterPropertyHelper(@TIBDATABASESQLOBJECTCOUNT_R,nil,'SQLObjectCount');
    RegisterPropertyHelper(@TIBDATABASESQLOBJECTS_R,nil,'SQLObjects');
    RegisterPropertyHelper(@TIBDATABASEHANDLEISSHARED_R,nil,'HandleIsShared');
    RegisterPropertyHelper(@TIBDATABASETRANSACTIONCOUNT_R,nil,'TransactionCount');
    RegisterPropertyHelper(@TIBDATABASETRANSACTIONS_R,nil,'Transactions');
    RegisterPropertyHelper(@TIBDATABASEINTERNALTRANSACTION_R,nil,'InternalTransaction');
    RegisterMethod(@TIBDATABASE.HAS_DEFAULT_VALUE, 'Has_DEFAULT_VALUE');
    RegisterMethod(@TIBDATABASE.HAS_COMPUTED_BLR, 'Has_COMPUTED_BLR');
    RegisterMethod(@TIBDATABASE.FLUSHSCHEMA, 'FlushSchema');
    RegisterPropertyHelper(@TIBDATABASEDATABASENAME_R,@TIBDATABASEDATABASENAME_W,'DatabaseName');
    RegisterPropertyHelper(@TIBDATABASECONNECTED_R,@TIBDATABASECONNECTED_W,'Connected');
    RegisterPropertyHelper(@TIBDATABASEPARAMS_R,@TIBDATABASEPARAMS_W,'Params');
    RegisterPropertyHelper(@TIBDATABASEDEFAULTTRANSACTION_R,@TIBDATABASEDEFAULTTRANSACTION_W,'DefaultTransaction');
    RegisterPropertyHelper(@TIBDATABASEIDLETIMER_R,@TIBDATABASEIDLETIMER_W,'IdleTimer');
    RegisterPropertyHelper(@TIBDATABASESQLDIALECT_R,@TIBDATABASESQLDIALECT_W,'SQLDialect');
    RegisterPropertyHelper(@TIBDATABASEDBSQLDIALECT_R,nil,'DBSQLDialect');
    RegisterPropertyHelper(@TIBDATABASETRACEFLAGS_R,@TIBDATABASETRACEFLAGS_W,'TraceFlags');
    RegisterPropertyHelper(@TIBDATABASEALLOWSTREAMEDCONNECTED_R,@TIBDATABASEALLOWSTREAMEDCONNECTED_W,'AllowStreamedConnected');
    RegisterEventPropertyHelper(@TIBDATABASEONLOGIN_R,@TIBDATABASEONLOGIN_W,'OnLogin');
    RegisterEventPropertyHelper(@TIBDATABASEONIDLETIMER_R,@TIBDATABASEONIDLETIMER_W,'OnIdleTimer');
    RegisterEventPropertyHelper(@TIBDATABASEONDIALECTDOWNGRADEWARNING_R,@TIBDATABASEONDIALECTDOWNGRADEWARNING_W,'OnDialectDowngradeWarning');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IBDatabase(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBDATABASE) do
  with CL.Add(TIBTRANSACTION) do
  with CL.Add(TIBBASE) do
  RIRegister_TIBDATABASE(CL);
  RIRegister_TIBTRANSACTION(CL);
  RIRegister_TIBBASE(CL);
end;

(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBTABLE(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBCustomDataSet', 'TIBTable') do
  with CL.AddClassN(CL.FindClass('TIBCustomDataSet'),'TIBTable') do
  begin
    RegisterMethod('procedure AddIndex(const Name, Fields: string; Options: TIndexOptions; const DescFields: string)');
    RegisterMethod('procedure CreateTable');
    RegisterMethod('procedure DeleteIndex(const Name: string)');
    RegisterMethod('procedure DeleteTable');
    RegisterMethod('procedure EmptyTable');
    RegisterMethod('procedure GetIndexNames(List: TStrings)');
    RegisterMethod('procedure GotoCurrent(Table: TIBTable)');
    RegisterProperty('CurrentDBKey', 'TIBDBKey', iptr);
    RegisterProperty('Exists', 'Boolean', iptr);
    RegisterProperty('IndexFieldCount', 'Integer', iptr);
    RegisterProperty('IndexFields', 'TField Integer', iptrw);
    RegisterProperty('TableNames', 'TStrings', iptr);
    RegisterProperty('DefaultIndex', 'Boolean', iptrw);
    RegisterProperty('IndexDefs', 'TIndexDefs', iptrw);
    RegisterProperty('IndexFieldNames', 'string', iptrw);
    RegisterProperty('IndexName', 'string', iptrw);
    RegisterProperty('MasterFields', 'string', iptrw);
    RegisterProperty('MasterSource', 'TDataSource', iptrw);
    RegisterProperty('ReadOnly', 'Boolean', iptrw);
    RegisterProperty('StoreDefs', 'Boolean', iptrw);
    RegisterProperty('TableName', 'string', iptrw);
    RegisterProperty('TableTypes', 'TIBTableTypes', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_IBTable(CL: TPSPascalCompiler);
begin
  CL.AddTypeS('TIBTableType', '(ttSystem, ttView)');
  CL.AddTypeS('TIBTableTypes', 'set of TIBTableType');
  CL.AddTypeS('TIndexName', 'string');
  CL.AddClassN(CL.FindClass('TObject'),'TIBTable');
  SIRegister_TIBTABLE(CL);
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TIBTABLETABLETYPES_W(Self: TIBTABLE; const T: TIBTABLETYPES);
begin Self.TABLETYPES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLETABLETYPES_R(Self: TIBTABLE; var T: TIBTABLETYPES);
begin T := Self.TABLETYPES; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLETABLENAME_W(Self: TIBTABLE; const T: STRING);
begin Self.TABLENAME := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLETABLENAME_R(Self: TIBTABLE; var T: STRING);
begin T := Self.TABLENAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLESTOREDEFS_W(Self: TIBTABLE; const T: BOOLEAN);
begin Self.STOREDEFS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLESTOREDEFS_R(Self: TIBTABLE; var T: BOOLEAN);
begin T := Self.STOREDEFS; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEREADONLY_W(Self: TIBTABLE; const T: BOOLEAN);
begin Self.READONLY := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEREADONLY_R(Self: TIBTABLE; var T: BOOLEAN);
begin T := Self.READONLY; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEMASTERSOURCE_W(Self: TIBTABLE; const T: TDATASOURCE);
begin Self.MASTERSOURCE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEMASTERSOURCE_R(Self: TIBTABLE; var T: TDATASOURCE);
begin T := Self.MASTERSOURCE; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEMASTERFIELDS_W(Self: TIBTABLE; const T: STRING);
begin Self.MASTERFIELDS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEMASTERFIELDS_R(Self: TIBTABLE; var T: STRING);
begin T := Self.MASTERFIELDS; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEINDEXNAME_W(Self: TIBTABLE; const T: STRING);
begin Self.INDEXNAME := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEINDEXNAME_R(Self: TIBTABLE; var T: STRING);
begin T := Self.INDEXNAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEINDEXFIELDNAMES_W(Self: TIBTABLE; const T: STRING);
begin Self.INDEXFIELDNAMES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEINDEXFIELDNAMES_R(Self: TIBTABLE; var T: STRING);
begin T := Self.INDEXFIELDNAMES; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEINDEXDEFS_W(Self: TIBTABLE; const T: TINDEXDEFS);
begin Self.INDEXDEFS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEINDEXDEFS_R(Self: TIBTABLE; var T: TINDEXDEFS);
begin T := Self.INDEXDEFS; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEDEFAULTINDEX_W(Self: TIBTABLE; const T: BOOLEAN);
begin Self.DEFAULTINDEX := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEDEFAULTINDEX_R(Self: TIBTABLE; var T: BOOLEAN);
begin T := Self.DEFAULTINDEX; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLETABLENAMES_R(Self: TIBTABLE; var T: TSTRINGS);
begin T := Self.TABLENAMES; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEINDEXFIELDS_W(Self: TIBTABLE; const T: TFIELD; const t1: INTEGER);
begin Self.INDEXFIELDS[t1] := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEINDEXFIELDS_R(Self: TIBTABLE; var T: TFIELD; const t1: INTEGER);
begin T := Self.INDEXFIELDS[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEINDEXFIELDCOUNT_R(Self: TIBTABLE; var T: INTEGER);
begin T := Self.INDEXFIELDCOUNT; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLEEXISTS_R(Self: TIBTABLE; var T: BOOLEAN);
begin T := Self.EXISTS; end;

(*----------------------------------------------------------------------------*)
procedure TIBTABLECURRENTDBKEY_R(Self: TIBTABLE; var T: TIBDBKEY);
begin T := Self.CURRENTDBKEY; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBTABLE(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBTABLE) do
  begin
    RegisterMethod(@TIBTABLE.ADDINDEX, 'AddIndex');
    RegisterMethod(@TIBTABLE.CREATETABLE, 'CreateTable');
    RegisterMethod(@TIBTABLE.DELETEINDEX, 'DeleteIndex');
    RegisterMethod(@TIBTABLE.DELETETABLE, 'DeleteTable');
    RegisterMethod(@TIBTABLE.EMPTYTABLE, 'EmptyTable');
    RegisterMethod(@TIBTABLE.GETINDEXNAMES, 'GetIndexNames');
    RegisterMethod(@TIBTABLE.GOTOCURRENT, 'GotoCurrent');
    RegisterPropertyHelper(@TIBTABLECURRENTDBKEY_R,nil,'CurrentDBKey');
    RegisterPropertyHelper(@TIBTABLEEXISTS_R,nil,'Exists');
    RegisterPropertyHelper(@TIBTABLEINDEXFIELDCOUNT_R,nil,'IndexFieldCount');
    RegisterPropertyHelper(@TIBTABLEINDEXFIELDS_R,@TIBTABLEINDEXFIELDS_W,'IndexFields');
    RegisterPropertyHelper(@TIBTABLETABLENAMES_R,nil,'TableNames');
    RegisterPropertyHelper(@TIBTABLEDEFAULTINDEX_R,@TIBTABLEDEFAULTINDEX_W,'DefaultIndex');
    RegisterPropertyHelper(@TIBTABLEINDEXDEFS_R,@TIBTABLEINDEXDEFS_W,'IndexDefs');
    RegisterPropertyHelper(@TIBTABLEINDEXFIELDNAMES_R,@TIBTABLEINDEXFIELDNAMES_W,'IndexFieldNames');
    RegisterPropertyHelper(@TIBTABLEINDEXNAME_R,@TIBTABLEINDEXNAME_W,'IndexName');
    RegisterPropertyHelper(@TIBTABLEMASTERFIELDS_R,@TIBTABLEMASTERFIELDS_W,'MasterFields');
    RegisterPropertyHelper(@TIBTABLEMASTERSOURCE_R,@TIBTABLEMASTERSOURCE_W,'MasterSource');
    RegisterPropertyHelper(@TIBTABLEREADONLY_R,@TIBTABLEREADONLY_W,'ReadOnly');
    RegisterPropertyHelper(@TIBTABLESTOREDEFS_R,@TIBTABLESTOREDEFS_W,'StoreDefs');
    RegisterPropertyHelper(@TIBTABLETABLENAME_R,@TIBTABLETABLENAME_W,'TableName');
    RegisterPropertyHelper(@TIBTABLETABLETYPES_R,@TIBTABLETABLETYPES_W,'TableTypes');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IBTable(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBTABLE) do
  RIRegister_TIBTABLE(CL);
end;

(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBSQL(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TComponent', 'TIBSQL') do
  with CL.AddClassN(CL.FindClass('TComponent'),'TIBSQL') do
  begin
    RegisterMethod('procedure BatchInput(InputObject: TIBBatchInput)');
    RegisterMethod('procedure BatchOutput(OutputObject: TIBBatchOutput)');
    RegisterMethod('function Call(ErrCode: ISC_STATUS; RaiseError: Boolean): ISC_STATUS');
    RegisterMethod('procedure CheckClosed');
    RegisterMethod('procedure CheckOpen');
    RegisterMethod('procedure CheckValidStatement');
    RegisterMethod('procedure Close');
    RegisterMethod('function Current: TIBXSQLDA');
    RegisterMethod('procedure ExecQuery');
    RegisterMethod('function FieldByName(FieldName: string): TIBXSQLVAR');
    RegisterMethod('procedure FreeHandle');
    RegisterMethod('function Next: TIBXSQLDA');
    RegisterMethod('procedure Prepare');
    RegisterMethod('function GetUniqueRelationName: string');
    RegisterMethod('function ParamByName(Idx: string): TIBXSQLVAR');
    RegisterProperty('BOF', 'Boolean', iptr);
    RegisterProperty('DBHandle', 'PISC_DB_HANDLE', iptr);
    RegisterProperty('EOF', 'Boolean', iptr);
    RegisterProperty('Fields', 'TIBXSQLVAR Integer', iptr);
    RegisterProperty('FieldIndex', 'Integer string', iptr);
    RegisterProperty('Open', 'Boolean', iptr);
    RegisterProperty('Params', 'TIBXSQLDA', iptr);
    RegisterProperty('Plan', 'string', iptr);
    RegisterProperty('Prepared', 'Boolean', iptr);
    RegisterProperty('RecordCount', 'Integer', iptr);
    RegisterProperty('RowsAffected', 'Integer', iptr);
    RegisterProperty('SqlType', 'TIBSQLTypes', iptr);
    RegisterProperty('TRHandle', 'PISC_TR_HANDLE', iptr);
    RegisterProperty('Handle', 'TISC_STMT_HANDLE', iptr);
    RegisterProperty('GenerateParamNames', 'Boolean', iptrw);
    RegisterProperty('UniqueRelationName', 'string', iptr);
    RegisterProperty('Database', 'TIBDatabase', iptrw);
    RegisterProperty('GoToFirstRecordOnExecute', 'Boolean', iptrw);
    RegisterProperty('ParamCheck', 'Boolean', iptrw);
    RegisterProperty('SQL', 'TStrings', iptrw);
    RegisterProperty('Transaction', 'TIBTransaction', iptrw);
    RegisterProperty('OnSQLChanging', 'TNotifyEvent', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBOUTPUTXML(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TObject', 'TIBOutputXML') do
  with CL.AddClassN(CL.FindClass('TObject'),'TIBOutputXML') do
  begin
    RegisterMethod('procedure WriteXML(SQL: TIBSQL)');
    RegisterProperty('HeaderTag', 'string', iptrw);
    RegisterProperty('DatabaseTag', 'string', iptrw);
    RegisterProperty('Stream', 'TStream', iptrw);
    RegisterProperty('TableTag', 'string', iptrw);
    RegisterProperty('RowTag', 'string', iptrw);
    RegisterProperty('Flags', 'TIBXMLFlags', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBINPUTRAWFILE(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBatchInput', 'TIBInputRawFile') do
  with CL.AddClassN(CL.FindClass('TIBBatchInput'),'TIBInputRawFile') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBOUTPUTRAWFILE(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBatchOutput', 'TIBOutputRawFile') do
  with CL.AddClassN(CL.FindClass('TIBBatchOutput'),'TIBOutputRawFile') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBINPUTDELIMITEDFILE(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBatchInput', 'TIBInputDelimitedFile') do
  with CL.AddClassN(CL.FindClass('TIBBatchInput'),'TIBInputDelimitedFile') do
  begin
    RegisterMethod('function GetColumn(var Col: string): Integer');
    RegisterProperty('ColDelimiter', 'string', iptrw);
    RegisterProperty('ReadBlanksAsNull', 'Boolean', iptrw);
    RegisterProperty('RowDelimiter', 'string', iptrw);
    RegisterProperty('SkipTitles', 'Boolean', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBOUTPUTDELIMITEDFILE(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBatchOutput', 'TIBOutputDelimitedFile') do
  with CL.AddClassN(CL.FindClass('TIBBatchOutput'),'TIBOutputDelimitedFile') do
  begin
    RegisterProperty('ColDelimiter', 'string', iptrw);
    RegisterProperty('OutputTitles', 'Boolean', iptrw);
    RegisterProperty('RowDelimiter', 'string', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBBATCHOUTPUT(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBatch', 'TIBBatchOutput') do
  with CL.AddClassN(CL.FindClass('TIBBatch'),'TIBBatchOutput') do
  begin
    RegisterMethod('function WriteColumns: Boolean');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBBATCHINPUT(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBBatch', 'TIBBatchInput') do
  with CL.AddClassN(CL.FindClass('TIBBatch'),'TIBBatchInput') do
  begin
    RegisterMethod('function ReadParameters: Boolean');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBBATCH(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TObject', 'TIBBatch') do
  with CL.AddClassN(CL.FindClass('TObject'),'TIBBatch') do
  begin
    RegisterMethod('procedure ReadyFile');
    RegisterProperty('Columns', 'TIBXSQLDA', iptrw);
    RegisterProperty('FileName', 'string', iptrw);
    RegisterProperty('Params', 'TIBXSQLDA', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBXSQLDA(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TObject', 'TIBXSQLDA') do
  with CL.AddClassN(CL.FindClass('TObject'),'TIBXSQLDA') do
  begin
    RegisterMethod('constructor Create(Query: TIBSQL)');
    RegisterMethod('procedure AddName(FieldName: string; Idx: Integer)');
    RegisterMethod('function ByName(Idx: string): TIBXSQLVAR');
    RegisterProperty('AsXSQLDA', 'PXSQLDA', iptr);
    RegisterProperty('Count', 'Integer', iptrw);
    RegisterProperty('Modified', 'Boolean', iptr);
    RegisterProperty('Names', 'string', iptr);
    RegisterProperty('RecordSize', 'Integer', iptr);
    RegisterProperty('Vars', 'TIBXSQLVAR Integer', iptr);
    SetDefaultPropery('Vars');
    RegisterProperty('UniqueRelationName', 'string', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBXSQLVAR(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TObject', 'TIBXSQLVAR') do
  with CL.AddClassN(CL.FindClass('TObject'),'TIBXSQLVAR') do
  begin
    RegisterMethod('constructor Create(Parent: TIBXSQLDA; Query: TIBSQL)');
    RegisterMethod('procedure Assign(Source: TIBXSQLVAR)');
    RegisterMethod('procedure LoadFromFile(const FileName: string)');
    RegisterMethod('procedure LoadFromStream(Stream: TStream)');
    RegisterMethod('procedure SaveToFile(const FileName: string)');
    RegisterMethod('procedure SaveToStream(Stream: TStream)');
    RegisterMethod('procedure Clear');
    RegisterProperty('AsDate', 'TDateTime', iptrw);
    RegisterProperty('AsTime', 'TDateTime', iptrw);
    RegisterProperty('AsDateTime', 'TDateTime', iptrw);
    RegisterProperty('AsDouble', 'Double', iptrw);
    RegisterProperty('AsFloat', 'Float', iptrw);
    RegisterProperty('AsCurrency', 'Currency', iptrw);
    RegisterProperty('ASINT64', 'Int64', iptrw);
    RegisterProperty('AsInteger', 'Integer', iptrw);
    RegisterProperty('AsLong', 'Long', iptrw);
    RegisterProperty('AsPointer', 'Pointer', iptrw);
    RegisterProperty('AsQuad', 'TISC_QUAD', iptrw);
    RegisterProperty('AsShort', 'SHORT', iptrw);
    RegisterProperty('AsString', 'string', iptrw);
    RegisterProperty('AsTrimString', 'string', iptrw);
    RegisterProperty('AsVariant', 'Variant', iptrw);
    RegisterProperty('AsXSQLVAR', 'PXSQLVAR', iptrw);
    RegisterProperty('Data', 'PXSQLVAR', iptrw);
    RegisterProperty('IsNull', 'Boolean', iptrw);
    RegisterProperty('IsNullable', 'Boolean', iptrw);
    RegisterProperty('Index', 'Integer', iptr);
    RegisterProperty('Modified', 'Boolean', iptrw);
    RegisterProperty('Name', 'string', iptr);
    RegisterProperty('Size', 'Integer', iptr);
    RegisterProperty('SqlType', 'Integer', iptr);
    RegisterProperty('Value', 'Variant', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_IBSQL(CL: TPSPascalCompiler);
begin
  CL.AddClassN(CL.FindClass('TObject'),'TIBSQL');
  CL.AddClassN(CL.FindClass('TObject'),'TIBXSQLDA');
  SIRegister_TIBXSQLVAR(CL);
  CL.AddTypeS('TIBXSQLVARArray', 'array of TIBXSQLVAR');
  SIRegister_TIBXSQLDA(CL);
  SIRegister_TIBBATCH(CL);
  SIRegister_TIBBATCHINPUT(CL);
  SIRegister_TIBBATCHOUTPUT(CL);
  SIRegister_TIBOUTPUTDELIMITEDFILE(CL);
  SIRegister_TIBINPUTDELIMITEDFILE(CL);
  SIRegister_TIBOUTPUTRAWFILE(CL);
  SIRegister_TIBINPUTRAWFILE(CL);
  CL.AddTypeS('TIBXMLFlag', '(xmlAttribute, xmlDisplayNull, xmlNoHeader)');
  CL.AddTypeS('TIBXMLFlags', 'set of TIBXMLFlag');
  SIRegister_TIBOUTPUTXML(CL);
  CL.AddTypeS('TIBSQLTypes', '(SQLUnknown, SQLSelect, SQLInsert, SQLUpdate, SQLDelete, SQLDDL, SQLGetSegment, SQLPutSegment, SQLExecProcedure, SQLStartTransaction, SQLCommit, SQLRollback, SQLSelectForUpdate, SQLSetGenerator)');


  SIRegister_TIBSQL(CL);
 CL.AddDelphiFunction('procedure OutputXML(SQLObject: TIBSQL; OutputObject: TIBOutputXML)');
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TIBSQLONSQLCHANGING_W(Self: TIBSQL; const T: TNOTIFYEVENT);
begin Self.ONSQLCHANGING := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLONSQLCHANGING_R(Self: TIBSQL; var T: TNOTIFYEVENT);
begin T := Self.ONSQLCHANGING; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLTRANSACTION_W(Self: TIBSQL; const T: TIBTRANSACTION);
begin Self.TRANSACTION := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLTRANSACTION_R(Self: TIBSQL; var T: TIBTRANSACTION);
begin T := Self.TRANSACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLSQL_W(Self: TIBSQL; const T: TSTRINGS);
begin Self.SQL := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLSQL_R(Self: TIBSQL; var T: TSTRINGS);
begin T := Self.SQL; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPARAMCHECK_W(Self: TIBSQL; const T: BOOLEAN);
begin Self.PARAMCHECK := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPARAMCHECK_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.PARAMCHECK; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLGOTOFIRSTRECORDONEXECUTE_W(Self: TIBSQL; const T: BOOLEAN);
begin Self.GOTOFIRSTRECORDONEXECUTE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLGOTOFIRSTRECORDONEXECUTE_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.GOTOFIRSTRECORDONEXECUTE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLDATABASE_W(Self: TIBSQL; const T: TIBDATABASE);
begin Self.DATABASE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLDATABASE_R(Self: TIBSQL; var T: TIBDATABASE);
begin T := Self.DATABASE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLUNIQUERELATIONNAME_R(Self: TIBSQL; var T: STRING);
begin T := Self.UNIQUERELATIONNAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLGENERATEPARAMNAMES_W(Self: TIBSQL; const T: BOOLEAN);
begin Self.GENERATEPARAMNAMES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLGENERATEPARAMNAMES_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.GENERATEPARAMNAMES; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLHANDLE_R(Self: TIBSQL; var T: TISC_STMT_HANDLE);
begin T := Self.HANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLTRHANDLE_R(Self: TIBSQL; var T: PISC_TR_HANDLE);
begin T := Self.TRHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLSQLTYPE_R(Self: TIBSQL; var T: TIBSQLTYPES);
begin T := Self.SQLTYPE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLROWSAFFECTED_R(Self: TIBSQL; var T: INTEGER);
begin T := Self.ROWSAFFECTED; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLRECORDCOUNT_R(Self: TIBSQL; var T: INTEGER);
begin T := Self.RECORDCOUNT; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPREPARED_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.PREPARED; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPLAN_R(Self: TIBSQL; var T: STRING);
begin T := Self.PLAN; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLPARAMS_R(Self: TIBSQL; var T: TIBXSQLDA);
begin T := Self.PARAMS; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLOPEN_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.OPEN; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLFIELDINDEX_R(Self: TIBSQL; var T: INTEGER; const t1: STRING);
begin T := Self.FIELDINDEX[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLFIELDS_R(Self: TIBSQL; var T: TIBXSQLVAR; const t1: INTEGER);
begin T := Self.FIELDS[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLEOF_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.EOF; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLDBHANDLE_R(Self: TIBSQL; var T: PISC_DB_HANDLE);
begin T := Self.DBHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBSQLBOF_R(Self: TIBSQL; var T: BOOLEAN);
begin T := Self.BOF; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLFLAGS_W(Self: TIBOUTPUTXML; const T: TIBXMLFLAGS);
begin Self.FLAGS := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLFLAGS_R(Self: TIBOUTPUTXML; var T: TIBXMLFLAGS);
begin T := Self.FLAGS; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLROWTAG_W(Self: TIBOUTPUTXML; const T: STRING);
begin Self.ROWTAG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLROWTAG_R(Self: TIBOUTPUTXML; var T: STRING);
begin T := Self.ROWTAG; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLTABLETAG_W(Self: TIBOUTPUTXML; const T: STRING);
begin Self.TABLETAG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLTABLETAG_R(Self: TIBOUTPUTXML; var T: STRING);
begin T := Self.TABLETAG; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLSTREAM_W(Self: TIBOUTPUTXML; const T: TSTREAM);
begin Self.STREAM := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLSTREAM_R(Self: TIBOUTPUTXML; var T: TSTREAM);
begin T := Self.STREAM; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLDATABASETAG_W(Self: TIBOUTPUTXML; const T: STRING);
begin Self.DATABASETAG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLDATABASETAG_R(Self: TIBOUTPUTXML; var T: STRING);
begin T := Self.DATABASETAG; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLHEADERTAG_W(Self: TIBOUTPUTXML; const T: STRING);
begin Self.HEADERTAG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTXMLHEADERTAG_R(Self: TIBOUTPUTXML; var T: STRING);
begin T := Self.HEADERTAG; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILESKIPTITLES_W(Self: TIBINPUTDELIMITEDFILE; const T: BOOLEAN);
begin Self.SKIPTITLES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILESKIPTITLES_R(Self: TIBINPUTDELIMITEDFILE; var T: BOOLEAN);
begin T := Self.SKIPTITLES; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILEROWDELIMITER_W(Self: TIBINPUTDELIMITEDFILE; const T: STRING);
begin Self.ROWDELIMITER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILEROWDELIMITER_R(Self: TIBINPUTDELIMITEDFILE; var T: STRING);
begin T := Self.ROWDELIMITER; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILEREADBLANKSASNULL_W(Self: TIBINPUTDELIMITEDFILE; const T: BOOLEAN);
begin Self.READBLANKSASNULL := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILEREADBLANKSASNULL_R(Self: TIBINPUTDELIMITEDFILE; var T: BOOLEAN);
begin T := Self.READBLANKSASNULL; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILECOLDELIMITER_W(Self: TIBINPUTDELIMITEDFILE; const T: STRING);
begin Self.COLDELIMITER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBINPUTDELIMITEDFILECOLDELIMITER_R(Self: TIBINPUTDELIMITEDFILE; var T: STRING);
begin T := Self.COLDELIMITER; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILEROWDELIMITER_W(Self: TIBOUTPUTDELIMITEDFILE; const T: STRING);
begin Self.ROWDELIMITER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILEROWDELIMITER_R(Self: TIBOUTPUTDELIMITEDFILE; var T: STRING);
begin T := Self.ROWDELIMITER; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILEOUTPUTTITLES_W(Self: TIBOUTPUTDELIMITEDFILE; const T: BOOLEAN);
begin Self.OUTPUTTITLES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILEOUTPUTTITLES_R(Self: TIBOUTPUTDELIMITEDFILE; var T: BOOLEAN);
begin T := Self.OUTPUTTITLES; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILECOLDELIMITER_W(Self: TIBOUTPUTDELIMITEDFILE; const T: STRING);
begin Self.COLDELIMITER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBOUTPUTDELIMITEDFILECOLDELIMITER_R(Self: TIBOUTPUTDELIMITEDFILE; var T: STRING);
begin T := Self.COLDELIMITER; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDAUNIQUERELATIONNAME_R(Self: TIBXSQLDA; var T: STRING);
begin T := Self.UNIQUERELATIONNAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDAVARS_R(Self: TIBXSQLDA; var T: TIBXSQLVAR; const t1: INTEGER);
begin T := Self.VARS[t1]; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDARECORDSIZE_R(Self: TIBXSQLDA; var T: INTEGER);
begin T := Self.RECORDSIZE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDANAMES_R(Self: TIBXSQLDA; var T: STRING);
begin T := Self.NAMES; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDAMODIFIED_R(Self: TIBXSQLDA; var T: BOOLEAN);
begin T := Self.MODIFIED; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDACOUNT_W(Self: TIBXSQLDA; const T: INTEGER);
begin Self.COUNT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDACOUNT_R(Self: TIBXSQLDA; var T: INTEGER);
begin T := Self.COUNT; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLDAASXSQLDA_R(Self: TIBXSQLDA; var T: PXSQLDA);
begin T := Self.ASXSQLDA; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARVALUE_W(Self: TIBXSQLVAR; const T: VARIANT);
begin Self.VALUE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARVALUE_R(Self: TIBXSQLVAR; var T: VARIANT);
begin T := Self.VALUE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARSQLTYPE_R(Self: TIBXSQLVAR; var T: INTEGER);
begin T := Self.SQLTYPE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARSIZE_R(Self: TIBXSQLVAR; var T: INTEGER);
begin T := Self.SIZE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARNAME_R(Self: TIBXSQLVAR; var T: STRING);
begin T := Self.NAME; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARMODIFIED_W(Self: TIBXSQLVAR; const T: BOOLEAN);
begin Self.MODIFIED := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARMODIFIED_R(Self: TIBXSQLVAR; var T: BOOLEAN);
begin T := Self.MODIFIED; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARINDEX_R(Self: TIBXSQLVAR; var T: INTEGER);
begin T := Self.INDEX; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARISNULLABLE_W(Self: TIBXSQLVAR; const T: BOOLEAN);
begin Self.ISNULLABLE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARISNULLABLE_R(Self: TIBXSQLVAR; var T: BOOLEAN);
begin T := Self.ISNULLABLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARISNULL_W(Self: TIBXSQLVAR; const T: BOOLEAN);
begin Self.ISNULL := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARISNULL_R(Self: TIBXSQLVAR; var T: BOOLEAN);
begin T := Self.ISNULL; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARDATA_W(Self: TIBXSQLVAR; const T: PXSQLVAR);
begin Self.DATA := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARDATA_R(Self: TIBXSQLVAR; var T: PXSQLVAR);
begin T := Self.DATA; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASXSQLVAR_W(Self: TIBXSQLVAR; const T: PXSQLVAR);
begin Self.ASXSQLVAR := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASXSQLVAR_R(Self: TIBXSQLVAR; var T: PXSQLVAR);
begin T := Self.ASXSQLVAR; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASVARIANT_W(Self: TIBXSQLVAR; const T: VARIANT);
begin Self.ASVARIANT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASVARIANT_R(Self: TIBXSQLVAR; var T: VARIANT);
begin T := Self.ASVARIANT; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASTRIMSTRING_W(Self: TIBXSQLVAR; const T: STRING);
begin Self.ASTRIMSTRING := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASTRIMSTRING_R(Self: TIBXSQLVAR; var T: STRING);
begin T := Self.ASTRIMSTRING; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASSTRING_W(Self: TIBXSQLVAR; const T: STRING);
begin Self.ASSTRING := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASSTRING_R(Self: TIBXSQLVAR; var T: STRING);
begin T := Self.ASSTRING; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASSHORT_W(Self: TIBXSQLVAR; const T: SHORT);
begin Self.ASSHORT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASSHORT_R(Self: TIBXSQLVAR; var T: SHORT);
begin T := Self.ASSHORT; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASQUAD_W(Self: TIBXSQLVAR; const T: TISC_QUAD);
begin Self.ASQUAD := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASQUAD_R(Self: TIBXSQLVAR; var T: TISC_QUAD);
begin T := Self.ASQUAD; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASPOINTER_W(Self: TIBXSQLVAR; const T: POINTER);
begin Self.ASPOINTER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASPOINTER_R(Self: TIBXSQLVAR; var T: POINTER);
begin T := Self.ASPOINTER; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASLONG_W(Self: TIBXSQLVAR; const T: LONG);
begin Self.ASLONG := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASLONG_R(Self: TIBXSQLVAR; var T: LONG);
begin T := Self.ASLONG; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASINTEGER_W(Self: TIBXSQLVAR; const T: INTEGER);
begin Self.ASINTEGER := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASINTEGER_R(Self: TIBXSQLVAR; var T: INTEGER);
begin T := Self.ASINTEGER; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASINT64_W(Self: TIBXSQLVAR; const T: INT64);
begin Self.ASINT64 := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASINT64_R(Self: TIBXSQLVAR; var T: INT64);
begin T := Self.ASINT64; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASCURRENCY_W(Self: TIBXSQLVAR; const T: CURRENCY);
begin Self.ASCURRENCY := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASCURRENCY_R(Self: TIBXSQLVAR; var T: CURRENCY);
begin T := Self.ASCURRENCY; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASFLOAT_W(Self: TIBXSQLVAR; const T: FLOAT);
begin Self.ASFLOAT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASFLOAT_R(Self: TIBXSQLVAR; var T: FLOAT);
begin T := Self.ASFLOAT; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDOUBLE_W(Self: TIBXSQLVAR; const T: DOUBLE);
begin Self.ASDOUBLE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDOUBLE_R(Self: TIBXSQLVAR; var T: DOUBLE);
begin T := Self.ASDOUBLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDATETIME_W(Self: TIBXSQLVAR; const T: TDATETIME);
begin Self.ASDATETIME := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDATETIME_R(Self: TIBXSQLVAR; var T: TDATETIME);
begin T := Self.ASDATETIME; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASTIME_W(Self: TIBXSQLVAR; const T: TDATETIME);
begin Self.ASTIME := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASTIME_R(Self: TIBXSQLVAR; var T: TDATETIME);
begin T := Self.ASTIME; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDATE_W(Self: TIBXSQLVAR; const T: TDATETIME);
begin Self.ASDATE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBXSQLVARASDATE_R(Self: TIBXSQLVAR; var T: TDATETIME);
begin T := Self.ASDATE; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IBSQL_Routines(S: TIFPSExec);
begin
 S.RegisterDelphiFunction(@OUTPUTXML, 'OutputXML', cdRegister);
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBSQL(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBSQL) do
  begin
    RegisterMethod(@TIBSQL.BATCHINPUT, 'BatchInput');
    RegisterMethod(@TIBSQL.BATCHOUTPUT, 'BatchOutput');
    RegisterMethod(@TIBSQL.CALL, 'Call');
    RegisterMethod(@TIBSQL.CHECKCLOSED, 'CheckClosed');
    RegisterMethod(@TIBSQL.CHECKOPEN, 'CheckOpen');
    RegisterMethod(@TIBSQL.CHECKVALIDSTATEMENT, 'CheckValidStatement');
    RegisterMethod(@TIBSQL.CLOSE, 'Close');
    RegisterMethod(@TIBSQL.CURRENT, 'Current');
    RegisterMethod(@TIBSQL.EXECQUERY, 'ExecQuery');
    RegisterMethod(@TIBSQL.FIELDBYNAME, 'FieldByName');
    RegisterMethod(@TIBSQL.FREEHANDLE, 'FreeHandle');
    RegisterMethod(@TIBSQL.NEXT, 'Next');
    RegisterMethod(@TIBSQL.PREPARE, 'Prepare');
    RegisterMethod(@TIBSQL.GETUNIQUERELATIONNAME, 'GetUniqueRelationName');
    RegisterMethod(@TIBSQL.PARAMBYNAME, 'ParamByName');
    RegisterPropertyHelper(@TIBSQLBOF_R,nil,'BOF');
    RegisterPropertyHelper(@TIBSQLDBHANDLE_R,nil,'DBHandle');
    RegisterPropertyHelper(@TIBSQLEOF_R,nil,'EOF');
    RegisterPropertyHelper(@TIBSQLFIELDS_R,nil,'Fields');
    RegisterPropertyHelper(@TIBSQLFIELDINDEX_R,nil,'FieldIndex');
    RegisterPropertyHelper(@TIBSQLOPEN_R,nil,'Open');
    RegisterPropertyHelper(@TIBSQLPARAMS_R,nil,'Params');
    RegisterPropertyHelper(@TIBSQLPLAN_R,nil,'Plan');
    RegisterPropertyHelper(@TIBSQLPREPARED_R,nil,'Prepared');
    RegisterPropertyHelper(@TIBSQLRECORDCOUNT_R,nil,'RecordCount');
    RegisterPropertyHelper(@TIBSQLROWSAFFECTED_R,nil,'RowsAffected');
    RegisterPropertyHelper(@TIBSQLSQLTYPE_R,nil,'SqlType');
    RegisterPropertyHelper(@TIBSQLTRHANDLE_R,nil,'TRHandle');
    RegisterPropertyHelper(@TIBSQLHANDLE_R,nil,'Handle');
    RegisterPropertyHelper(@TIBSQLGENERATEPARAMNAMES_R,@TIBSQLGENERATEPARAMNAMES_W,'GenerateParamNames');
    RegisterPropertyHelper(@TIBSQLUNIQUERELATIONNAME_R,nil,'UniqueRelationName');
    RegisterPropertyHelper(@TIBSQLDATABASE_R,@TIBSQLDATABASE_W,'Database');
    RegisterPropertyHelper(@TIBSQLGOTOFIRSTRECORDONEXECUTE_R,@TIBSQLGOTOFIRSTRECORDONEXECUTE_W,'GoToFirstRecordOnExecute');
    RegisterPropertyHelper(@TIBSQLPARAMCHECK_R,@TIBSQLPARAMCHECK_W,'ParamCheck');
    RegisterPropertyHelper(@TIBSQLSQL_R,@TIBSQLSQL_W,'SQL');
    RegisterPropertyHelper(@TIBSQLTRANSACTION_R,@TIBSQLTRANSACTION_W,'Transaction');
    RegisterEventPropertyHelper(@TIBSQLONSQLCHANGING_R,@TIBSQLONSQLCHANGING_W,'OnSQLChanging');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBOUTPUTXML(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBOUTPUTXML) do
  begin
    RegisterMethod(@TIBOUTPUTXML.WRITEXML, 'WriteXML');
    RegisterPropertyHelper(@TIBOUTPUTXMLHEADERTAG_R,@TIBOUTPUTXMLHEADERTAG_W,'HeaderTag');
    RegisterPropertyHelper(@TIBOUTPUTXMLDATABASETAG_R,@TIBOUTPUTXMLDATABASETAG_W,'DatabaseTag');
    RegisterPropertyHelper(@TIBOUTPUTXMLSTREAM_R,@TIBOUTPUTXMLSTREAM_W,'Stream');
    RegisterPropertyHelper(@TIBOUTPUTXMLTABLETAG_R,@TIBOUTPUTXMLTABLETAG_W,'TableTag');
    RegisterPropertyHelper(@TIBOUTPUTXMLROWTAG_R,@TIBOUTPUTXMLROWTAG_W,'RowTag');
    RegisterPropertyHelper(@TIBOUTPUTXMLFLAGS_R,@TIBOUTPUTXMLFLAGS_W,'Flags');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBINPUTRAWFILE(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBINPUTRAWFILE) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBOUTPUTRAWFILE(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBOUTPUTRAWFILE) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBINPUTDELIMITEDFILE(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBINPUTDELIMITEDFILE) do
  begin
    RegisterMethod(@TIBINPUTDELIMITEDFILE.GETCOLUMN, 'GetColumn');
    RegisterPropertyHelper(@TIBINPUTDELIMITEDFILECOLDELIMITER_R,@TIBINPUTDELIMITEDFILECOLDELIMITER_W,'ColDelimiter');
    RegisterPropertyHelper(@TIBINPUTDELIMITEDFILEREADBLANKSASNULL_R,@TIBINPUTDELIMITEDFILEREADBLANKSASNULL_W,'ReadBlanksAsNull');
    RegisterPropertyHelper(@TIBINPUTDELIMITEDFILEROWDELIMITER_R,@TIBINPUTDELIMITEDFILEROWDELIMITER_W,'RowDelimiter');
    RegisterPropertyHelper(@TIBINPUTDELIMITEDFILESKIPTITLES_R,@TIBINPUTDELIMITEDFILESKIPTITLES_W,'SkipTitles');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBOUTPUTDELIMITEDFILE(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBOUTPUTDELIMITEDFILE) do
  begin
    RegisterPropertyHelper(@TIBOUTPUTDELIMITEDFILECOLDELIMITER_R,@TIBOUTPUTDELIMITEDFILECOLDELIMITER_W,'ColDelimiter');
    RegisterPropertyHelper(@TIBOUTPUTDELIMITEDFILEOUTPUTTITLES_R,@TIBOUTPUTDELIMITEDFILEOUTPUTTITLES_W,'OutputTitles');
    RegisterPropertyHelper(@TIBOUTPUTDELIMITEDFILEROWDELIMITER_R,@TIBOUTPUTDELIMITEDFILEROWDELIMITER_W,'RowDelimiter');
  end;
end;


(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBXSQLDA(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBXSQLDA) do
  begin
    RegisterConstructor(@TIBXSQLDA.CREATE, 'Create');
    RegisterMethod(@TIBXSQLDA.ADDNAME, 'AddName');
    RegisterMethod(@TIBXSQLDA.BYNAME, 'ByName');
    RegisterPropertyHelper(@TIBXSQLDAASXSQLDA_R,nil,'AsXSQLDA');
    RegisterPropertyHelper(@TIBXSQLDACOUNT_R,@TIBXSQLDACOUNT_W,'Count');
    RegisterPropertyHelper(@TIBXSQLDAMODIFIED_R,nil,'Modified');
    RegisterPropertyHelper(@TIBXSQLDANAMES_R,nil,'Names');
    RegisterPropertyHelper(@TIBXSQLDARECORDSIZE_R,nil,'RecordSize');
    RegisterPropertyHelper(@TIBXSQLDAVARS_R,nil,'Vars');
    RegisterPropertyHelper(@TIBXSQLDAUNIQUERELATIONNAME_R,nil,'UniqueRelationName');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBXSQLVAR(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBXSQLVAR) do
  begin
    RegisterConstructor(@TIBXSQLVAR.CREATE, 'Create');
    RegisterMethod(@TIBXSQLVAR.ASSIGN, 'Assign');
    RegisterMethod(@TIBXSQLVAR.LOADFROMFILE, 'LoadFromFile');
    RegisterMethod(@TIBXSQLVAR.LOADFROMSTREAM, 'LoadFromStream');
    RegisterMethod(@TIBXSQLVAR.SAVETOFILE, 'SaveToFile');
    RegisterMethod(@TIBXSQLVAR.SAVETOSTREAM, 'SaveToStream');
    RegisterMethod(@TIBXSQLVAR.CLEAR, 'Clear');
    RegisterPropertyHelper(@TIBXSQLVARASDATE_R,@TIBXSQLVARASDATE_W,'AsDate');
    RegisterPropertyHelper(@TIBXSQLVARASTIME_R,@TIBXSQLVARASTIME_W,'AsTime');
    RegisterPropertyHelper(@TIBXSQLVARASDATETIME_R,@TIBXSQLVARASDATETIME_W,'AsDateTime');
    RegisterPropertyHelper(@TIBXSQLVARASDOUBLE_R,@TIBXSQLVARASDOUBLE_W,'AsDouble');
    RegisterPropertyHelper(@TIBXSQLVARASFLOAT_R,@TIBXSQLVARASFLOAT_W,'AsFloat');
    RegisterPropertyHelper(@TIBXSQLVARASCURRENCY_R,@TIBXSQLVARASCURRENCY_W,'AsCurrency');
    RegisterPropertyHelper(@TIBXSQLVARASINT64_R,@TIBXSQLVARASINT64_W,'ASINT64');
    RegisterPropertyHelper(@TIBXSQLVARASINTEGER_R,@TIBXSQLVARASINTEGER_W,'AsInteger');
    RegisterPropertyHelper(@TIBXSQLVARASLONG_R,@TIBXSQLVARASLONG_W,'AsLong');
    RegisterPropertyHelper(@TIBXSQLVARASPOINTER_R,@TIBXSQLVARASPOINTER_W,'AsPointer');
    RegisterPropertyHelper(@TIBXSQLVARASQUAD_R,@TIBXSQLVARASQUAD_W,'AsQuad');
    RegisterPropertyHelper(@TIBXSQLVARASSHORT_R,@TIBXSQLVARASSHORT_W,'AsShort');
    RegisterPropertyHelper(@TIBXSQLVARASSTRING_R,@TIBXSQLVARASSTRING_W,'AsString');
    RegisterPropertyHelper(@TIBXSQLVARASTRIMSTRING_R,@TIBXSQLVARASTRIMSTRING_W,'AsTrimString');
    RegisterPropertyHelper(@TIBXSQLVARASVARIANT_R,@TIBXSQLVARASVARIANT_W,'AsVariant');
    RegisterPropertyHelper(@TIBXSQLVARASXSQLVAR_R,@TIBXSQLVARASXSQLVAR_W,'AsXSQLVAR');
    RegisterPropertyHelper(@TIBXSQLVARDATA_R,@TIBXSQLVARDATA_W,'Data');
    RegisterPropertyHelper(@TIBXSQLVARISNULL_R,@TIBXSQLVARISNULL_W,'IsNull');
    RegisterPropertyHelper(@TIBXSQLVARISNULLABLE_R,@TIBXSQLVARISNULLABLE_W,'IsNullable');
    RegisterPropertyHelper(@TIBXSQLVARINDEX_R,nil,'Index');
    RegisterPropertyHelper(@TIBXSQLVARMODIFIED_R,@TIBXSQLVARMODIFIED_W,'Modified');
    RegisterPropertyHelper(@TIBXSQLVARNAME_R,nil,'Name');
    RegisterPropertyHelper(@TIBXSQLVARSIZE_R,nil,'Size');
    RegisterPropertyHelper(@TIBXSQLVARSQLTYPE_R,nil,'SqlType');
    RegisterPropertyHelper(@TIBXSQLVARVALUE_R,@TIBXSQLVARVALUE_W,'Value');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IBSQL(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBSQL) do
  with CL.Add(TIBXSQLDA) do
  RIRegister_TIBXSQLVAR(CL);
  RIRegister_TIBXSQLDA(CL);
  RIRegister_TIBOUTPUTDELIMITEDFILE(CL);
  RIRegister_TIBINPUTDELIMITEDFILE(CL);
  RIRegister_TIBOUTPUTRAWFILE(CL);
  RIRegister_TIBINPUTRAWFILE(CL);
  RIRegister_TIBOUTPUTXML(CL);
  RIRegister_TIBSQL(CL);
end;

(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBQuery(CL: TPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBCustomDataSet', 'TIBQuery') do
  with CL.AddClassN(CL.FindClass('TIBCustomDataSet'),'TIBQuery') do
  begin
    RegisterMethod('procedure BatchInput(InputObject: TIBBatchInput)');
    RegisterMethod('procedure BatchOutput(OutputObject: TIBBatchOutput)');
    RegisterMethod('procedure ExecSQL');
    RegisterMethod('function ParamByName(const Value: string): TParam');
    RegisterMethod('procedure Prepare');
    RegisterMethod('procedure UnPrepare');
    RegisterProperty('Prepared', 'Boolean', iptrw);
    RegisterProperty('ParamCount', 'Word', iptr);
    RegisterProperty('StmtHandle', 'TISC_STMT_HANDLE', iptr);
    RegisterProperty('Text', 'string', iptr);
    RegisterProperty('RowsAffected', 'Integer', iptr);
    RegisterProperty('GenerateParamNames', 'Boolean', iptrw);
    RegisterProperty('DataSource', 'TDataSource', iptrw);
    RegisterProperty('SQL', 'TStrings', iptrw);
    RegisterProperty('Params', 'TParams', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_IBQuery(CL: TPSPascalCompiler);
begin
  SIRegister_TIBQuery(CL);
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TIBQueryParams_W(Self: TIBQuery; const T: TParams);
begin Self.Params := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryParams_R(Self: TIBQuery; var T: TParams);
begin T := Self.Params; end;

(*----------------------------------------------------------------------------*)
procedure TIBQuerySQL_W(Self: TIBQuery; const T: TStrings);
begin Self.SQL := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBQuerySQL_R(Self: TIBQuery; var T: TStrings);
begin T := Self.SQL; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryDataSource_W(Self: TIBQuery; const T: TDatasource);
begin Self.DataSource := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryDataSource_R(Self: TIBQuery; var T: TDatasource);
begin T := Self.DataSource; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryGenerateParamNames_W(Self: TIBQuery; const T: Boolean);
begin Self.GenerateParamNames := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryGenerateParamNames_R(Self: TIBQuery; var T: Boolean);
begin T := Self.GenerateParamNames; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryRowsAffected_R(Self: TIBQuery; var T: Integer);
begin T := Self.RowsAffected; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryText_R(Self: TIBQuery; var T: string);
begin T := Self.Text; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryStmtHandle_R(Self: TIBQuery; var T: TISC_STMT_HANDLE);
begin T := Self.StmtHandle; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryParamCount_R(Self: TIBQuery; var T: Word);
begin T := Self.ParamCount; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryPrepared_W(Self: TIBQuery; const T: Boolean);
begin Self.Prepared := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBQueryPrepared_R(Self: TIBQuery; var T: Boolean);
begin T := Self.Prepared; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBQuery(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TIBQuery) do
  begin
    RegisterMethod(@TIBQuery.BatchInput, 'BatchInput');
    RegisterMethod(@TIBQuery.BatchOutput, 'BatchOutput');
    RegisterMethod(@TIBQuery.ExecSQL, 'ExecSQL');
    RegisterMethod(@TIBQuery.ParamByName, 'ParamByName');
    RegisterMethod(@TIBQuery.Prepare, 'Prepare');
    RegisterMethod(@TIBQuery.UnPrepare, 'UnPrepare');
    RegisterPropertyHelper(@TIBQueryPrepared_R,@TIBQueryPrepared_W,'Prepared');
    RegisterPropertyHelper(@TIBQueryParamCount_R,nil,'ParamCount');
    RegisterPropertyHelper(@TIBQueryStmtHandle_R,nil,'StmtHandle');
    RegisterPropertyHelper(@TIBQueryText_R,nil,'Text');
    RegisterPropertyHelper(@TIBQueryRowsAffected_R,nil,'RowsAffected');
    RegisterPropertyHelper(@TIBQueryGenerateParamNames_R,@TIBQueryGenerateParamNames_W,'GenerateParamNames');
    RegisterPropertyHelper(@TIBQueryDataSource_R,@TIBQueryDataSource_W,'DataSource');
    RegisterPropertyHelper(@TIBQuerySQL_R,@TIBQuerySQL_W,'SQL');
    RegisterPropertyHelper(@TIBQueryParams_R,@TIBQueryParams_W,'Params');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IBQuery(CL: TPSRuntimeClassImporter);
begin
  RIRegister_TIBQuery(CL);
end;



{ TIFPS3CE_IBCustomDataSet }
(*----------------------------------------------------------------------------*)
procedure TPSImport_IBX.CompOnUses(CompExec: TPSScript);
begin
  { nothing }
end;
(*----------------------------------------------------------------------------*)
procedure TPSImport_IBX.ExecOnUses(CompExec: TPSScript);
begin
  { nothing }
end;
(*----------------------------------------------------------------------------*)
procedure TPSImport_IBX.CompileImport1(CompExec: TPSScript);
begin
  SIRegister_IBDatabase(CompExec.Comp);
  SIRegister_IBSQL(CompExec.Comp);
  SIRegister_IBCustomDataSet(CompExec.Comp);
  SIRegister_IBTable(CompExec.Comp);
  SIRegister_IBQuery(CompExec.Comp);
end;
(*----------------------------------------------------------------------------*)
procedure TPSImport_IBX.CompileImport2(CompExec: TPSScript);
begin
  { nothing }
end;
(*----------------------------------------------------------------------------*)
procedure TPSImport_IBX.ExecImport1(CompExec: TPSScript; const ri: TPSRuntimeClassImporter);
begin
  RIRegister_IBDatabase(ri);
  RIRegister_IBSQL(ri);
  RIRegister_IBCustomDataSet(ri);
  RIRegister_IBTable(ri);
  RIRegister_IBQuery(ri);
end;
(*----------------------------------------------------------------------------*)
procedure TPSImport_IBX.ExecImport2(CompExec: TPSScript; const ri: TPSRuntimeClassImporter);
begin
  { nothing }
end;

end.
