unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, Buttons, lNetComponents, lNet, ExtCtrls, Menus, ValEdit;

type

  { TFormMain }

  TFormMain = class(TForm)
    Button1: TButton;
    Button2: TButton;
    ButtonDiconnect: TButton;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    LTCP: TLTCPComponent;
    EditPort: TEdit;
    LabelPort: TLabel;
    ButtonSend: TButton;
    EditSend: TEdit;
    MemoText: TMemo;
    TimerQuit: TTimer;
    vle1: TValueListEditor;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure LTCPComponentConnect(aSocket: TLSocket);
    procedure ListenButtonClick(Sender: TObject);
    procedure ConnectButtonClick(Sender: TObject);
    procedure DiconnectButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LTCPComponentError(const msg: string; aSocket: TLSocket);
    procedure LTCPComponentAccept(aSocket: TLSocket);
    procedure LTCPComponentReceive(aSocket: TLSocket);
    procedure LTcpComponentDisconnect(aSocket: TLSocket);
    procedure MenuItemAboutClick(Sender: TObject);
    procedure MenuItemExitClick(Sender: TObject);
    procedure RBTCP6Change(Sender: TObject);
    procedure RBTCPChange(Sender: TObject);
    procedure RBUDPChange(Sender: TObject);
    procedure SendButtonClick(Sender: TObject);
    procedure SendEditKeyPress(Sender: TObject; var Key: char);
    procedure TimerQuitTimer(Sender: TObject);
  private
    FNet: TLConnection;
    FIsServer: Boolean;
    procedure SendToAll(const aMsg: string);
    procedure addClientToList(ip:string);
    procedure rmClientFromList(ip:string);

  public
    { public declarations }
  end; 

var
  FormMain: TFormMain;

implementation

uses
  lCommon;

{ TFormMain }

procedure TFormMain.ConnectButtonClick(Sender: TObject);
begin

end;

procedure TFormMain.ListenButtonClick(Sender: TObject);
begin



end;

procedure TFormMain.LTCPComponentConnect(aSocket: TLSocket);
begin
  MemoText.Append('Connected to remote host');
end;

procedure TFormMain.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  CloseAction := caFree;

  if FNet.Connected then begin
    CloseAction := caNone; // make sure we quit gracefuly
    FNet.Disconnect; // call disconnect (soft)
    TimerQuit.Enabled := True; // if time runs out, quit ungracefully
  end;
end;

procedure TFormMain.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

end;

procedure TFormMain.FormShow(Sender: TObject);
var sx,fl:integer;
begin
  sx:=Screen.Width;
  fl:=FormMain.Left;
  if sx < fl then
  FormMain.Left:=100;
  if 0 > fl then
  FormMain.Left:=100;

end;

procedure TFormMain.Button1Click(Sender: TObject);
begin
  if FNet.Listen(StrToInt(EditPort.Text)) then begin
    MemoText.Append('Accepting connections');
    FIsServer := True;
  end;
end;

procedure TFormMain.Button2Click(Sender: TObject);
begin
  EditSend.Text:=ComboBox1.text+ComboBox2.text+Edit1.Text+','+Edit2.text+'end';
end;

procedure TFormMain.LTCPComponentError(const msg: string; aSocket: TLSocket);
begin
  MemoText.Append(msg);
  MemoText.SelStart := Length(MemoText.Lines.Text);
end;

procedure TFormMain.LTCPComponentAccept(aSocket: TLSocket);
begin
  MemoText.Append('Connection accepted: '+aSocket.PeerAddress);
  MemoText.SelStart := Length(MemoText.Lines.Text);
  addClientToList(aSocket.PeerAddress);
end;

procedure TFormMain.LTCPComponentReceive(aSocket: TLSocket);
var
  s,s2,ip: string;  i:integer;
begin
  if aSocket.GetMessage(s) > 0 then
  begin
    ip:=aSocket.PeerAddress;
    if pos('OnjectName:',s) <> 0 then
    begin
      s2:=s;
      delete(s2,1,11);
      vle1.Values[ip]:=s2;
      SendToAll(s2+'Registered');
      ComboBox1.Items.Clear;
      for i:=1 to vle1.RowCount -1 do
        ComboBox1.Items.Add(vle1.Cells[1,i]);
    end;
    MemoText.Append(s);
    MemoText.SelStart := Length(MemoText.Lines.Text);
  end;
end;

procedure TFormMain.LTcpComponentDisconnect(aSocket: TLSocket);
begin
  MemoText.Append('Connection lost: '+aSocket.PeerAddress);
  MemoText.SelStart := Length(MemoText.Lines.Text);
  rmClientFromList(aSocket.PeerAddress);
end;

procedure TFormMain.MenuItemAboutClick(Sender: TObject);
begin
  MessageDlg('TCP/UDP example copyright(c) 2005-2009 by Ales Katona. All rights deserved ;)',
             mtInformation, [mbOK], 0);
end;

procedure TFormMain.MenuItemExitClick(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.SendButtonClick(Sender: TObject);
begin
  if Length(EditSend.Text) > 0 then
  begin
    if FIsServer then
    begin
      SendToAll(EditSend.Text);
      MemoText.Append(EditSend.Text);
    end;
    EditSend.Text := '';
  end;
end;

procedure TFormMain.DiconnectButtonClick(Sender: TObject);
begin
  FNet.Disconnect;
  MemoText.Append('Disconnected');
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
  vle1.Cells[0,0]:='IP';
  vle1.Cells[1,0]:='Object';
  vle1.RowCount:=1;

  LTCP.SocketNet:=LAF_INET;
  FNet := LTCP;
  FIsServer := False;

end;

procedure TFormMain.RBTCP6Change(Sender: TObject);
begin

end;

procedure TFormMain.RBTCPChange(Sender: TObject);
begin

end;

procedure TFormMain.RBUDPChange(Sender: TObject);
begin

end;

procedure TFormMain.SendEditKeyPress(Sender: TObject; var Key: char);
begin
  if Key = #13 then
    SendButtonClick(Sender);
end;

procedure TFormMain.TimerQuitTimer(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.SendToAll(const aMsg: string);
var
  n: Integer;
begin
  FNet.IterReset; // start at server socket
  while FNet.IterNext do
  begin // skip server socket, go to clients only
    n := FNet.SendMessage(aMsg, FNet.Iterator);
    if n < Length(aMsg) then
      MemoText.Append('Error on send [' + IntToStr(n) + ']');
  end;
end;


procedure TFormMain.addClientToList(ip: string);
var i:integer;
begin
  for i:=1 to vle1.RowCount -1 do
  begin
    if vle1.Keys[i] = ip then
    begin
      exit;
    end;
  end;
  if vle1.Cells[0,1] <> '' then
    vle1.RowCount:=vle1.RowCount+1;
  vle1.Cells[0,vle1.RowCount-1]:=ip;

end;

procedure TFormMain.rmClientFromList(ip: string);
var i:integer;
begin
  for i:=1 to vle1.RowCount -1 do
   begin
     if vle1.Keys[i] = ip then
     begin
       vle1.DeleteRow(i);
       break;
     end;
   end;

end;

initialization
  {$I main.lrs}

end.

