{*********************************************************}
{                                                         }
{                 Zeos Database Objects                   }
{             Constant messages used by Zeos              }
{                                                         }
{ This unit contains all the messages that are output by  }
{ ZEOS methods. One of the given language can be activated}
{ by setting the language in ->                           }
{ ZEOS.inc (e.g.: $DEFINE GERMAN).                        }
{ If no language is defined english will be used.         }
{                                                         }
{*********************************************************}

{@********************************************************}
{    Copyright (c) 1999-2012 Zeos Development Group       }
{                                                         }
{ License Agreement:                                      }
{                                                         }
{ This library is distributed in the hope that it will be }
{ useful, but WITHOUT ANY WARRANTY; without even the      }
{ implied warranty of MERCHANTABILITY or FITNESS FOR      }
{ A PARTICULAR PURPOSE.  See the GNU Lesser General       }
{ Public License for more details.                        }
{                                                         }
{ The source code of the ZEOS Libraries and packages are  }
{ distributed under the Library GNU General Public        }
{ License (see the file COPYING / COPYING.ZEOS)           }
{ with the following  modification:                       }
{ As a special exception, the copyright holders of this   }
{ library give you permission to link this library with   }
{ independent modules to produce an executable,           }
{ regardless of the license terms of these independent    }
{ modules, and to copy and distribute the resulting       }
{ executable under terms of your choice, provided that    }
{ you also meet, for each linked independent module,      }
{ the terms and conditions of the license of that module. }
{ An independent module is a module which is not derived  }
{ from or based on this library. If you modify this       }
{ library, you may extend this exception to your version  }
{ of the library, but you are not obligated to do so.     }
{ If you do not wish to do so, delete this exception      }
{ statement from your version.                            }
{                                                         }
{                                                         }
{ The project web site is located on:                     }
{   http://zeos.firmos.at  (FORUM)                        }
{   http://sourceforge.net/p/zeoslib/tickets/ (BUGTRACKER)}
{   svn://svn.code.sf.net/p/zeoslib/code-0/trunk (SVN)    }
{                                                         }
{   http://www.sourceforge.net/projects/zeoslib.          }
{                                                         }
{                                                         }
{                                 Zeos Development Group. }
{********************************************************@}

unit ZMessages;

interface

{$I ZCore.inc}

uses ZCompatibility;

procedure loadmessages();

const
{$IFDEF FRENCH}
  cCodePage = 1252; {Microsoft Windows Codepage 1252 (ANSI), USASCCI}
{$ELSE !FRENCH}
{$IFDEF PORTUGUESE}
  cCodePage = 1252; {Microsoft Windows Codepage 1252 (ANSI), USASCCI}
{$ELSE !PORTUGUESE}
{$IFDEF DUTCH}
  cCodePage = 1252; {Microsoft Windows Codepage 1252 (ANSI), USASCCI}
{$ELSE !DUTCH}
{$IFDEF GERMAN}
  cCodePage = 1252; {Microsoft Windows Codepage 1252 (ANSI), USASCCI}
{$ELSE !GERMAN}
{$IFDEF SPANISH}
  cCodePage = 1252; {Microsoft Windows Codepage 1252 (ANSI), USASCCI}
{$ELSE !SPANISH}
{$IFDEF ROMANA}
  cCodePage = 1252; {Microsoft Windows Codepage 1252 (ANSI), USASCCI}
{$ELSE !ROMANA}
{$IFDEF INDONESIAN}
  cCodePage = 20127; {US-ASCII (7-bit)}
{$ELSE !INDONESIAN}
{$IFDEF RUSSIAN}
  cCodePage = 1251; {Microsoft Windows Codepage 1251 (Cyrl)}
{$ELSE !RUSSIAN}
{$IFDEF CZECH}
  cCodePage = 1250; {Microsoft Windows Codepage 1250 (East European)}
{$ELSE !CZECH}
{$IFDEF POLISH}
  cCodePage = 1250; {Microsoft Windows Codepage 1250 (East European)}
{$ELSE !POLISH}
cCodePage = 20127; {US-ASCII (7-bit)}
{$ENDIF POLISH} // POLISH
{$ENDIF CZECH} // CZECH
{$ENDIF RUSSIAN}
{$ENDIF INDONESIAN}
{$ENDIF ROMANA}
{$ENDIF SPANISH}
{$ENDIF GERMAN}
{$ENDIF DUTCH}
{$ENDIF PORTUGUESE}
{$ENDIF FRENCH}

resourcestring

  {$IFNDEF WITH_RTLCONSTS_SInvalidGuidArray}
    SInvalidGuidArray = 'Byte-Array or Buffer for GUID must have exact %s Bytes';
  {$ENDIF}
  cSLibraryNotCompatible = 'Client-Library %s found but could not be loaded. Check compile-target and library compatibility!';
//--- added by Serge Girard --------------------------------------------------------
{$IFDEF FRENCH}
  cSSQLError1 = 'Erreur SQL: %s';
  cSSQLError2 = 'Erreur SQL: %s Code: %d';
  cSSQLError3 = 'Erreur SQL: %s Code: %d SQL: %s';
  cSSQLError4 = 'Erreur SQL: %s Code: %d Message: %s';

  cSListCapacityError = 'Capacit de liste hors limite (%d)';
  cSListCountError = 'Compteur de liste (count) hors limite (%d)';
  cSListIndexError = 'Index de liste hors limite (%d)';

  cSClonningIsNotSupported = 'Le clonage n''est pas support pour cette classe';
  cSImmutableOpIsNotAllowed = 'L''opration n''est pas permise sur des collections non modifiables';
  cSStackIsEmpty = 'La pile est vide';
  cSVariableWasNotFound = 'Variable "%s" non trouve';
  cSFunctionWasNotFound = 'Fonction "%s" non trouve';
  cSInternalError = 'Erreur interne';
  cSSyntaxErrorNear = 'Erreur de syntaxe proche de "%s"';
  cSSyntaxError = 'Erreur de syntaxe';
  cSUnknownSymbol = 'Symbole inconnu "%s"';
  cSUnexpectedExprEnd = 'Fin d''expression imprvue';
  cSRightBraceExpected = ') attendue';
  cSParametersError = '%d paramtres attendus mais %d ont t trouvs';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams = 'Plus de deux paramtres sont attendus';
  cSInvalidVarByteArray = 'Tableau de VarByte non valide';
  cSVariableAlreadyExists = 'La variable "%s" existe dj';
  cSTypesMismatch = 'Types non concordants';
  cSUnsupportedVariantType = 'Type variant non support';
  cSUnsupportedOperation = 'Opration non supporte';

  cSTokenizerIsNotDefined = 'l''objet Tokenizer n''est pas dfini';
  cSLibraryNotFound = 'Acune des bibliothques dynamiques ne peut tre trouve ou charge: %s !'#10#13'Utilisez TZConnection.LibraryLocation si l''emplacement est incorrect.';
  cSEncodeDateIsNotSupported = 'Cette version ne supporte pas isc_encode_sql_date';
  cSEncodeTimeIsNotSupported = 'Cette version ne supporte pas isc_encode_sql_time';
  cSEncodeTimestampIsNotSupported = 'Cette version ne supporte pas isc_encode_sql_timestamp';
  cSDecodeDateIsNotSupported = 'Cette version ne supporte pas isc_decode_sql_date';
  cSDecodeTimeIsNotSupported = 'Cette version ne supporte pas isc_decode_sql_time';
  cSDecodeTimestampIsNotSupported = 'Cette version ne supporte pas isc_decode_sql_timestamp';

  cSCanNotRetrieveResultSetData = 'Ne peut rcuprer l''ensemble de donnes rsultant';
  cSRowBufferIsNotAssigned = 'Le buffer de ligne n''est pas assign';
  cSColumnIsNotAccessable = 'Colonne d''index %d inaccessible';
  cSConvertionIsNotPossible = 'Conversion impossible de la colonne %d de %s vers %s';
  cSCanNotAccessBlobRecord = 'Ne peut accder au blob de la colonne %d avec le type %s';
  cSRowDataIsNotAvailable = 'Ligne de donnes non disponible';
  cSResolverIsNotSpecified = 'L''objet Resolver n''est pas indiqu';
  cSResultsetIsAlreadyOpened = 'L''ensemble rsultat est dj ouvert';
  cSCanNotUpdateEmptyRow = 'Ne peut mettre  jour une ligne vide';
  cSCanNotUpdateDeletedRow = 'Ne peut mettre  jour une ligne supprime';
  cSCanNotDeleteEmptyRow = 'Ne peut supprimer un ligne vide';
  cSCannotUseCommit = 'Vous ne pouvez pas utiliser COMMIT en mode AUTOCOMMIT';
  cSCannotUseRollBack = 'Vous ne pouvez pas utiliser ROLLBACK en mode AUTOCOMMIT';
  cSCanNotUpdateComplexQuery = 'Ne peut mettre  jour une requte complexe impliquant plus d''une table';
  cSCanNotUpdateThisQueryType = 'Ne peut mettre  jour ce type de requte';
  cSDriverWasNotFound = 'Le driver de base de donnes demand n''a pas t trouv';
  cSCanNotConnectToServer = 'Ne peut se connecter au serveur SQL';
  cSTableIsNotSpecified = 'La table n''est pas spcifie';
  cSLiveResultSetsAreNotSupported = 'Une requte actualisable n''est pas supporte par cette classe';
  cSInvalidInputParameterCount = 'Le nombre de paramtres attendu est infrieur au prvu';
  cSIsolationIsNotSupported = 'Niveau d''isolation de transaction non support';
  cSColumnWasNotFound = 'Colonne de nom "%s" non trouve';
  cSWrongTypeForBlobParameter = 'Type incorrect pour le paramtre Blob';
  cSIncorrectConnectionURL = 'Connexion URL: %s incorrect';
  cSUnsupportedProtocol = 'Protocole: %s non support';
  cSUnsupportedByDriver    = 'Le driver d''origine ne supporte pas cette fonctionnalit: [%s]';

  cSConnectionIsNotOpened = 'Connexion non encore ouverte';
  cSInvalidOpInAutoCommit = 'Opration non valide en mode AutoCommit';
  cSInvalidOpInNonAutoCommit = 'Opration non valide si le mode n''est pas AutoCommit';
  cSInvalidOpPrepare = 'Prparer une transaction n''est possible qu''en en dmarrant une (Starttransaction) d''abord (!)';

  cSConnectionIsNotAssigned = 'La connexion  la base donnes n''est pas indiqu';
  cSQueryIsEmpty = 'La requte SQL est vide';
  cSCanNotExecuteMoreQueries = 'Ne peut excuter plus d''une requte';
  cSOperationIsNotAllowed1 = 'Cette opration n''est pas permise en mode FORWARD ONLY';
  cSOperationIsNotAllowed2 = 'Cette opration n''est pas permise en mode READ ONLY';
  cSOperationIsNotAllowed3 = 'Cette opration n''est pas permise en mode %s';
  cSOperationIsNotAllowed4 = 'Cette opration n''est pas permise en mode sur un ensemble de donnes ferm';
  cSNoMoreRecords = 'Plus d''enregistrements dans l''ensemble de donnes';
  cSCanNotOpenResultSet = 'Ne peut ouvrir un ensemble de donnes';
  cSCanNotOpenDataSetWhenDestroying ='Ne peut ouvrir un ensemble de donnes alors que l''tat du composant est dsDestroying';
  cSCircularLink = 'Lien circulaire cr par le Datasource';
  cSBookmarkWasNotFound = 'Le marque page (Bookmark) n''a pas t trouv';
  cSIncorrectSearchFieldsNumber = 'Nombre incorrect de valeurs de recherche';
  cSInvalidOperationInTrans = 'Opration invalide dans un mode de transaction explicite';
  cSIncorrectSymbol = 'Symbole incorrect dans la liste des champs "%s".';
  cSIncorrectToken = 'Token incorrect suivi par ":"';
  cSIncorrectParamChar = 'Valeur non valide pour ParamChar';

  cSSelectedTransactionIsolation = 'Le niveau d''isolation de transaction slectionn n''est pas support';
  cSDriverNotSupported = 'Driver non support %s';
  cSPattern2Long = 'Le Pattern est trop long';
  cSDriverNotCapableOutParameters = 'Le Driver n''est pas capable d''utiliser des paramtres';
  cSStatementIsNotAllowed = 'Dclaration non permise';
  cSStoredProcIsNotAllowed = 'La procdure stocke n''est pas permise';
  cSCannotPerformOperation = 'Ne peut effectuer cette opration sur une ensemble de donnes ferm';
  cSInvalidState = 'tat non valide';
  cSErrorConvertion = 'Erreur de conversion';
  cSDataTypeDoesNotSupported = 'Type de donne non support';
  cSUnsupportedParameterType = 'Type de paramtre non support';
  cSUnsupportedDataType = 'Type de donne non support';
  cSErrorConvertionField = 'Erreur de conversion pour le champ "%s" vers le type SQL "%s"';
  cSBadOCI = 'Mauvaise version OCI [%s] . Version 8.0.3 ou plus ancienne requise';
  cSConnect2AsUser = 'Connexion  "%s" en tant qu''utilisateur "%s"';
  cSUnknownError = 'Erreur inconnue';
  cSFieldNotFound1 = 'Champ "%s" non trouv';
  cSFieldNotFound2 = 'Champ %d non trouv';

  cSLoginPromptFailure = 'Ne peut trouver le dialogue d''identification par dfaut. Ajoutez ,S.V.P. DBLogDlg dans la section uses section de votre fichier principal.';

  cSPropertyQuery = 'La requte peut prendre un certain temps sur des bases de donnes importantes!';
  cSPropertyTables = 'Vous devriez la limiter via Catalogue et/ou Schma.';
  cSPropertyColumns = 'Vous devriez la limiter via Catalogue, Schma et/ou Nom de Table.';
  cSPropertyProcedures = 'Vous devriez la limiter via Catalogue et/ou Schema.';
  cSPropertySequences = 'Vous devriez la limiter via Catalogue et/ou Schema.';
  cSPropertyExecute = 'La Requte doit-elle s''excuter quand mme?';

  cSFormTest = 'diteur SQL ZEOS Test';
  cSButtonClose = '&Fermer';
  cSFormEditor = 'diteur SQL ZEOS';
  cSTabSheetSelect = 'Select SQL';
  cSMenuLoad = 'Charger';
  cSMenuSave = 'Sauver';
  cSButtonGenerate = '&Gnrer';
  cSButtonCheck = '&Vrifier';
  cSButtonTest = '&Tester';
  cSButtonOk = '&OK';
  cSButtonCancel = 'A&nnuler';
  cSTableAlias = 'T&able alias';
  cSReplaceSQL = '&Remplacer le SQL';
  cSDialogOpenTitle = 'Ouvrir fichier SQL';
  cSDialogSaveTitle = 'Sauver dans un fichier SQL';
  cSSQLEditor = 'diteur SQL';
  cSDatabaseDialog = 'Ouvrir base existante';

  cSUpdateSQLNoResult = '"Update Refresh SQL" ne fourni aucun ensemble de rsultat';
  cSUpdateSQLRefreshStatementcount ='La dclaration de l''"Update Refresh SQL" ne peut tre qu''unique';

  {$IFDEF FPC}
  cSNotEditing = 'L''ensemble de donnes n''est ni en modification ni en insertion';
  cSFieldTypeMismatch = 'Diffrence de type pour le champ ''%s'', attendu: %s trouv: %s';
  cSFieldSizeMismatch = 'Diffrence de taille pour le champ ''%s'', attendue: %d trouve: %d';
  {$ENDIF}
  cSNeedField               = 'Le champ %s est requis, mais non renseign.';

  cSFailedtoInitPrepStmt   = 'La dclaration a choue  l''initialisation';
  cSFailedtoPrepareStmt    = 'La dclaration a choue durant le processus de prparation';
  cSFailedToBindAllValues  = 'L''application a chou  pr-relier toutes les valeurs';
  cSAttemptExecOnBadPrep   = 'Tentative d''excuter une dclaration avant une prparation russie.';
  cSBindingFailure         = 'chec  relier l''ensemble des paramtres';
  cSPreparedStmtExecFailure = 'La prparation de la dclaration a chou';
  cSBoundVarStrIndexMissing = 'Nom de la variable de relation "%s" inexistant';
  cSBindVarOutOfRange      = 'Index de la variable de relation hors limite: %d';
  cSFailedToBindResults    = 'L''application a chou  lier l''ensemble rsultat';

//FOS+ 07112006
  cSRefreshRowOnlySupportedWithUpdateObject = 'La mthode "refreshrow" n''est permise qu''avec un objet de mise  jour(Update)';
  cSMustBeInBrowseMode = 'Opration uniquement permise dans l''tat dsBROWSE';

  cSUnKnownParamDataType = 'Param.DataType inconnu';
  cSFieldReadOnly        = ' A un champ en lecture seule on ne peut assigner une valeur : %s';
  cSInvalidUpdateCount     = '%d enregistrement(s) mis  jour. Un seul urait du l''tre.';

  cSRowBufferWidthExceeded ='La taille du buffer de lignes a t dpasse. Essayez d''utiliser moins ou de plus longues colonnes dans la requte SQL.';
  cSPreviousResultStillOpen = 'L''ensemble de donnes rsultat prcdent de cette instruction est encore ouvert';
//--- end added by Serge Girard ------------------------------------
{$ELSE !FRENCH}
// -> ms, 09/05/2005
{$IFDEF PORTUGUESE}
  cSSQLError1 = 'Erro SQL: %s';
  cSSQLError2 = 'Erro SQL: %s Cdigo: %d';
  cSSQLError3 = 'Erro SQL: %s Cdigo: %d SQL: %s';
  cSSQLError4 = 'Erro SQL: %s Cdigo: %d Mensagem: %s';

  cSListCapacityError = 'Capacidade da Lista fora do limite (%d)';
  cSListCountError = 'Contagem da Lista fora do limite (%d)';
  cSListIndexError = 'ndice da Lista fora do limite (%d)';

  cSClonningIsNotSupported = 'Clonagem no  suportada por esta classe';
  cSImmutableOpIsNotAllowed = 'A operao no  permitida para coleo imutvel';
  cSStackIsEmpty = 'Pilha est vazia';
  cSVariableWasNotFound = 'Varivel "%s" no foi encontrada';
  cSFunctionWasNotFound = 'Function "%s" no foi encontrada';
  cSInternalError = 'Erro interno';
  cSSyntaxErrorNear = 'Erro de sintaxe prximo a "%s"';
  cSSyntaxError = 'Erro de sintaxe';
  cSUnknownSymbol = 'Smbolo desconhecido "%s"';
  cSUnexpectedExprEnd = 'Final inesperado de expresso';
  cSRightBraceExpected = ') esperado';
  cSParametersError = 'Esperado %d parmetros mas foi encontrado %d';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams = 'Esperado mais que 2 parmetros';
  cSInvalidVarByteArray = 'VarByte array invlido';
  cSVariableAlreadyExists = 'Varivel "%s" j existe';
  cSTypesMismatch = 'Tipos no combinam';
  cSUnsupportedVariantType = 'Tipo variante no suportado';
  cSUnsupportedOperation = 'Operao no suportada';

  cSTokenizerIsNotDefined = 'Sinalizador no definido';
  cSLibraryNotFound = 'Nenhuma biblioteca dinmica da lista %s foi encontrada';
  cSEncodeDateIsNotSupported = 'Esta verso no suporta isc_encode_sql_date';
  cSEncodeTimeIsNotSupported = 'Esta verso no suporta supported isc_encode_sql_time';
  cSEncodeTimestampIsNotSupported = 'Esta verso no suporta supported isc_encode_sql_timestamp';
  cSDecodeDateIsNotSupported = 'Esta verso no suporta isc_decode_sql_date';
  cSDecodeTimeIsNotSupported = 'Esta verso no suporta isc_decode_sql_time';
  cSDecodeTimestampIsNotSupported = 'Esta verso no suporta isc_decode_sql_timestamp';

  cSCanNotRetrieveResultSetData = 'No foi possvel obter os dados do ResultSet';
  cSRowBufferIsNotAssigned = 'Buffer da Linha no atribudo';
  cSColumnIsNotAccessable = 'Coluna com ndice %d no  acessvel';
  cSConvertionIsNotPossible = 'A converso da coluna %d de %s para %s no  possvel';
  cSCanNotAccessBlobRecord = 'No  possvel acessar um registro BLOB na coluna %d com o tipo %s';
  cSRowDataIsNotAvailable = 'Dados na Linha no disponveis';
  cSResolverIsNotSpecified = 'Resolver no foi especificado para este ResultSet';
  cSResultsetIsAlreadyOpened = 'ResultSet j est aberto';
  cSCanNotUpdateEmptyRow = 'No  possvel atualizar uma linha vazia';
  cSCanNotUpdateDeletedRow = 'No  possvel atualizar uma linha apagada';
  cSCanNotDeleteEmptyRow = 'No  possvel apagar uma linha vazia';
  cSCannotUseCommit = 'Voc no pode usar Commit no modo AutoCommit';
  cSCannotUseRollBack = 'Voc no pode usar Rollback no modo AutoCommit';
  cSCanNotUpdateComplexQuery = 'No  possvel atualizar uma query complexa com mais de uma tabela';
  cSCanNotUpdateThisQueryType = 'No  possvel atualizar este tipo de query';
  cSDriverWasNotFound = 'O driver de banco de dados requisitado no foi encontrado';
  cSCanNotConnectToServer = 'No foi possvel conectar ao servidor SQL';
  cSTableIsNotSpecified = 'Tabela no especificada';
  cSLiveResultSetsAreNotSupported = 'Live query no  suportado por esta classe';
  cSInvalidInputParameterCount = 'A contagem do parmetro de entrada  menor que o esperado';
  cSIsolationIsNotSupported = 'O nvel de isolamento da Transao no  suportado';
  cSColumnWasNotFound = 'Coluna com o nome "%s" no foi encontrada';
  cSWrongTypeForBlobParameter = 'Tipo errado para parmetro Blob';
  cSIncorrectConnectionURL = 'Conexo incorreta URL: %s';
  cSUnsupportedProtocol = 'Protocolo no suportado: %s';
  cSUnsupportedByDriver    = 'O Driver no suporta este recurso nativamente: [%s]';

  cSConnectionIsNotOpened = 'Conexo ainda no est aberta.';
  cSInvalidOpInAutoCommit = 'Operao invlida no modo AutoCommit.';
  cSInvalidOpInNonAutoCommit = 'Operao invlida quando o modo AutoCommit  False.';
  cSInvalidOpPrepare = 'Prepare transaction somente  possvel aps comandar StartTransaction';

  cSConnectionIsNotAssigned = 'Componente de conexo de banco de dados no atribudo';
  cSQueryIsEmpty = 'A consulta SQL est vazia';
  cSCanNotExecuteMoreQueries = 'No  possvel executar mais que uma query';
  cSOperationIsNotAllowed1 = 'Operao no permitida no modo FORWARD ONLY';
  cSOperationIsNotAllowed2 = 'Operao no permitida no modo READ ONLY';
  cSOperationIsNotAllowed3 = 'Operao no permitida no modo %s';
  cSOperationIsNotAllowed4 = 'Operao no permitida para DataSet fechado';
  cSNoMoreRecords = 'Nenhum registro no ResultSet';
  cSCanNotOpenResultSet = 'No foi possvel abrir o ResultSet';
  cSCanNotOpenDataSetWhenDestroying ='Translate : Cannot open a dataset when the componentstate is dsDestroying';
  cSCircularLink = 'DataSource possui um link circular';
  cSBookmarkWasNotFound = 'Bookmark no foi encontrado';
  cSIncorrectSearchFieldsNumber = 'Nmero incorreto de valores de campos de procura';
  cSInvalidOperationInTrans = 'Operao invlida no modo de transao explcita';
  cSIncorrectSymbol = 'Smbolo incorreto na lista de campos "%s".';
  cSIncorrectToken = 'Sinal incorreto seguido por ":"';
  cSIncorrectParamChar = 'TRANSLATE : Invalid value for ParamChar';

  cSSelectedTransactionIsolation = 'O nvel selecionado do isolamento da transao no  suportado';
  cSDriverNotSupported = 'Driver no suportado %s';
  cSPattern2Long = 'Padro  muito longo';
  cSDriverNotCapableOutParameters = 'O Driver no suporta a passagem de parmetros';
  cSStatementIsNotAllowed = 'Declarao no permitida';
  cSStoredProcIsNotAllowed = 'A stored procedure no  permitida';
  cSCannotPerformOperation = 'No  possvel executar a operao num ResultSet fechado';
  cSInvalidState = 'Estado invlido';
  cSErrorConvertion = 'Erro de converso';
  cSDataTypeDoesNotSupported = 'Tipo de dado no suportado';
  cSUnsupportedParameterType = 'Tipo de parmetro no suportado';
  cSUnsupportedDataType = 'Tipo de dado no suportado';
  cSErrorConvertionField = 'Erro de converso para do campo "%s" para SQLType "%s"';
  cSBadOCI = 'Verso de OCI incompatvel [% s]. Requer 8.0.3 ou mais antigo';
  cSConnect2AsUser = 'Conecte "% s" como usurio "% s"';
  cSUnknownError = 'Erro desconhecido';
  cSFieldNotFound1 = 'Campo "%s" no foi encontrado';
  cSFieldNotFound2 = 'Campo %d no foi encontrado';

  cSLoginPromptFailure = 'No foi possvel encontrar o dilogo padro de login. Por favor adicione DBLogDlg para a seo uses de seu arquivo principal.';

  cSPropertyQuery = 'A Query poder demorar em bancos de dados grandes!';
  cSPropertyTables = 'Voc deveria limitar por Catalogo e/ou Esquema.';
  cSPropertyColumns = 'Voc deveria limitar por Catalogo, Esquema e/ou Tabela.';
  cSPropertyProcedures = 'Voc deveria limitar por Catalogo e/ou Esquema.';
  cSPropertySequences = 'Voc deveria limitar por Catalogo e/ou Esquema..';
  cSPropertyExecute = 'Executar a Query de qualquer maneira?';

  cSFormTest = 'Teste Editor ZEOS SQL';
  cSButtonClose = '&Fechar';
  cSFormEditor = 'Editor ZEOS SQL';
  cSTabSheetSelect = 'SQL Select';
  cSMenuLoad = 'Carregar';
  cSMenuSave = 'Salvar';
  cSButtonGenerate = '&Gerar';
  cSButtonCheck = '&Verificar';
  cSButtonTest = '&Testar';
  cSButtonOk = '&OK';
  cSButtonCancel = '&Cancelar';
  cSTableAlias = '&Alias Tabela';
  cSReplaceSQL = '&Substituir SQL';
  cSDialogOpenTitle = 'Abrir Arquivo SQL';
  cSDialogSaveTitle = 'Salvar Arquivo SQL';
  cSSQLEditor = 'Editor SQL';
  cSDatabaseDialog = 'Abrir Banco de Dados existente';

  cSUpdateSQLNoResult = 'SQL Update Refresh resultou num conjunto vazio';
  cSUpdateSQLRefreshStatementcount ='Usar somente 1 declarao SQL para Update Refresh';
  {$IFDEF FPC}
  cSNotEditing = 'Dataset no est em modo de edio ou insero';
  cSFieldTypeMismatch = 'Tipo invlido para o campo ''%s'', esperado: %s atual: %s';
  cSFieldSizeMismatch = 'Tamanho Invlido para o campo ''%s'', esperado: %d atual: %d';
  {$ENDIF}
  cSNeedField               = 'O campo %s  obrigatrio, mas no foi preenchido.';

  cSFailedtoInitPrepStmt   = 'A declarao preparada falhou ao inicializar';
  cSFailedtoPrepareStmt    = 'A declarao falhou durante o processo de preparo';
  cSFailedToBindAllValues  = 'A Aplicao falhou na traduo de todos os valores';
  cSAttemptExecOnBadPrep   = 'Tentativa de executar uma declarao que no foi corretamente preparada';
  cSBindingFailure         = 'Falha ao traduzir o conjunto de parmetros';
  cSPreparedStmtExecFailure = 'A declarao preparada falhou ao executar';
  cSBoundVarStrIndexMissing = 'ndice de texto "%s" da varivel de limite no existe';
  cSBindVarOutOfRange      = 'ndice da varivel de limite fora de alcance: %d';
  cSFailedToBindResults    = 'A Aplicao falhou ao tratar o result set';
  cSPreviousResultStillOpen = 'Previous resultset of this statement is still open';

  cSRefreshRowOnlySupportedWithUpdateObject = 'O mtodo RefreshRow somente  suportado com um update object';
  cSMustBeInBrowseMode = 'A Operao  permitida somente no modo dsBrowse';

  cSUnKnownParamDataType = 'Param.DataType  de tipo desconhecido';
  cSFieldReadOnly        = 'O campo %d  somente leitura e no pde receber dados';
  cSInvalidUpdateCount   = '%d registro(s) atualizados. Apenas um registro deveria ter sido atualizado.';

  cSRowBufferWidthExceeded ='O tamanho do buffer para linhas (Rows) foi excedido. Tente usar menos ou mais colunas na query SQL';
{$ELSE}

{$IFDEF DUTCH}
  cSSQLError1 = 'SQL Fout: %s';
  cSSQLError2 = 'SQL Fout: %s Code: %d';
  cSSQLError3 = 'SQL Fout: %s Code: %d SQL: %s';
  cSSQLError4 = 'SQL Fout: %s Code: %d Bericht: %s';

  cSListCapacityError = 'Lijst capaciteit buiten bereik (%d)';
  cSListCountError = 'Lijst aantal buiten bereik (%d)';
  cSListIndexError = 'Lijst index buiten bereik (%d)';

  cSClonningIsNotSupported = 'Kloonen worden niet ondersteund in deze klasse';
  cSImmutableOpIsNotAllowed = 'Deze operatie is niet ondersteund voor immutable collection';
  cSStackIsEmpty = 'Stack is leeg';
  cSVariableWasNotFound = 'Variabele "%s" niet gevonden';
  cSFunctionWasNotFound = 'Functie "%s" niet gevonden';
  cSInternalError = 'Interne fout';
  cSSyntaxErrorNear = 'Syntaxis fout bij "%s"';
  cSSyntaxError = 'Syntaxis fout';
  cSUnknownSymbol = 'Onbekend symbool "%s"';
  cSUnexpectedExprEnd = 'Onverwacht einde van de expressie';
  cSRightBraceExpected = ') verwacht';
  cSParametersError = 'Verwacht worden %d parameters maar er zijn er %d gevonden';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams = 'Meer dan 2 parameters werden verwacht';
  cSInvalidVarByteArray = 'Ongeldig VarByte array';
  cSVariableAlreadyExists = 'Variabele "%s" bestaat al';
  cSTypesMismatch = 'Types komen niet overeen';
  cSUnsupportedVariantType = 'Niet ondersteund variant type';
  cSUnsupportedOperation = 'Niet ondersteunde operatie';

  cSTokenizerIsNotDefined = 'Tokenizer is niet gedefinieerd';
  cSLibraryNotFound = 'DLL van de lijst %s werd niet gevonden';
  cSEncodeDateIsNotSupported = 'Deze versie ondersteunt isc_encode_sql_date niet';
  cSEncodeTimeIsNotSupported = 'Deze versie ondersteunt isc_encode_sql_time niet';
  cSEncodeTimestampIsNotSupported = 'Deze versie ondersteunt isc_encode_sql_timestamp niet';
  cSDecodeDateIsNotSupported = 'Deze versie ondersteunt isc_decode_sql_date niet';
  cSDecodeTimeIsNotSupported = 'Deze versie ondersteunt isc_decode_sql_time niet';
  cSDecodeTimestampIsNotSupported = 'Deze versie ondersteunt isc_decode_sql_timestamp niet';

  cSCanNotRetrieveResultSetData = 'Kan ResultSet data niet ophalen';
  cSRowBufferIsNotAssigned = 'Row buffer is niet toegekend';
  cSColumnIsNotAccessable = 'Kolom met index %d is niet bereikbaar';
  cSConvertionIsNotPossible = 'Conversie is niet mogelijk voor kolom %d van %s tot %s';
  cSCanNotAccessBlobRecord = 'Kan het blob record in kolom %d met type %s niet benaderen';
  cSRowDataIsNotAvailable = 'Rij data is niet beschikbaar';
  cSResolverIsNotSpecified = 'Resolver is niet gespecificeerd voor deze ResultSet';
  cSResultsetIsAlreadyOpened = 'ResultSet is al geopend';
  cSCanNotUpdateEmptyRow = 'Kan een lege rij niet updaten';
  cSCanNotUpdateDeletedRow = 'Kan een verwijderde rij niet updaten';
  cSCanNotDeleteEmptyRow = 'Kan een lege rij niet verwijderen';
  cSCannotUseCommit = 'Commit in autocommit mode is niet mogelijk';
  cSCannotUseRollBack = 'Rollback in autocommit mode is niet mogelijk';
  cSCanNotUpdateComplexQuery = 'Kan een complexe query met meerdere tabellen niet updaten';
  cSCanNotUpdateThisQueryType = 'Kan dit query type niet updaten';
  cSDriverWasNotFound = 'Gevraagde database driver is niet gevonden';
  cSCanNotConnectToServer = 'Kan geen verbinding maken met de SQL server';
  cSTableIsNotSpecified = 'Tabel is niet gespecifieerd';
  cSLiveResultSetsAreNotSupported = 'Live query is niet ondersteund door deze klasse';
  cSInvalidInputParameterCount = 'Input parameter aantal is lager dan verwacht';
  cSIsolationIsNotSupported = 'Transactie isolatie niveau wordt niet ondersteund';
  cSColumnWasNotFound = 'Kolom met naam "%s" bestaat niet';
  cSWrongTypeForBlobParameter = 'Verkeerde type voor Blob parameter';
  cSIncorrectConnectionURL = 'Ongeldige connectie URL: %s';
  cSUnsupportedProtocol = 'Niet ondersteund protocol: %s';
  cSUnsupportedByDriver    = 'De driver ondersteunt deze functie niet: [%s]';

  cSConnectionIsNotOpened = 'Verbinding is niet gemaakt.';
  cSInvalidOpInAutoCommit = 'Ongeldige operatie in AutoCommit mode.';
  cSInvalidOpInNonAutoCommit = 'Ongeldige operatie in non AutoCommit mode.';
  cSInvalidOpPrepare = 'Transactie voorbereiden is enkel mogelijk bij de eerste aanroep van Starttransaction!';

  cSConnectionIsNotAssigned = 'Database connectie component is niet toegekend';
  cSQueryIsEmpty = 'SQL Query is leeg';
  cSCanNotExecuteMoreQueries = 'Kan niet meerdere queries uitvoeren';
  cSOperationIsNotAllowed1 = 'Bewerking is niet toegestaan in FORWARD ONLY mode';
  cSOperationIsNotAllowed2 = 'Bewerking is niet toegestaan in READ ONLY mode';
  cSOperationIsNotAllowed3 = 'Bewerking is niet toegestaan in %s mode';
  cSOperationIsNotAllowed4 = 'Bewerking is niet toegestaan voor gesloten dataset';
  cSNoMoreRecords = 'Geen records meer aanwezig in ResultSet';
  cSCanNotOpenResultSet = 'Kan een ResultSet niet openen';
  cSCanNotOpenDataSetWhenDestroying ='Kan een Dataset niet openen wanneer de componentstate=dsDestroying';
  cSCircularLink = 'Databron maakt een oneindige verbindingslus';
  cSBookmarkWasNotFound = 'Bookmark niet gevonden';
  cSIncorrectSearchFieldsNumber = 'Incorrect aantal zoekvelden';
  cSInvalidOperationInTrans = 'Ongeldige operatie in explicit transaction mode';
  cSIncorrectSymbol = 'Ongeldig symbool in veld lijst "%s".';
  cSIncorrectToken = 'Ongeldig teken gevolgd door ":"';
  cSIncorrectParamChar = 'TRANSLATE : Invalid value for ParamChar';

  cSSelectedTransactionIsolation = 'Geselecteerd transactie isolatie niveau niet ondersteund';
  cSDriverNotSupported = 'Driver niet ondersteund %s';
  cSPattern2Long = 'Patroon is te lang';
  cSDriverNotCapableOutParameters = 'Driver ondersteunt geen out parameters';
  cSStatementIsNotAllowed = 'Statement is niet toegestaan';
  cSStoredProcIsNotAllowed = 'Stored procedures zijn niet toegestaan';
  cSCannotPerformOperation = 'Kan operatie niet uitvoeren op een gesloten ResultSet';
  cSInvalidState = 'Ongeldige status';
  cSErrorConvertion = 'Conversiefout';
  cSDataTypeDoesNotSupported = 'Data type is niet onderstuend';
  cSUnsupportedParameterType = 'Niet ondersteund parameter type';
  cSUnsupportedDataType = 'Niet ondersteund data type';
  cSErrorConvertionField = 'Conversie fout voor veld "%s" naar SQLType "%s"';
  cSBadOCI = 'Ongeschikte OCI version [%s]. Vereist is 8.0.3 of nieuwer';
  cSConnect2AsUser = 'Verbinden met "%s" als gebruiker "%s"';
  cSUnknownError = 'Onbekende fout';
  cSFieldNotFound1 = 'Veld "%s" niet gevonden';
  cSFieldNotFound2 = 'Veld %d niet gevonden';

  cSLoginPromptFailure = 'Kan de standaard login prompt niet vinden.  Voeg DBLogDlg toe aan de uses sectie.';

  cSPropertyQuery = 'De Query kan enige tijd duren bij grote databases!';
  cSPropertyTables = 'Limiet op Catalog en/of Schema is vereist.';
  cSPropertyColumns = 'Limiet op Catalog, Schema en/of tablenaam is vereist.';
  cSPropertyProcedures = 'Limiet op Catalog en/of Schema is vereist.';
  cSPropertySequences = 'Limiet op Catalog en/of Schema is vereist.';
  cSPropertyExecute = 'Dient de Query toch te worden uitgevoerd?';

  cSFormTest = 'ZEOS SQL Editor Test';
  cSButtonClose = '&Sluiten';
  cSFormEditor = 'ZEOS SQL Editor';
  cSTabSheetSelect = 'Select SQL';
  cSMenuLoad = 'Laden';
  cSMenuSave = 'Opslaan';
  cSButtonGenerate = '&Genereren';
  cSButtonCheck = 'C&heck';
  cSButtonTest = '&Test';
  cSButtonOk = '&OK';
  cSButtonCancel = '&Annuleren';
  cSTableAlias = 'Tabel al&ias';
  cSReplaceSQL = '&Vervang SQL';
  cSDialogOpenTitle = 'SQL Bestand Openen';
  cSDialogSaveTitle = 'SQL Bestand Opslaan';
  cSSQLEditor = 'SQL Editor';
  cSDatabaseDialog = 'Open bestaande database';

  cSUpdateSQLNoResult = 'Der zuvor aktualisierte SQL liefert kein Resultset zurck';
  cSUpdateSQLRefreshStatementcount ='Update Refresh SQL Statement count moet 1 zijn';

  {$IFDEF FPC}
  cSNotEditing = 'Dataset is niet in edit of insert modus';
  cSFieldTypeMismatch = 'Type mismatch voor veld ''%s'', verwacht: %s actueel: %s';
  cSFieldSizeMismatch = 'Size mismatch voor veld ''%s'', verwacht: %d actueel: %d';
  {$ENDIF}
  cSNeedField               = 'Veld %s is verplicht, maar niet ingevuld.';

  cSFailedtoInitPrepStmt   = 'Initialisatie van Prepared statement mislukt';
  cSFailedtoPrepareStmt    = 'Statement mislukt tijdens prepare';
  cSFailedToBindAllValues  = 'Pre-bind van alle waarden is mislukt';
  cSAttemptExecOnBadPrep   = 'Poging om een statement uit te voeren voor een succesvolle prepare';
  cSBindingFailure         = 'Binding van parameterset mislukt';
  cSPreparedStmtExecFailure = 'Uitvoeren van Prepared statement mislukt';
  cSBoundVarStrIndexMissing = 'Tekst index van bound variable bestaat niet: "%s"';
  cSBindVarOutOfRange      = 'Bound variable index buiten bereik: %d';
  cSFailedToBindResults    = 'Binding van resultaat mislukt';
  cSPreviousResultStillOpen = 'Previous resultset of this statement is still open';

  cSRefreshRowOnlySupportedWithUpdateObject = 'De refreshrow methode is enkel ondersteund vooreen update object';
  cSMustBeInBrowseMode = 'Bewerking is enkel toegestaan in dsBROWSE status';

  cSUnKnownParamDataType = 'Param.DataType is onbekend';
  cSFieldReadOnly        = 'Readonly veld kan geen waarde toegewezen krijgen: %d';
  cSInvalidUpdateCount     = '%d record(s) gewijzigd. Slechts 1 record had gewijzigd mogen zijn.';

  cSRowBufferWidthExceeded ='Rij buffer grootte overschreden. Probeer minder kolommen te gebruiken in je SQL query.';
{$ELSE}
// <- ms, 09/05/2005

// -> ms, 03/05/2005
{$IFDEF GERMAN}
  cSSQLError1 = 'SQL Fehler: %s';
  cSSQLError2 = 'SQL Fehler: %s Code: %d';
  cSSQLError3 = 'SQL Fehler: %s Code: %d SQL: %s';
  cSSQLError4 = 'SQL Fehler: %s Code: %d Meldung: %s';

  cSListCapacityError = 'Die Listenkapazitt bersteigt die definierte Grenze (%d)';
  cSListCountError = 'Der Listenzhler ist auerhalb seiner definierten Grenzen (%d)';
  cSListIndexError = 'Der Listenindex ist auerhalb der definierten Grenzen (%d)';

  cSClonningIsNotSupported = 'Diese Klasse kann nicht geklont werden';
  cSImmutableOpIsNotAllowed = 'Diese Operation ist bei nicht nderbaren Collections nicht erlaubt';
  cSStackIsEmpty = 'Der Stack ist leer';
  cSVariableWasNotFound = 'Die Variable "%s" wurde nicht gefunden';
  cSFunctionWasNotFound = 'Die Funktion "%s" wurde nicht gefunden';
  cSInternalError = 'Interner Fehler';
  cSSyntaxErrorNear = 'Syntax Fehler bei "%s"';
  cSSyntaxError = 'Syntax Fehler';
  cSUnknownSymbol = 'Unbekanntes Symbol "%s"';
  cSUnexpectedExprEnd = 'Unerwartetes Ende des Ausdrucks';
  cSRightBraceExpected = ') erwartet';
  cSParametersError = 'Es werden %d Parameter erwartet, aber nur %d Parameter gefunden';
  cSParamValueExceeded = 'Daten des Parameters %d zu gro.';
  cSExpectedMoreParams = 'Es werden mehr als zwei Parameter erwartet';
  cSInvalidVarByteArray = 'Ungltiges VarByte Array';
  cSVariableAlreadyExists = 'Die Variable "%s" existiert bereits';
  cSTypesMismatch = 'Inkompatible Typen';
  cSUnsupportedVariantType = 'Nicht untersttzter Variant-Typ';
  cSUnsupportedOperation = 'Nicht untersttzte Operation';
  cSUnsupportedByDriver    = 'Der Treiber untersttzt dieses Feature nicht von haus aus: [%s]';

  cSTokenizerIsNotDefined = 'Tokenizer wurde nicht definiert';
  cSLibraryNotFound = 'Es wurde keine der in %s gelisteten DLL''s gefunden';
  cSEncodeDateIsNotSupported = 'Diese Version untersttzt "isc_encode_sql_date" nicht';
  cSEncodeTimeIsNotSupported = 'Diese Version untersttzt "isc_encode_sql_time" nicht';
  cSEncodeTimestampIsNotSupported = 'Diese Version untersttzt "isc_encode_sql_timestamp" nicht';
  cSDecodeDateIsNotSupported = 'Diese Version untersttzt "isc_decode_sql_date" nicht';
  cSDecodeTimeIsNotSupported = 'Diese Version untersttzt "isc_decode_sql_time" nicht';
  cSDecodeTimestampIsNotSupported = 'Diese Version untersttzt "isc_decode_sql_timestamp" nicht';

  cSCanNotRetrieveResultSetData = 'Die Ergebnismenge kann nicht ermittelt werden';
  cSRowBufferIsNotAssigned = 'Der Zeilen-Buffer ist nicht zugewiesen';
  cSColumnIsNotAccessable = 'Auf die Spalte (Tabellenfeld) mit dem Index %d kann nicht zugegriffen werden';
  cSConvertionIsNotPossible = 'Eine Konvertierung der Spalte (Tabellenfeld) %d von %s bis %s kann nicht durchgefhrt werden';
  cSCanNotAccessBlobRecord = 'Auf den BLOB-Datensatz in Spalte (Tabellenfeld) %d vom Typ %s kann nicht zugegriffen werden';
  cSRowDataIsNotAvailable = 'Die Zeilendaten (Datensatzdaten) sind nicht verfgbar';
  cSResolverIsNotSpecified = 'Fr diese Ergebnismenge wurde kein sog. "Resolver" angegeben';
  cSResultsetIsAlreadyOpened = 'Die Ergebnismenge ist bereits geffnet';
  cSCanNotUpdateEmptyRow = 'Eine leere Datenzeile kann nicht aktualisiert werden';
  cSCanNotUpdateDeletedRow = 'Eine gelschte Datenzeile kann nicht aktualisiert werden';
  cSCanNotDeleteEmptyRow = 'Eine leere Datenzeile kann nicht gelscht werden';
  cSCannotUseCommit = 'COMMIT kann im AUTOCOMMIT-Modus nicht verwendet werden';
  cSCannotUseRollBack = 'ROLLBACK kann im AUTOCOMMIT-Modus nicht verwendet werden';
  cSCanNotUpdateComplexQuery = 'Ein Query, dessen Ergebnismenge aus mehr als einer Tabelle stammt, kann nicht aktualisiert werden';
  cSCanNotUpdateThisQueryType = 'Diese Art von Queries kann nicht aktualisiert werden';
  cSDriverWasNotFound = 'Der angegebene Datenbanktreiber wurde nicht gefunden';
  cSCanNotConnectToServer = 'Kann keine Verbindung zum SQL Server herstellen';
  cSTableIsNotSpecified = 'Tabelle ist nicht spezifiziert';
  cSLiveResultSetsAreNotSupported = 'Ein "Live Query" wird von dieser Klasse nicht untersttzt';
  cSInvalidInputParameterCount = 'Es wurden weniger Eingabeparameter angegeben, als erwartet';
  cSIsolationIsNotSupported = 'Der gewhlte Trasaktions-Isolationslevel wird nicht untersttzt';
  cSColumnWasNotFound = 'Eine Tabellenspalte namens "%s" wurde nicht gefunden';
  cSWrongTypeForBlobParameter = 'Falscher Typ fr einen BLOB-Parameter';
  cSIncorrectConnectionURL = 'Falsche Verbindungs-URL: %s';
  cSUnsupportedProtocol = 'Nicht untersttztes Protokoll: %s';

  cSConnectionIsNotOpened = 'Die Verbindung zur Datenbank ist noch nicht hergestellt';
  cSInvalidOpInAutoCommit = 'Ungltige Operation im AUTOCOMMIT-Modus';
  cSInvalidOpInNonAutoCommit = 'Ungltige Operation auerhalb des AUTOCOMMIT-Modus';
  cSInvalidOpPrepare = 'Transaktion vorzubereiten ist nur beim ersten Aufruf von Starttransaction mglich!';

  cSConnectionIsNotAssigned = 'Die Datenbank-Verbindungskomponente ist nicht angegeben';
  cSQueryIsEmpty = 'SQL Query leer';
  cSCanNotExecuteMoreQueries = 'Mehr als ein Query kann nicht abgearbeitet werden';
  cSOperationIsNotAllowed1 = 'Die Operation ist im FORWARD ONLY Modus nicht erlaubt';
  cSOperationIsNotAllowed2 = 'Die Operation ist im READ ONLY Modus nicht erlaubt';
  cSOperationIsNotAllowed3 = 'Die Operation ist im %s Modus nicht erlaubt';
  cSOperationIsNotAllowed4 = 'Die Operation ist bei einem geschlossenen DataSet nicht erlaubt';
  cSNoMoreRecords = 'Es gibt keine weiteren Datenstze in der Ergebnismenge';
  cSCanNotOpenResultSet = 'Die Ergebnismenge kann nicht geffnet werden';
  cSCanNotOpenDataSetWhenDestroying ='Dataset kann nicht im Komponenten-Status dsDestroying geffnet werden';
  cSCircularLink = 'Die DataSource hat einen zirkulren Verweis';
  cSBookmarkWasNotFound = 'Das Lesezeichen (Bookmark) wurde nicht gefunden';
  cSIncorrectSearchFieldsNumber = 'Die Anzahl der Suchfeldwerte ist nicht korrekt';
  cSInvalidOperationInTrans = 'Ungltige Operatio im Zustand einer expliziten Transaktion';
  cSIncorrectSymbol = 'Falsches Symbol in der Feldliste "%s".';
  cSIncorrectToken = 'Falsches Token gefolgt von ":"';
  cSIncorrectParamChar = 'Ungltiger Wert fr Parameter-Indikator';

  cSSelectedTransactionIsolation = 'Der gewhlte Transaktions-Isolationslevel wird nicht untersttzt';
  cSDriverNotSupported = 'Der Treiber wird nicht untersttzt: %s';
  cSPattern2Long = 'Das Muster (Pattern) ist zu lang';
  cSDriverNotCapableOutParameters = 'Der Treiber beherrscht keine Parameter';
  cSStatementIsNotAllowed = 'Diese Anweisung ist nicht erlaubt';
  cSStoredProcIsNotAllowed = 'Diese Stored Procedure ist nicht erlaubt';
  cSCannotPerformOperation = 'Auf eine geschlossene Ergebnismenge knnen keine Operationen ausgefhrt werden';
  cSInvalidState = 'Ungltiger Status';
  cSErrorConvertion = 'Konvertierungsfehler';
  cSDataTypeDoesNotSupported = 'Der Datentyp wird nicht untersttzt';
  cSUnsupportedParameterType = 'Der Parametertyp wird nicht untersttzt';
  cSUnsupportedDataType = 'Der Datentyp wird nicht untersttzt';
  cSErrorConvertionField = 'Konvertierungsfehler bei Feld "%s" nach SQL-Typ "%s"';
  cSBadOCI = 'Die OCI Version 8.0.3 (oder lter) wird bentigt! Aktuelle Version: %s';
  cSConnect2AsUser = 'Verbinde zu "%s" als User "%s"';
  cSUnknownError = 'Unbekannter Fehler';
  cSFieldNotFound1 = 'Das Feld "%s" wurde nicht gefunden';
  cSFieldNotFound2 = 'Das Feld %d wurde nicht gefunden';

  cSLoginPromptFailure = 'Der Standard-Login-Dialog konnte nicht gefunden werden. Bitte DBLogDlg in die USES-Sektion der Haupt-Unit hinzufgen';

  cSPropertyQuery = 'Die Abfrage kann bei groen Datenbanken eine Weile dauern!';
  cSPropertyTables = 'Sie sollte durch die Angabe von Catalog und/oder Schema eingeschrnkt werden.';
  cSPropertyColumns = 'Sie sollte durch die Angabe von Catalog, Schema und/oder Tabellenname eingeschrnkt werden.';
  cSPropertyProcedures = 'Sie sollte durch die Angabe von Catalog und/oder Schema eingeschrnkt werden.';
  cSPropertySequences = 'Sie sollte durch die Angabe von Catalog und/oder Schema eingeschrnkt werden.';
  cSPropertyExecute = 'Soll die Abfrage trotzdem ausgefhrt werden?';

  cSFormTest = 'ZEOS SQL Editor Test';
  cSButtonClose = '&Schlieen';
  cSFormEditor = 'ZEOS SQL Editor';
  cSTabSheetSelect = 'SQL aus&whlen';
  cSMenuLoad = 'ffnen';
  cSMenuSave = 'Speichern';
  cSButtonGenerate = '&Generieren';
  cSButtonCheck = 'Syntax &Prfen';
  cSButtonTest = 'Befehl &Testen';
  cSButtonOk = '&OK';
  cSButtonCancel = '&Abbruch';
  cSTableAlias = 'Tabllen-Alias';
  cSReplaceSQL = 'SQL &ersetzen';
  cSDialogOpenTitle = 'SQL Script ffnen';
  cSDialogSaveTitle = 'SQL Script speichern';
  cSSQLEditor = 'SQL Editor';
  cSDatabaseDialog = 'Existierende Datenbank ffnen';

  cSUpdateSQLNoResult = 'Translate : Update Refresh SQL delivered no resultset';
  cSUpdateSQLRefreshStatementcount ='Translate : Update Refresh SQL Statement count must be 1';

  {$IFDEF FPC}
  cSNotEditing = 'Das DataSet ist nicht im "ndern" oder "Einfge" Modus.';
  cSFieldTypeMismatch = 'Der Typ fr Feld ''%s'' stimmt nicht. Erwartet wird %s der Typ ist aber momentan %s';
  cSFieldSizeMismatch = 'Die Gre des Feldes ''%s'' stimmt nicht. Erwartet wird  %d die Gre ist aber momentan %d';
  {$ENDIF}
  cSNeedField               = 'Feld %s bentigt einen Wert, welcher nicht zugewiesen wurde.';

  cSFailedtoInitPrepStmt   = 'Die Initialisierung fr vorbereitete Abfrage ist gescheitert';
  cSFailedtoPrepareStmt    = 'Abfrage ist wrend des Vorbereitungsprozesses gescheitert.';
  cSFailedToBindAllValues  = 'Anwendung konnte nicht alle Werte bergeben';
  cSAttemptExecOnBadPrep   = 'Es wurde versucht eine nicht erfolgreich vorbereitete Abfrage auszufhren';
  cSBindingFailure         = 'Konnte nicht alle ausgewhlten Parameter der Abfrage binden';
  cSPreparedStmtExecFailure = 'Vorbeitet Abfrage scheiterte beim Ausfhren';
  cSBoundVarStrIndexMissing = 'Translate: Bound variable text index "%s" does not exist';
  cSBindVarOutOfRange      = 'Translate: Bound variable index out of range: %d';
  cSFailedToBindResults    = 'Translate: Application failed to bind to the result set';
  cSPreviousResultStillOpen = 'Previous resultset of this statement is still open';

  cSRefreshRowOnlySupportedWithUpdateObject = 'TRANSLATE: The refreshrow method is only supported with an update object';
  cSMustBeInBrowseMode = 'TRANSLATE: Operation is only allowed in dsBROWSE state';

  cSUnKnownParamDataType = 'Unbekannter Parameter-Datentyp';
  cSFieldReadOnly          = 'Einem "Nur-Lesen" Feld kann kein Wert zugewiesen werden: %d';
  cSInvalidUpdateCount     = '%d Datenstze gendert. Exakt ein Datensatz sollte gendert werden.';

  cSRowBufferWidthExceeded ='Translate: Row buffer width exceeded. Try using fewer or longer columns in SQL query.';
{$ELSE}
  // -> fduenas, 28/06/2005
{$IFDEF SPANISH} //Spanish translations
  cSSQLError1 = 'Error SQL: %s';
  cSSQLError2 = 'Error SQL: %s Cdigo: %d';
  cSSQLError3 = 'Error SQL: %s Cdigo: %d SQL: %s';
  cSSQLError4 = 'Error SQL: %s Cdigo: %d Mensage: %s';

  cSListCapacityError = 'List capacity fuera de lmites (%d)';
  cSListCountError = 'List count fuera de lmites (%d)';
  cSListIndexError = 'List index fuera de lmites (%d)';

  cSClonningIsNotSupported = 'La Clonacin no est soportada por esta clase';
  cSImmutableOpIsNotAllowed = 'Operacin no permitida en colecciones no modificables';
  cSStackIsEmpty = 'La Pila (Stack) est vaca';
  cSVariableWasNotFound = 'Variable "%s" no encontrada';
  cSFunctionWasNotFound = 'Funcin "%s" no encontrada';
  cSInternalError = 'Error interno';
  cSSyntaxErrorNear = 'Error de sintaxis cerca de "%s"';
  cSSyntaxError = 'Error de sintaxis';
  cSUnknownSymbol = 'Smbolo "%s" desconocido';
  cSUnexpectedExprEnd = 'Fin de expresin inesperado';
  cSRightBraceExpected = ') esperado';
  cSParametersError = 'Se esperaban %d parmetros pero solo %d fueron encontrados';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams = 'Se esperaban ms de dos parmetros';
  cSInvalidVarByteArray = 'Arreglo VarByte invlido';
  cSVariableAlreadyExists = 'La variable "%s" ya existe';
  cSTypesMismatch = 'Los Tipos no coinciden';
  cSUnsupportedVariantType = 'Tipo de Variant no soportando';
  cSUnsupportedOperation = 'Operacin no soportada';

  cSTokenizerIsNotDefined = 'El objeto Tokenizer no est definido';
  cSLibraryNotFound = 'Ninguna librera dinmica de la lista %s fue encontrada';
  cSEncodeDateIsNotSupported = 'Esta versin no soporta isc_encode_sql_date';
  cSEncodeTimeIsNotSupported = 'Esta versin no soporta isc_encode_sql_time';
  cSEncodeTimestampIsNotSupported = 'Esta versin no soporta isc_encode_sql_timestamp';
  cSDecodeDateIsNotSupported = 'Esta versin no soporta isc_decode_sql_date';
  cSDecodeTimeIsNotSupported = 'Esta versin no soporta isc_decode_sql_time';
  cSDecodeTimestampIsNotSupported = 'Esta versin no soporta isc_decode_sql_timestamp';

  cSCanNotRetrieveResultSetData = 'No se pueden obtener datos del Resultset';
  cSRowBufferIsNotAssigned = 'Buffer de lnea no asignado';
  cSColumnIsNotAccessable = 'La columna con ndice %d no est accesible';
  cSConvertionIsNotPossible = 'La conversin no es posible para la columna %d de %s a %s';
  cSCanNotAccessBlobRecord = 'No se puede accesar al registro del blob en la columna %d con tipo %s';
  cSRowDataIsNotAvailable = 'Datos de lnea no disponibles';
  cSResolverIsNotSpecified = 'El objeto Resolver no est especificado para este ResultSet';
  cSResultsetIsAlreadyOpened = 'El Resultset ya est abierto';
  cSCanNotUpdateEmptyRow = 'No se puede actualizar una lnea vaca';
  cSCanNotUpdateDeletedRow = 'No se puede actualizar una lnea borrada';
  cSCanNotDeleteEmptyRow = 'No se puede borrar una lnea vaca';
  cSCannotUseCommit = 'No se puede usar COMMIT en modo AUTOCOMMIT';
  cSCannotUseRollBack = 'No se puede usar ROLLBACK en modo AUTOCOMMIT';
  cSCanNotUpdateComplexQuery = 'No se puede actualizar una consulta compleja que haga referencia a ms de una tabla';
  cSCanNotUpdateThisQueryType = 'No se puede actualizar este tipo de consulta';
  cSDriverWasNotFound = 'No se encontr el controlador de base de datos solicitado';
  cSCanNotConnectToServer = 'No puede conectarse al servidor SQL';
  cSTableIsNotSpecified = 'La Tabla no est especificada';
  cSLiveResultSetsAreNotSupported = 'La consulta actualizable no es soportada por esta clase';
  cSInvalidInputParameterCount = 'El nmero de parmetros de tipo Input es menor al esperado';
  cSIsolationIsNotSupported = 'Nivel de aislamiento de transaccin no soportado';
  cSColumnWasNotFound = 'Columna con nombre "%s" no encontrada';
  cSWrongTypeForBlobParameter = 'Tipo incorrecto para el parmetro Blob';
  cSIncorrectConnectionURL = 'URL de conexin incorrecta: %s';
  cSUnsupportedProtocol = 'Protocolo no soportado: %s';
  cSUnsupportedByDriver    = 'Translate: Driver can not support this feature natively: [%s]';

  cSConnectionIsNotOpened = 'La conexin no ha sido abierta todava';
  cSInvalidOpInAutoCommit = 'Operacin invlida en modo AutoCommit';
  cSInvalidOpInNonAutoCommit = 'Operacin invlida en modo No-AutoCommit';
  cSInvalidOpPrepare = 'Translate : Prepare transaction only possible on matching first(!) Starttransaction';

  cSConnectionIsNotAssigned = 'El componente de conexin a base de datos no est asigando';
  cSQueryIsEmpty = 'La Consulta SQL est vaca';
  cSCanNotExecuteMoreQueries = 'No se puede ejecutar ms de una consulta';
  cSOperationIsNotAllowed1 = 'Operacin no permitida en modo FORWARD ONLY';
  cSOperationIsNotAllowed2 = 'Operacin no permitida en modo READ ONLY (Solo lectura)';
  cSOperationIsNotAllowed3 = 'Operacin no permitida en modo %s';
  cSOperationIsNotAllowed4 = 'Operacin no permitida en un dataset cerrado';
  cSNoMoreRecords = 'No hay ms registros en el Resultset';
  cSCanNotOpenResultSet = 'No se puede abrir el Resultset';
  cSCanNotOpenDataSetWhenDestroying ='Translate : Cannot open a dataset when the componentstate is dsDestroying';
  cSCircularLink = 'Datasource hace una referencia cclica';
  cSBookmarkWasNotFound = 'Bookmark no encontrado';
  cSIncorrectSearchFieldsNumber = 'Nmero incorrecto de valores de bsqueda';
  cSInvalidOperationInTrans = 'Operacin invlida en modo de transaccin explcita';
  cSIncorrectSymbol = 'Smbolo incorrecto en la lista de campos "%s".';
  cSIncorrectToken = 'Token incorrecto seguido de ":"';
  cSIncorrectParamChar = 'TRANSLATE : Invalid value for ParamChar';

  cSSelectedTransactionIsolation = 'El Nivel seleccionado de aislamiento de transaccin no est soportado';
  cSDriverNotSupported = 'Controlador %s no soportado';
  cSPattern2Long = 'Patrn de bsqueda demasiado largo';
  cSDriverNotCapableOutParameters = 'El controlador no tiene cualidades para manejar parmetros';
  cSStatementIsNotAllowed = 'Sentencia no permitida';
  cSStoredProcIsNotAllowed = 'El procedimiento alamacenado no est permitido';
  cSCannotPerformOperation = 'No se puede efectuar la operacin en un resultset cerrado';
  cSInvalidState = 'Estado Invlido';
  cSErrorConvertion = 'Error de conversin';
  cSDataTypeDoesNotSupported = 'Tipo de datos no soportado';
  cSUnsupportedParameterType = 'Tipo de parmetro no soportado';
  cSUnsupportedDataType = 'Tipo de datos no soportado';
  cSErrorConvertionField = 'Error de conversin del campo "%s" al Tipo SQL "%s"';
  cSBadOCI = 'Versin de OCI [%s] no aceptable. Se requiere versin 8.0.3 o menor';
  cSConnect2AsUser = 'Conectando a "%s" como usuario "%s"';
  cSUnknownError = 'Error desconocido';
  cSFieldNotFound1 = 'Campo "%s" no encontrado';
  cSFieldNotFound2 = 'Campo %d no encontrado';

  cSLoginPromptFailure = 'Cuadro de Dilogo por omisin para autenticacin no encontrado.'+#10#13+
                        'Por favor agregue la unidad DBLogDlg a la seccin uses de la unidad principal de su proyecto.';

  cSPropertyQuery = 'La Consulta puede tardar un poco en bases de datos extensas!';
  cSPropertyTables = 'Debera limitarlas mediante Catalog y/o Schema.';
  cSPropertyColumns = 'Debera limitarlas mediante Catalog, Schema y/o TableName.';
  cSPropertyProcedures = 'Debera limitarlos mediante Catalog y/or Schema.';
  cSPropertySequences = 'Debera limitarlos mediante Catalog y/or Schema.';
  cSPropertyExecute = 'Desea ejecutar la consulta de todos modos?';

  cSFormTest = 'Prueba del Editor ZEOS SQL';
  cSButtonClose = '&Cerrar';
  cSFormEditor = 'Editor ZEOS SQL';
  cSTabSheetSelect = 'Seleccionar SQL';
  cSMenuLoad = 'Cargar...';
  cSMenuSave = 'Guardar...';
  cSButtonGenerate = '&Generar';
  cSButtonCheck = 'C&hecar';
  cSButtonTest = 'Pro&bar';
  cSButtonOk = '&Aceptar';
  cSButtonCancel = '&Cancelar';
  cSTableAlias = 'A&lias de la tabla';
  cSReplaceSQL = '&Reemplazar SQL';
  cSDialogOpenTitle = 'Abrir archivo SQL';
  cSDialogSaveTitle = 'Guardar archivo SQL';
  cSSQLEditor = 'Editor SQL';
  cSDatabaseDialog = 'Abrir base de datos existente';

  cSUpdateSQLNoResult = 'Translate : Update Refresh SQL delivered no resultset';
  cSUpdateSQLRefreshStatementcount ='Translate : Update Refresh SQL Statement count must be 1';

  {$IFDEF FPC}
  cSNotEditing = 'El Dataset no se encuentra en modo de edicin o insercin';
  cSFieldTypeMismatch = 'El Tipo de dato no coincide para el campo ''%s'', se espera: %s, actual: %s';
  cSFieldSizeMismatch = 'El Tamao de dato no coincide para el campo ''%s'', se espera: %d, actual: %d';
  {$ENDIF}
  cSNeedField               = 'Translate: Field %s is required, but not supplied.';

  cSFailedtoInitPrepStmt   = 'Translate: Prepared statement failed to initialize';
  cSFailedtoPrepareStmt    = 'Translate: Statement failed during prepare process';
  cSFailedToBindAllValues  = 'Translate: Application failed to pre-bind all values';
  cSAttemptExecOnBadPrep   = 'Translate: Attempt made to execute a statement before a successful preparation.';
  cSBindingFailure         = 'Translate: Failed to bind parameter set';
  cSPreparedStmtExecFailure = 'Translate: Prepared statement failed to execute';
  cSBoundVarStrIndexMissing = 'Translate: Bound variable text index "%s" does not exist';
  cSBindVarOutOfRange      = 'Translate: Bound variable index out of range: %d';
  cSFailedToBindResults    = 'Translate: Application failed to bind to the result set';
  cSPreviousResultStillOpen = 'Previous resultset of this statement is still open';

  cSRefreshRowOnlySupportedWithUpdateObject = 'TRANSLATE: The refreshrow method is only supported with an update object';
  cSMustBeInBrowseMode = 'TRANSLATE: Operation is only allowed in dsBROWSE state';

  cSUnKnownParamDataType = 'TRANSLATE: Unknown Param.DataType';
  cSFieldReadOnly          = 'Translate : Readonly field can''t be assigned a value: %d';
  cSInvalidUpdateCount     = 'Translate : %d record(s) updated. Only one record should have been updated.';

  cSRowBufferWidthExceeded ='Translate: Row buffer width exceeded. Try using fewer or longer columns in SQL query.';
{$ELSE}

{$IFDEF ROMANA}

  SSQLError1 = 'SQL Eroare: %s';
  cSSQLError2 = 'SQL Eroare: %s Cod: %d';
  cSSQLError3 = 'SQL Eroare: %s Cod: %d SQL: %s';
  cSSQLError4 = 'SQL Eroare: %s Cod: %d Mesaj: %s';

  cSListCapacityError = 'Capacitatea listei este n afara limitelor (%d)';
  cSListCountError = 'Contorul listei este n afara limitelor (%d)';
  cSListIndexError = 'Indexul listei este n afara limitelor (%d)';

  cSClonningIsNotSupported = 'Clonning nu este suportat de aceast clas';
  cSImmutableOpIsNotAllowed = 'Operaia nu este permis ori colecia nu este modificabil';
  cSStackIsEmpty = 'Stiva este goal';
  cSVariableWasNotFound = 'Variabila "%s" nu a fost gsit';
  cSFunctionWasNotFound = 'Funcia "%s" nu a fost gsit';
  cSInternalError = 'Eroare Intern';
  cSSyntaxErrorNear = 'Eroare de sintax lng "%s"';
  cSSyntaxError = 'Eroare de sintax';
  cSUnknownSymbol = 'Simbol necunoscut "%s"';
  cSUnexpectedExprEnd = 'Final neateptat pentru expresie';
  cSRightBraceExpected = ') ateptat';
  cSParametersError = 'parametrul %d a fost ateptat dar %d a fost gsit';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams = 'Mai nult de doi parametrii sunt ateptai';
  cSInvalidVarByteArray = 'Arie VarByte invalid';
  cSVariableAlreadyExists = 'Variabila "%s" deja exist';
  cSTypesMismatch = 'Tip nepotrivit';
  cSUnsupportedVariantType = 'Tip variant neasteptat';
  cSUnsupportedOperation = 'Operaie nesuportat';

  cSTokenizerIsNotDefined = 'Simbolistica nu este definit';
  cSLibraryNotFound = 'None of the dynamic libraries can be found: %s';
  cSEncodeDateIsNotSupported = 'Aceast versiune nu suport isc_encode_sql_date';
  cSEncodeTimeIsNotSupported = 'Aceast versiune nu suport isc_encode_sql_time';
  cSEncodeTimestampIsNotSupported = 'Aceast versiune nu suport isc_encode_sql_timestamp';
  cSDecodeDateIsNotSupported = 'Aceast versiune nu suport isc_decode_sql_date';
  cSDecodeTimeIsNotSupported = 'Aceast versiune nu suport isc_decode_sql_time';
  cSDecodeTimestampIsNotSupported = 'Aceast versiune nu suport isc_decode_sql_timestamp';

  cSCanNotRetrieveResultSetData = 'Nu pot returna  Resultset data';
  cSRowBufferIsNotAssigned = 'Row buffer nu este asignat';
  cSColumnIsNotAccessable = 'Column with index %d nu este accesibil';
  cSConvertionIsNotPossible = 'Conversia nu este posibil pentru coloana %d din %s n %s';
  cSCanNotAccessBlobRecord = 'Nu pot aceesa nregistrarea blob n coloana %d cu tipul %s';
  cSRowDataIsNotAvailable = 'Row data nu este disponibil';
  cSResolverIsNotSpecified = 'Resolver nu este specificat pentru acest ResultSet';
  cSResultsetIsAlreadyOpened = 'Resultset este deja deschis';
  cSCanNotUpdateEmptyRow = 'Nu pot updata o nregistrare goal';
  cSCanNotUpdateDeletedRow = 'Nu pot updata o nregistrare tears';
  cSCanNotDeleteEmptyRow = 'Nu pot terge o nregistrare goal';
  cSCannotUseCommit = 'Nu poi folosi COMMIT n modul AUTOCOMMIT ';
  cSCannotUseRollBack = 'Nu poi folosi ROLLBACK n modul AUTOCOMMIT ';
  cSCanNotUpdateComplexQuery = 'Nu pot updata un query complex cu mai mult de un tabel';
  cSCanNotUpdateThisQueryType = 'Nu pot updata acest tip de query';
  cSDriverWasNotFound = 'Driverul pentru baza de date nu a fost gsit';
  cSCanNotConnectToServer = 'Nu ma pot conecta la serverul SQL';
  cSTableIsNotSpecified = 'Tbelul nu este specificat';
  cSLiveResultSetsAreNotSupported = 'Live query is not supported by this class';
  cSInvalidInputParameterCount = 'Input parameter count is less then expected';
  cSIsolationIsNotSupported = 'Transaction isolation level nu este suportat';
  cSColumnWasNotFound = 'Coloana cu numele "%s" nu a fost fsit';
  cSWrongTypeForBlobParameter = 'Tip greit pentru parametru Blob';
  cSIncorrectConnectionURL = 'Conexiune URL incorect: %s';
  cSUnsupportedProtocol = 'Protocol nesuportat: %s';
  cSUnsupportedByDriver    = 'Driver nu poate suporta aceast facilitate : [%s]';

  cSConnectionIsNotOpened = 'Conexiune nu este deschis inc';
  cSInvalidOpInAutoCommit = 'Operaie invalid n modul AutoCommit';
  cSInvalidOpInNonAutoCommit = 'Operaie invalid n modul non AutoCommit ';
  cSInvalidOpPrepare = 'Prepare transaction only possible on matching first(!) Starttransaction';

  cSConnectionIsNotAssigned = 'Nu este asignat o component Database connection';
  cSQueryIsEmpty = 'SQL Query este gol';
  cSCanNotExecuteMoreQueries = 'Nu pot executa mai mult de un query';
  cSOperationIsNotAllowed1 = 'Operaia nu este permis n modul FORWARD ONLY ';
  cSOperationIsNotAllowed2 = 'Operaia nu este permis n modul READ ONLY';
  cSOperationIsNotAllowed3 = 'Operaia nu este permis n modul %s ';
  cSOperationIsNotAllowed4 = 'Operaia nu este permis pentru n dataset nchis';
  cSNoMoreRecords = 'Nu mai sunt nregistrri n Resultset';
  cSCanNotOpenResultSet = 'Nu pot deschide Resultset';
  cSCanNotOpenDataSetWhenDestroying ='Translate : Cannot open a dataset when the componentstate is dsDestroying';
  cSCircularLink = 'Datasource makes a circular link';
  cSBookmarkWasNotFound = 'Bookmark nu a fost gsit';
  cSIncorrectSearchFieldsNumber = 'Numr incorect of search field values';
  cSInvalidOperationInTrans = 'Operaie invalid n modul explicit transaction';
  cSIncorrectSymbol = 'Simbol incorect n lista de cmpuri  "%s".';
  cSIncorrectToken = 'Incorect token dup ":"';
  cSIncorrectParamChar = 'TRANSLATE : Invalid value for ParamChar';

  cSSelectedTransactionIsolation = 'Selected transaction isolation level is not supported';
  cSDriverNotSupported = 'Driver nesuportat %s';
  cSPattern2Long = 'Pattern is too long';
  cSDriverNotCapableOutParameters = 'Driver nu este capabil s mnuie parametrii';
  cSStatementIsNotAllowed = 'Statement nu sunt permise';
  cSStoredProcIsNotAllowed = 'The stored proc nu sunt permise';
  cSCannotPerformOperation = 'Nu se pot face operaii cu Resultset nchis';
  cSInvalidState = 'Stare invalid';
  cSErrorConvertion = 'Eroare de conversie';
  cSDataTypeDoesNotSupported = 'Tip de dat nesuportat';
  cSUnsupportedParameterType = 'Tip parametru nesuportat';
  cSUnsupportedDataType = 'Tip dat nesuportat';
  cSErrorConvertionField = 'Eroare de conversie pentru cmpul "%s" n TipSQL "%s"';
  cSBadOCI = 'Bad OCI version [%s]. Version 8.0.3 or older is required';
  cSConnect2AsUser = 'Conectare la "%s" ca utlizator "%s"';
  cSUnknownError = 'Eroare necunoscut';
  cSFieldNotFound1 = 'Cmpul "%s" nu a fost gsit';
  cSFieldNotFound2 = 'Cmpul %d nu a fost gsit';

  cSLoginPromptFailure = 'Nu gsesc fereastra de dialog implicit pentru login. V rog adugai DBLogDlg n seciunea uses.';

  cSPropertyQuery = 'The Query may last a while on large databases!';
  cSPropertyTables = 'You should limit it by Catalog and/or Schema.';
  cSPropertyColumns = 'You should limit it by Catalog, Schema and/or TableName.';
  cSPropertyProcedures = 'You should limit it by Catalog and/or Schema.';
  cSPropertySequences = 'You should limit it by Catalog and/or Schema.';
  cSPropertyExecute = 'Query va fi executat oricum?';

  cSFormTest = 'ZEOS SQL Editor Test';
  cSButtonClose = 'n&chide';
  cSFormEditor = 'ZEOS SQL Editor';
  cSTabSheetSelect = 'Select SQL';
  cSMenuLoad = 'Deschide';
  cSMenuSave = 'Salvare';
  cSButtonGenerate = '&Generare';
  cSButtonCheck = 'Verificare';
  cSButtonTest = '&Test';
  cSButtonOk = '&OK';
  cSButtonCancel = 'Revo&care';
  cSTableAlias = 'T&able alias';
  cSReplaceSQL = '&Replace SQL';
  cSDialogOpenTitle = 'Deschide Fiier SQL';
  cSDialogSaveTitle = 'Salveaz Fiier SQL';
  cSSQLEditor = 'SQL Editor';
  cSDatabaseDialog = 'Deschide baz date existent';

  cSUpdateSQLNoResult = '"Update Refresh SQL" furnizat nu este un recordset';
  cSUpdateSQLRefreshStatementcount ='Declaraia "Update Refresh SQL" ca numr trebuie s fie una';

  {$IFDEF FPC}
  cSNotEditing = 'Dataset nu este n modul de editare sau inserare';
  cSFieldTypeMismatch = 'Tip nepotrivit pentru cmpul ''%s'', ateptat: %s actual: %s';
  cSFieldSizeMismatch = 'Dimensiune nepotrivit pentru cmpul  ''%s'', ateptat: %d actual: %d';
  {$ENDIF}
  cSNeedField               = 'Translate: Field %s is required, but not supplied.';

  cSFailedtoInitPrepStmt   = 'Translate: Prepared statement failed to initialize';
  cSFailedtoPrepareStmt    = 'Translate: Statement failed during prepare process';
  cSFailedToBindAllValues  = 'Translate: Application failed to pre-bind all values';
  cSAttemptExecOnBadPrep   = 'Translate: Attempt made to execute a statement before a successful preparation.';
  cSBindingFailure         = 'Translate: Failed to bind parameter set';
  cSPreparedStmtExecFailure = 'Translate: Prepared statement failed to execute';
  cSBoundVarStrIndexMissing = 'Translate: Bound variable text index "%s" does not exist';
  cSBindVarOutOfRange      = 'Translate: Bound variable index out of range: %d';
  cSFailedToBindResults    = 'Translate: Application failed to bind to the result set';
  cSPreviousResultStillOpen = 'Previous resultset of this statement is still open';

  cSRefreshRowOnlySupportedWithUpdateObject = 'TRANSLATE: The refreshrow method is only supported with an update object';
  cSMustBeInBrowseMode = 'TRANSLATE: Operation is only allowed in dsBROWSE state';

  cSUnKnownParamDataType = 'TRANSLATE: Unknown Param.DataType';

  cSRowBufferWidthExceeded ='Translate: Row buffer width exceeded. Try using fewer or longer columns in SQL query.';
  // <-- added by tohenk
  {$ELSE}
  {$IFDEF INDONESIAN}
  cSSQLError1 = 'Kesalahan SQL: %s';
  cSSQLError2 = 'Kesalahan SQL: %s Kode: %d';
  cSSQLError3 = 'Kesalahan SQL: %s Kode: %d SQL: %s';
  cSSQLError4 = 'Kesalahan SQL: %s Kode: %d Pesan: %s';

  cSListCapacityError = 'Kapasitas List diluar jangkauan (%d)';
  cSListCountError = 'Jumlah List diluar jangkauan (%d)';
  cSListIndexError = 'Indeks List diluar jangkauan (%d)';

  cSClonningIsNotSupported = 'Class ini tidak mendukung kloning';
  cSImmutableOpIsNotAllowed = 'Operasi tidak diperkenankan pada koleksi yang tidak dapat diubah';
  cSStackIsEmpty = 'Stack kosong';
  cSVariableWasNotFound = 'Variabel "%s" tidak ada';
  cSFunctionWasNotFound = 'Fungsi "%s" tidak ada';
  cSInternalError = 'Kesalahan internal';
  cSSyntaxErrorNear = 'Kesalahan Syntax di dekat "%s"';
  cSSyntaxError = 'Kesalahan Syntax';
  cSUnknownSymbol = 'Simbol tidak dikenali "%s"';
  cSUnexpectedExprEnd = 'Tidak dibutuhkan, akhir dari ekspresi';
  cSRightBraceExpected = ') dibutuhkan';
  cSParametersError = '%d parameter dibutuhkan tapi terdapat %d parameter';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams = 'Dibutuhkan lebih dari dua parameter';
  cSInvalidVarByteArray = 'array VarByte tidak valid';
  cSVariableAlreadyExists = 'Variabel "%s" sudah ada';
  cSTypesMismatch = 'Tipe tidak sesuai';
  cSUnsupportedVariantType = 'Tipe variant tidak didukung';
  cSUnsupportedOperation = 'Operasi tidak didukung';

  cSTokenizerIsNotDefined = 'Tokenizer belum ditentukan';
  cSLibraryNotFound = 'Tidak ada library ditemukan: %s';
  cSEncodeDateIsNotSupported = 'Versi ini tidak mendukung isc_encode_sql_date';
  cSEncodeTimeIsNotSupported = 'Versi ini tidak mendukung isc_encode_sql_time';
  cSEncodeTimestampIsNotSupported = 'Versi ini tidak mendukung isc_encode_sql_timestamp';
  cSDecodeDateIsNotSupported = 'Versi ini tidak mendukung isc_decode_sql_date';
  cSDecodeTimeIsNotSupported = 'Versi ini tidak mendukung isc_decode_sql_time';
  cSDecodeTimestampIsNotSupported = 'Versi ini tidak mendukung isc_decode_sql_timestamp';

  cSCanNotRetrieveResultSetData = 'Tidak dapat mengambil data Resultset';
  cSRowBufferIsNotAssigned = 'Row buffer tidak disediakan';
  cSColumnIsNotAccessable = 'Kolom dengan indeks %d tidak dapat diakses';
  cSConvertionIsNotPossible = 'Konversi tidak dimungkinkan pada kolom %d dari %s ke %s';
  cSCanNotAccessBlobRecord = 'Tidak dapat mengakses rekord `blob` pada kolom %d dengan tipe %s';
  cSRowDataIsNotAvailable = 'Data Row tidak tersedia';
  cSResolverIsNotSpecified = 'Resolver belum ditentukan pada ResultSet ini';
  cSResultsetIsAlreadyOpened = 'Resultset sudah terbuka';
  cSCanNotUpdateEmptyRow = 'Tidak dapat meng-update row kosong';
  cSCanNotUpdateDeletedRow = 'Tidak dapat meng-update row terhapus';
  cSCanNotDeleteEmptyRow = 'Tidak dapat meng-hapus row kosong';
  cSCannotUseCommit = 'COMMIT tidak dapat digunakan pada mode AUTOCOMMIT';
  cSCannotUseRollBack = 'ROLLBACK tidak dapat digunakan pada mode AUTOCOMMIT';
  cSCanNotUpdateComplexQuery = 'Tidak dapat meng-update query kompleks dengan lebih dari satu tabel';
  cSCanNotUpdateThisQueryType = 'Tidak dapat meng-update query dengan tipe ini';
  cSDriverWasNotFound = 'Driver database yang diminta tidak ada';
  cSCanNotConnectToServer = 'Tidak dapat terhubung ke server SQL';
  cSTableIsNotSpecified = 'Tabel belum ditentukan';
  cSLiveResultSetsAreNotSupported = 'Live query tidak didukung oleh Class ini';
  cSInvalidInputParameterCount = 'Jumlah parameter Input kurang dari yang dibutuhkan';
  cSIsolationIsNotSupported = 'Level Isolasi Transaksi tidak didukung';
  cSColumnWasNotFound = 'Kolom dengan nama "%s" tidak ada';
  cSWrongTypeForBlobParameter = 'Salah tipe untuk parameter Blob';
  cSIncorrectConnectionURL = 'Salah koneksi URL: %s';
  cSUnsupportedProtocol = 'Protokol tidak didukung: %s';
  cSUnsupportedByDriver    = 'Driver tidak mendukung fitur: [%s]';

  cSConnectionIsNotOpened = 'Koneksi belum dibuka';
  cSInvalidOpInAutoCommit = 'Operasi tidak valid pada mode AUTOCOMMIT';
  cSInvalidOpInNonAutoCommit = 'Operasi tidak valid pada mode non AUTOCOMMIT';
  cSInvalidOpPrepare = 'Persiapan transaksi hanya mungkin pada (!) Starttransaction pertama';

  cSConnectionIsNotAssigned = 'Komponen koneksi Database tidak ditentukan';
  cSQueryIsEmpty = 'Query SQL kosong';
  cSCanNotExecuteMoreQueries = 'Tidak dapat meng-eksekusi lebih dari satu query';
  cSOperationIsNotAllowed1 = 'Operasi tidak diperkenankan pada mode FORWARD ONLY';
  cSOperationIsNotAllowed2 = 'Operasi tidak diperkenankan pada mode READ ONLY';
  cSOperationIsNotAllowed3 = 'Operasi tidak diperkenankan pada mode %s';
  cSOperationIsNotAllowed4 = 'Operasi tidak diperkenankan pada dataset tertutup';
  cSNoMoreRecords = 'Tidak ada rekord lagi pada Resultset';
  cSCanNotOpenResultSet = 'Tidak dapat membuka Resultset';
  cSCanNotOpenDataSetWhenDestroying ='Translate : Cannot open a dataset when the componentstate is dsDestroying';
  cSCircularLink = 'Terjadi hubungan Datasource circular';
  cSBookmarkWasNotFound = 'Bookmark tidak ada';
  cSIncorrectSearchFieldsNumber = 'Salah jumlah nilai field pada pencarian';
  cSInvalidOperationInTrans = 'Operasi tidak valid pada mode explicit transaction';
  cSIncorrectSymbol = 'Simbol salah pada daftar field "%s".';
  cSIncorrectToken = 'Token salah setelah ":"';
  cSIncorrectParamChar = 'TRANSLATE : Invalid value for ParamChar';

  cSSelectedTransactionIsolation = 'Level Isolasi Transaksi terpilih tidak didukung';
  cSDriverNotSupported = 'Driver tidak mendukung %s';
  cSPattern2Long = 'Pola terlalu panjang';
  cSDriverNotCapableOutParameters = 'Driver tidak mampu menangani parameter';
  cSStatementIsNotAllowed = 'Statement tidak diperbolehkan';
  cSStoredProcIsNotAllowed = 'StoredProc tidak diperbolehkan';
  cSCannotPerformOperation = 'Tidak dapat melakukan operasi pada Resultset tertutup';
  cSInvalidState = 'Sate tidak valid';
  cSErrorConvertion = 'Kesalahan konversi';
  cSDataTypeDoesNotSupported = 'Tipe Data tidak didukung';
  cSUnsupportedParameterType = 'Tidak mendukung tipe parameter';
  cSUnsupportedDataType = 'Tidak mendukung tipe data';
  cSErrorConvertionField = 'Kesalahan konversi field "%s" ke Tipe SQL "%s"';
  cSBadOCI = 'OCI version [%s] tidak sah. Dibutuhkan versi 8.0.3 atau terdahulu';
  cSConnect2AsUser = 'Koneksi ke "%s" dengan user "%s"';
  cSUnknownError = 'Kesalahan tidak diketahui';
  cSFieldNotFound1 = 'Field "%s" tidak ada';
  cSFieldNotFound2 = 'Field %d tidak ada';

  cSLoginPromptFailure = 'Tidak ada dialog Login default. Silahkan tambahkan DBLogDlg ke klausula `uses` pada file utama.';

  cSPropertyQuery = 'Query mungkin berlangsung lama pada database besar!';
  cSPropertyTables = 'Batasi dengan Katalog data/atau Skema.';
  cSPropertyColumns = 'Batasi dengan Katalog, Skema dan/atau Nama Tabel.';
  cSPropertyProcedures = 'Batasi dengan Katalog dan/atau Skema.';
  cSPropertySequences = 'Batasi dengan Katalog dan/atau Skema.';
  cSPropertyExecute = 'Apakah Query jadi dieksekusi?';

  cSFormTest = 'Tes Editor SQLZEOS';
  cSButtonClose = '&Tutup';
  cSFormEditor = 'Editor SQL ZEOS';
  cSTabSheetSelect = 'SQL Select';
  cSMenuLoad = 'Ambil';
  cSMenuSave = 'Simpan';
  cSButtonGenerate = '&Generate';
  cSButtonCheck = '&Cek';
  cSButtonTest = 'T&es';
  cSButtonOk = '&OK';
  cSButtonCancel = '&Batal';
  cSTableAlias = 'Alias T&abel';
  cSReplaceSQL = 'SQL &Replace';
  cSDialogOpenTitle = 'Buka File SQL';
  cSDialogSaveTitle = 'Simpan File SQL';
  cSSQLEditor = 'Editor SQL';
  cSDatabaseDialog = 'Buka database yang tersedia';

  cSUpdateSQLNoResult = 'Tidak ada Resultset pada Update Refresh SQL';
  cSUpdateSQLRefreshStatementcount ='Jumlah Statement pada Update Refresh SQL harus 1';

  {$IFDEF FPC}
  cSNotEditing = 'Dataset tidak dalam mode edit atau sisip';
  cSFieldTypeMismatch = 'Tipe tidak sesuai pada field ''%s'', seharusnya: %s aktual: %s';
  cSFieldSizeMismatch = 'Ukuran tidak sesuai pada field ''%s'', seharusnya: %d aktual: %d';
  {$ENDIF}
  cSNeedField               = 'Field %s diperlukan, namun tidak disediakan.';

  cSFailedtoInitPrepStmt   = 'Gagal inisialisasi Prepared statement';
  cSFailedtoPrepareStmt    = 'Statemen gagal sewaktu proses persiapan';
  cSFailedToBindAllValues  = 'Aplikasi gagal dalam penggabungan pendahuluan semua nilai';
  cSAttemptExecOnBadPrep   = 'Percobaan eksekusi statemen dilakukan sebelum persiapan berhasil.';
  cSBindingFailure         = 'Gagal menggabungkan parameter';
  cSPreparedStmtExecFailure = 'Prepared Statement gagal dieksekusi';
  cSBoundVarStrIndexMissing = 'Teks variabel indeks "%s" tidak ada';
  cSBindVarOutOfRange      = 'Variabel indeks diluar jangkauan: %d';
  cSFailedToBindResults    = 'Aplikasi gagal pada penggabungan ke Resultset';
  cSPreviousResultStillOpen = 'Previous resultset of this statement is still open';

  cSRefreshRowOnlySupportedWithUpdateObject = 'Metode RefreshRow hanya didukung oleh obyek Update';
  cSMustBeInBrowseMode = 'Operasi hanya diperbolehkan pada status dsBrowse';

  cSUnKnownParamDataType = 'Param.DataType tidak dikenal';
  cSFieldReadOnly          = 'Field readonly tidak dapat diberikan nilai: %d';
  cSInvalidUpdateCount     = '%d rekord terupdate. Seharusnya hanya satu rekord yang terupdate.';

  cSRowBufferWidthExceeded = 'Lebar buffer baris terlampaui. Coba kurangi atau gunakan kolom yang lebih panjang dalam query SQL.';
  // <--- end added by tohenk
  //--- begin added by ORMADA --------------------------------------------------
{$ELSE}
{$IFDEF RUSSIAN}
  cSSQLError1                               = '  SQL : %s';
  cSSQLError2                               = '  SQL : %s  : %d';
  cSSQLError3                               = '  SQL : %s  : %d SQL: %s';
  cSSQLError4                               = '  SQL : %s  : %d : %s';

  cSListCapacityError                       = '     (%d)';
  cSListCountError                          = '     (%d)';
  cSListIndexError                          = '     (%d)';

  cSClonningIsNotSupported                  = '    ';
  cSImmutableOpIsNotAllowed                 = '     ';
  cSStackIsEmpty                            = ' ';
  cSVariableWasNotFound                     = ' "%s"  ';
  cSFunctionWasNotFound                     = ' "%s"  ';
  cSInternalError                           = ' ';
  cSSyntaxErrorNear                         = '   "%s"';
  cSSyntaxError                             = '  ';
  cSUnknownSymbol                           = '  "%s"';
  cSUnexpectedExprEnd                       = '  ';
  cSRightBraceExpected                      = ') ';
  cSParametersError                         = ' %d ,  %d';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams                      = '  2- ';
  cSInvalidVarByteArray                     = '  (VarByte)';
  cSVariableAlreadyExists                   = ' "%s"  ';
  cSTypesMismatch                           = ' ';
  cSUnsupportedVariantType                  = '  (variant) ';
  cSUnsupportedOperation                    = ' ';

  cSTokenizerIsNotDefined                   = '  ';
  cSLibraryNotFound                         = '     : %s';
  cSEncodeDateIsNotSupported                = '    isc_encode_sql_date';
  cSEncodeTimeIsNotSupported                = '    isc_encode_sql_time';
  cSEncodeTimestampIsNotSupported           = '    isc_encode_sql_timestamp';
  cSDecodeDateIsNotSupported                = '    isc_decode_sql_date';
  cSDecodeTimeIsNotSupported                = '    isc_decode_sql_time';
  cSDecodeTimestampIsNotSupported           = '    isc_decode_sql_timestamp';

  cSCanNotRetrieveResultSetData             = '    (Resultset)';
  cSRowBufferIsNotAssigned                  = '   ';
  cSColumnIsNotAccessable                   = '    %d';
  cSConvertionIsNotPossible                 = '    %d  %s  %s';
  cSCanNotAccessBlobRecord                  = '    blob    %d   %s';
  cSRowDataIsNotAvailable                   = '  ';
  cSResolverIsNotSpecified                  = '    (ResultSet)   Resolver';
  cSResultsetIsAlreadyOpened                = '  (Resultset)  ';
  cSCanNotUpdateEmptyRow                    = '   ';
  cSCanNotUpdateDeletedRow                  = '   ';
  cSCanNotDeleteEmptyRow                    = '   ';
  cSCannotUseCommit                         = '  COMMIT  AUTOCOMMIT ';
  cSCannotUseRollBack                       = '  ROLLBACK  AUTOCOMMIT ';
  cSCanNotUpdateComplexQuery                = '        ';
  cSCanNotUpdateThisQueryType               = '    ';
  cSDriverWasNotFound                       = '    ';
  cSCanNotConnectToServer                   = '   SQL ';
  cSTableIsNotSpecified                     = '  ';
  cSLiveResultSetsAreNotSupported           = '      ';
  cSInvalidInputParameterCount              = '   is   ';
  cSIsolationIsNotSupported                 = '    ';
  cSColumnWasNotFound                       = '     "%s"';
  cSWrongTypeForBlobParameter               = '   Blob ';
  cSIncorrectConnectionURL                  = '  (URL)  : %s';
  cSUnsupportedProtocol                     = ' : %s';
  cSUnsupportedByDriver                     = '     : [%s]';

  cSConnectionIsNotOpened                   = '  ';
  cSInvalidOpInAutoCommit                   = '     (AutoCommit)';
  cSInvalidOpInNonAutoCommit                = '      (non AutoCommit)';
  cSInvalidOpPrepare                        = '      (!) StartTransaction';

  cSConnectionIsNotAssigned                 = '    ';
  cSQueryIsEmpty                            = 'SQL  ';
  cSCanNotExecuteMoreQueries                = '    ';
  cSOperationIsNotAllowed1                  = '       (FORWARD ONLY)';
  cSOperationIsNotAllowed2                  = '        (READ ONLY)';
  cSOperationIsNotAllowed3                  = '    %s ';
  cSOperationIsNotAllowed4                  = '      ';
  cSNoMoreRecords                           = '   (Resultset)  ';
  cSCanNotOpenResultSet                     = '    (Resultset)';
  cSCanNotOpenDataSetWhenDestroying ='Translate : Cannot open a dataset when the componentstate is dsDestroying';
  cSCircularLink                            = '  (Datasource)   ';
  cSBookmarkWasNotFound                     = ' (Bookmark)  ';
  cSIncorrectSearchFieldsNumber             = '   Incorrect number of search field values';
  cSInvalidOperationInTrans                 = '    ';
  cSIncorrectSymbol                         = '     "%s".';
  cSIncorrectToken                          = '   ":"';
  cSIncorrectParamChar = 'TRANSLATE : Invalid value for ParamChar';

  cSSelectedTransactionIsolation            = '     ';
  cSDriverNotSupported                      = '   %s';
  cSPattern2Long                            = '  ';
  cSDriverNotCapableOutParameters           = '    ';
  cSStatementIsNotAllowed                   = '  ';
  cSStoredProcIsNotAllowed                  = '   ';
  cSCannotPerformOperation                  = '       (Resultset)';
  cSInvalidState                            = ' ';
  cSErrorConvertion                         = ' ';
  cSDataTypeDoesNotSupported                = '   ';
  cSUnsupportedParameterType                = '  ';
  cSUnsupportedDataType                     = '  ';
  cSErrorConvertionField                    = '    "%s"  SQLType "%s"';
  cSBadOCI                                  = '  OCI [%s].   8.0.3  ';
  cSConnect2AsUser                          = '   "%s"  "%s"';
  cSUnknownError                            = ' ';
  cSFieldNotFound1                          = ' "%s"  ';
  cSFieldNotFound2                          = ' %d  ';

  cSLoginPromptFailure                      = '     .   DBLogDlg   uses   .';

  cSPropertyQuery                           = '        The Query may last a while on large databases!';
  cSPropertyTables                          = '  (Catalog) /  (Schema)';
  cSPropertyColumns                         = '   (Catalog),  (Schema) /  (TableName).';
  cSPropertyProcedures                      = '  (Catalog) /  (Schema).';
  cSPropertySequences                       = '  (Catalog) /  (Schema).';
  cSPropertyExecute                         = '    ?';

  cSFormTest                                = 'ZEOS SQL  ';
  cSButtonClose                             = '&';
  cSFormEditor                              = 'ZEOS SQL ';
  cSTabSheetSelect                          = ' SQL';
  cSMenuLoad                                = '';
  cSMenuSave                                = '';
  cSButtonGenerate                          = '&';
  cSButtonCheck                             = '&';
  cSButtonTest                              = '&';
  cSButtonOk                                = '&';
  cSButtonCancel                            = '&';
  cSTableAlias                              = '& ';
  cSReplaceSQL                              = '& SQL';
  cSDialogOpenTitle                         = ' SQL ';
  cSDialogSaveTitle                         = ' SQL ';
  cSSQLEditor                               = 'SQL ';
  cSDatabaseDialog                          = '  ';

  cSUpdateSQLNoResult                       = '   (Refresh)   ';
  cSUpdateSQLRefreshStatementcount          = 'Refresh     ';

{$IFDEF FPC}
  cSNotEditing                              = '  (Dataset)      ';
  cSFieldTypeMismatch                       = '    ''%s'',  %s : %s';
  cSFieldSizeMismatch                       = '  ''%s''  , : %d : %d';
{$ENDIF}
  cSNeedField               = 'Translate: Field %s is required, but not supplied.';

  cSFailedtoInitPrepStmt                    = '   ';
  cSFailedtoPrepareStmt                     = '     ';
  cSFailedToBindAllValues                   = '  - ';
  cSAttemptExecOnBadPrep                    = '     .';
  cSBindingFailure                          = '   ';
  cSPreparedStmtExecFailure                 = '   ';
  cSBoundVarStrIndexMissing                 = '     "%s"  ';
  cSBindVarOutOfRange                       = '     : %d';
  cSFailedToBindResults                     = ' (bind)  ';
  cSPreviousResultStillOpen = 'Previous resultset of this statement is still open';

  cSRefreshRowOnlySupportedWithUpdateObject = '   (RefreshRow)     ';
  cSMustBeInBrowseMode                      = '      (dsBROWSE)';

  cSUnKnownParamDataType                    = '   (Param.DataType)';
  //--- end added by ORMADA ----------------------------------------------------
  cSFieldReadOnly          = 'Translate : Readonly field can''t be assigned a value: %d';
  cSInvalidUpdateCount     = 'Translate : %d record(s) updated. Only one record should have been updated.';

  cSRowBufferWidthExceeded ='Translate: Row buffer width exceeded. Try using fewer or longer columns in SQL query.';
{$ELSE}

//--- added by Petr Stasiak - pestasoft.com ------------------------------------
{$IFDEF CZECH}
  cSSQLError1 = 'SQL chyba: %s';
  cSSQLError2 = 'SQL chyba: %s kd: %d';
  cSSQLError3 = 'SQL chyba: %s kd: %d SQL: %s';
  cSSQLError4 = 'SQL chyba: %s kd: %d Hlen: %s';

  cSListCapacityError = 'Kapacita seznamu je mimo rozsah (%d)';
  cSListCountError = 'Poet seznam je mimo rozsah (%d)';
  cSListIndexError = 'Index v seznamu je mimo rozsah (%d)';

  cSClonningIsNotSupported = 'Klonovn nen v tto td podporovno';
  cSImmutableOpIsNotAllowed = 'Tato operace nen povolena na nemniteln "collections"';
  cSStackIsEmpty = 'Zsobnk je przdn';
  cSVariableWasNotFound = 'Promn "%s" neexistuje';
  cSFunctionWasNotFound = 'Funkce "%s" neexistuje';
  cSInternalError = 'Intern chyba';
  cSSyntaxErrorNear = 'Chybn syntaxe "%s"';
  cSSyntaxError = 'Chybn syntaxe';
  cSUnknownSymbol = 'Neznm symbol "%s"';
  cSUnexpectedExprEnd = 'Neoekvan konec vrazu';
  cSRightBraceExpected = ') oekvn(o/a/y)';
  cSParametersError = '%d parametr oekvno, ale %d existuje';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams = 'Je oekvno vce, ne 2 parametry';
  cSInvalidVarByteArray = 'Nesprvn VarByte array';
  cSVariableAlreadyExists = 'Promn "%s" ji existuje';
  cSTypesMismatch = 'Nesouhlasn typy';
  cSUnsupportedVariantType = 'Nepodporovan typ variant';
  cSUnsupportedOperation = 'Nepodporovan operace';

  cSTokenizerIsNotDefined = 'Nen definovn "Tokenizer"';
  cSLibraryNotFound = 'Neexistuje dll knihovna(y): %s';
  cSEncodeDateIsNotSupported = 'Tato verze nepodporuje isc_encode_sql_date';
  cSEncodeTimeIsNotSupported = 'Tato verze nepodporuje isc_encode_sql_time';
  cSEncodeTimestampIsNotSupported = 'Tato verze nepodporuje isc_encode_sql_timestamp';
  cSDecodeDateIsNotSupported = 'Tato verze nepodporuje isc_decode_sql_date';
  cSDecodeTimeIsNotSupported = 'Tato verze nepodporuje isc_decode_sql_time';
  cSDecodeTimestampIsNotSupported = 'Tato verze nepodporuje isc_decode_sql_timestamp';

  cSCanNotRetrieveResultSetData = 'Nelze zskat data "Resultset"';
  cSRowBufferIsNotAssigned = 'Nen piazen dkov buffer';
  cSColumnIsNotAccessable = 'Sloupec s indexem %d nen pstupn';
  cSConvertionIsNotPossible = 'Pevod sloupce %d  nen mon z %s na %s';
  cSCanNotAccessBlobRecord = 'Nelze pistupovat k blob zznamu ze zloupce %d pes typ %s';
  cSRowDataIsNotAvailable = 'dkov data nejsou pstupn';
  cSResolverIsNotSpecified = 'Nen specifikovn "rozklada" pro tento vsledek';
  cSResultsetIsAlreadyOpened = '"Resultset" byl ji oteven';
  cSCanNotUpdateEmptyRow = 'Nelze aktualizovat przdn dek';
  cSCanNotUpdateDeletedRow = 'Nelze aktualizovat smazan dek';
  cSCanNotDeleteEmptyRow = 'Nelze vymazat przdn dek';
  cSCannotUseCommit = 'Nepouvejte COMMIT v mdu AUTOCOMMIT';
  cSCannotUseRollBack = 'Nelze pout ROLLBACK v AUTOCOMMIT mdu';
  cSCanNotUpdateComplexQuery = 'Nelze aktualizovat komplexn dotaz pro vce, ne jednu tabulku';
  cSCanNotUpdateThisQueryType = 'Nelze aktualizovat tento typ dotazu';
  cSDriverWasNotFound = 'Poadovan databzov ovlada nenalezen';
  cSCanNotConnectToServer = 'Nezdailo se pipojen k SQL serveru';
  cSTableIsNotSpecified = 'Tabulka nen specifikovna';
  cSLiveResultSetsAreNotSupported = '"iv" dotaz nen podporovn v tto td';
  cSInvalidInputParameterCount = 'Poet vstupnch parametr neodpovd oekvanmu potu';
  cSIsolationIsNotSupported = 'Mra izolace transakce nen podporovna';
  cSColumnWasNotFound = 'Sloupec s nzvem "%s" neexistuje';
  cSWrongTypeForBlobParameter = 'Nesprvn typ pro Blob parametr';
  cSIncorrectConnectionURL = 'Nesprvn tvar URL adresy: %s';
  cSUnsupportedProtocol = 'Nepodporovan protokol: %s';
  cSUnsupportedByDriver    = 'Ovlada nepodporuje tuto vlastnost: [%s]';

  cSConnectionIsNotOpened = 'Spojen nen oteveno';
  cSInvalidOpInAutoCommit = 'Nesprvn operace v mdu AutoCommit';
  cSInvalidOpInNonAutoCommit = 'Nesprvn operace v mdu NE AutoCommit';
  cSInvalidOpPrepare = '"Prepare" transakce je mon pouze jako prvn! Starttransaction';

  cSConnectionIsNotAssigned = 'Nen piazen komponent "connection"';
  cSQueryIsEmpty = 'SQL dotaz je przdn';
  cSCanNotExecuteMoreQueries = 'Nelze spustit vce, ne 1 dotaz';
  cSOperationIsNotAllowed1 = 'Operace nen povolena v mdu "FORWARD ONLY"';
  cSOperationIsNotAllowed2 = 'Operace nen povolena v mdu "READ ONLY"';
  cSOperationIsNotAllowed3 = 'Operace nen povolena v mdu "%s"';
  cSOperationIsNotAllowed4 = 'Operace nen povolena pro zaven zdroj dat (dataset)';
  cSNoMoreRecords = 'Nejsou dal zznamy';
  cSCanNotOpenResultSet = 'Nelze otevt vsledek dotazu';
  cSCanNotOpenDataSetWhenDestroying ='Translate : Cannot open a dataset when the componentstate is dsDestroying';
  cSCircularLink = 'Datasource vytv cyklick dotaz';
  cSBookmarkWasNotFound = 'Zloka neexistuje';
  cSIncorrectSearchFieldsNumber = 'Nesprvn poet vyhledvanch poloek';
  cSInvalidOperationInTrans = 'Nesprvn operace v explicitnm transaknm mdu';
  cSIncorrectSymbol = 'Nesprvn symbol v seznamu poloek "%s".';
  cSIncorrectToken = 'Za ":" nsleduje nesprvn znak';
  cSIncorrectParamChar = 'TRANSLATE : Invalid value for ParamChar';

  cSSelectedTransactionIsolation = 'Vybran mra izolace transakc nen podporovna';
  cSDriverNotSupported = 'Ovlada %s nen podporovn';
  cSPattern2Long = 'Pattern je pli dlouh';
  cSDriverNotCapableOutParameters = 'Ovlada nen schopen pijmat parametry';
  cSStatementIsNotAllowed = 'Pkaz nen povolen';
  cSStoredProcIsNotAllowed = '"stored proc" nen povolena';
  cSCannotPerformOperation = 'Nelze provst operaci na uzavenm vsledku dotazu (Resultset)';
  cSInvalidState = 'Nesprvn stav';
  cSErrorConvertion = 'Chyba pevodu';
  cSDataTypeDoesNotSupported = 'Tento typ dat nen podporovn';
  cSUnsupportedParameterType = 'Nepodporovan typ parametru';
  cSUnsupportedDataType = 'Nepodporovan typ dat';
  cSErrorConvertionField = 'Chyba pevodu sloupce "%s" na SQLTyp "%s"';
  cSBadOCI = 'patn verze OCI [%s]. Je vyadovna 8.0.3 nebo star';
  cSConnect2AsUser = 'Pipojit k "%s" jako "%s"';
  cSUnknownError = 'Neznm chyba';
  cSFieldNotFound1 = 'Sloupec "%s" neexistuje';
  cSFieldNotFound2 = 'Sloupec %d neexistuje';

  cSLoginPromptFailure = 'Nelze najt vchoz pihlaovac dialog. Prosm pidejte DBLogDlg do sekce USES vaeho zdrojovho souboru.';

  cSPropertyQuery = 'Dotaz me bt posledn u vlelkch databz!';
  cSPropertyTables = 'Mlo by bt limitovno katalogen a/nebo schmatem.';
  cSPropertyColumns = 'Mlo by bt limitovno katalogem, schmatem a/nebo nzvem tabulky.';
  cSPropertyProcedures = 'Mlo by bt limitovno katalogen a/nebo schmatem.';
  cSPropertySequences = 'Mlo by bt limitovno katalogen a/nebo schmatem.';
  cSPropertyExecute = 'M se dotaz pesto vykonat?';

  cSFormTest = 'ZEOS SQL Editor Test';
  cSButtonClose = '&Zavt';
  cSFormEditor = 'ZEOS SQL Editor';
  cSTabSheetSelect = 'Select SQL';
  cSMenuLoad = 'Nast';
  cSMenuSave = 'Uloit';
  cSButtonGenerate = '&Generovat';
  cSButtonCheck = '&Kontrola';
  cSButtonTest = '&Test';
  cSButtonOk = '&OK';
  cSButtonCancel = 'Z&ruit';
  cSTableAlias = '&Alias tabulky';
  cSReplaceSQL = 'Nah&radit SQL';
  cSDialogOpenTitle = 'Otevt SQL soubor';
  cSDialogSaveTitle = 'Uloit SQL soubor';
  cSSQLEditor = 'SQL Editor';
  cSDatabaseDialog = 'Otevt existujc databzi';

  cSUpdateSQLNoResult = 'Update Refresh SQL nevrtilo dn vsledek';
  cSUpdateSQLRefreshStatementcount ='Poet Update Refresh SQL pkaz mus bt 1';

  {$IFDEF FPC}
  cSNotEditing = 'Dataset nen v editanm (edit), ani vkldacm (insert) reimu';
  cSFieldTypeMismatch = 'Nesprvn typ pro sloupec ''%s'', oekvno: %s aktuln: %s';
  cSFieldSizeMismatch = 'Nesprvn velikost sloupce ''%s'', oekvno: %d aktuln: %d';
  {$ENDIF}
  cSNeedField               = 'Sloupce %s je poadovn, ale nezadn.';

  cSFailedtoInitPrepStmt   = 'Pipravovan pkaz nelze inicializovat';
  cSFailedtoPrepareStmt    = 'Pkaz selhal bhem ppravy procesu';
  cSFailedToBindAllValues  = 'Aplikace zkolabovala ped ppravou vech hodnot';
  cSAttemptExecOnBadPrep   = 'Pokoute sespustit pkaz ped dokonenm jeho ppravy.';
  cSBindingFailure         = 'Chyba pi zskvn sady parametr';
  cSPreparedStmtExecFailure = 'Pipravovan pkaz selhal pi vykonvn';
  cSBoundVarStrIndexMissing = 'Index textov promn "%s" neexistuje';
  cSBindVarOutOfRange      = 'Index promen je mimo rozsah: %d';
  cSFailedToBindResults    = 'Aplikace selhala pi zskvn vsledk dotazu';
  cSPreviousResultStillOpen = 'Previous resultset of this statement is still open';

//FOS+ 07112006
  cSRefreshRowOnlySupportedWithUpdateObject = 'Metoda "refreshrow" je podporovna pouze v "update object"';
  cSMustBeInBrowseMode = 'Operace je povolena pouze ve stavu dsBROWSE';

  cSUnKnownParamDataType = 'Neznm parametr.typ dat (Param.DataType)';
  cSFieldReadOnly        = 'Sloupec pouze pro ten neme bt piazen k hodnot: %d';
  cSInvalidUpdateCount     = '%d zznam() aktualizovno. Pouze jeden zznam byl zmnn.';

  cSRowBufferWidthExceeded ='Translate: Row buffer width exceeded. Try using fewer or longer columns in SQL query.';
//--- end added by Petr Stasiak - pestasoft.com ------------------------------------

{$ELSE}

//--- added by pawelsel --------------------------------------------------------
{$IFDEF POLISH}
  cSSQLError1 = 'Bd SQL: %s';
  cSSQLError2 = 'Bd SQL: %s Kod: %d';
  cSSQLError3 = 'Bd SQL: %s Kod: %d SQL: %s';
  cSSQLError4 = 'Bd SQL: %s Kod: %d Komunikat: %s';

  cSListCapacityError = 'Przekroczona pojemno listy (%d)';
  cSListCountError = 'Licznik listy poza zakresem (%d)';
  cSListIndexError = 'Indeks listy poza zakresem (%d)';

  cSClonningIsNotSupported = 'Ta klasa nie obsuguje klonowania';
  cSImmutableOpIsNotAllowed = 'Niedozwolona operacja na niezmienialnych kolekcjach';
  cSStackIsEmpty = 'Stos jest pusty';
  cSVariableWasNotFound = 'Nie znaleziono zmiennej "%s"';
  cSFunctionWasNotFound = 'Nie znaleziono funkcji "%s"';
  cSInternalError = 'Bd wewntrzny';
  cSSyntaxErrorNear = 'Bd skadni przy "%s"';
  cSSyntaxError = 'Bd skadni';
  cSUnknownSymbol = 'Nieznany symbol "%s"';
  cSUnexpectedExprEnd = 'Nieoczekiwany koniec wyraenia';
  cSRightBraceExpected = 'Oczekiwano znaku )';
  cSParametersError = 'Oczekiwana ilo parametrw: %d, znaleziono: %d';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams = 'Oczekiwano wicej ni dwa parametry';
  cSInvalidVarByteArray = 'Bdna tablica VarByte';
  cSVariableAlreadyExists = 'Zmienna "%s" ju istnieje';
  cSTypesMismatch = 'Niezgodno typw';
  cSUnsupportedVariantType = 'Nieznany typ danych';
  cSUnsupportedOperation = 'Nieznana operacja';

  cSTokenizerIsNotDefined = 'Nie zdefiniowano tokenizera';
  cSLibraryNotFound = 'Nie znaleziono adnej z bibliotek dynamicznych: %s';
  cSEncodeDateIsNotSupported = 'Ta wersja nie obsuguje isc_encode_sql_date';
  cSEncodeTimeIsNotSupported = 'Ta wersja nie obsuguje isc_encode_sql_time';
  cSEncodeTimestampIsNotSupported = 'Ta wersja nie obsuguje isc_encode_sql_timestamp';
  cSDecodeDateIsNotSupported = 'Ta wersja nie obsuguje isc_decode_sql_date';
  cSDecodeTimeIsNotSupported = 'Ta wersja nie obsuguje isc_decode_sql_time';
  cSDecodeTimestampIsNotSupported = 'Ta wersja nie obsuguje isc_decode_sql_timestamp';

  cSCanNotRetrieveResultSetData = 'Nie mona pobra danych wynikowych';
  cSRowBufferIsNotAssigned = 'Nie przypisano bufora wiersza';
  cSColumnIsNotAccessable = 'Kolumna o numerze %d jest niedostpna';
  cSConvertionIsNotPossible = 'Konwersja kolumny o numerze %d z %s na %s jest niemoliwa';
  cSCanNotAccessBlobRecord = 'Brak dostpu do rekordu typu blob w kolumnie %d z typem %s';
  cSRowDataIsNotAvailable = 'Dane wiersza s niedostpne';
  cSResolverIsNotSpecified = 'Ten ResultSet nie ma okrelonego Resolver-a';
  cSResultsetIsAlreadyOpened = 'ResultSet jest ju otwarty';
  cSCanNotUpdateEmptyRow = 'Nie mona aktualizowa pustego wiersza';
  cSCanNotUpdateDeletedRow = 'Nie mona aktualizowa usunitego wiersza';
  cSCanNotDeleteEmptyRow = 'Nie mona usun pustego wiersza';
  cSCannotUseCommit = 'Nie mona uy COMMIT w trybie AUTOCOMMIT';
  cSCannotUseRollBack = 'Nie mona uy ROLLBACK w trybie AUTOCOMMIT';
  cSCanNotUpdateComplexQuery = 'Nie mona aktualizowa zapytania zoonego z wicej ni jednej tabeli';
  cSCanNotUpdateThisQueryType = 'Nie mona aktualizowa tego typu zapytania';
  cSDriverWasNotFound = 'Nie znaleziono wymaganego sterownika bazy danych';
  cSCanNotConnectToServer = 'Nie mona poczy si z serwerem SQL';
  cSTableIsNotSpecified = 'Nie okrelono tabeli';
  cSLiveResultSetsAreNotSupported = '"Live query" nie jest obsugiwane przez t klas';
  cSInvalidInputParameterCount = 'Liczba parametrw wejciowych jest mniejsza ni oczekiwana';
  cSIsolationIsNotSupported = 'Poziom izolacji transakcji nie jest obsugiwany';
  cSColumnWasNotFound = 'Nie znaleziono kolumny o nazwie "%s"';
  cSWrongTypeForBlobParameter = 'Bdny typ parametru Blob';
  cSIncorrectConnectionURL = 'Bdny URL poczenia: %s';
  cSUnsupportedProtocol = 'Nieobsugiwany protok: %s';
  cSUnsupportedByDriver    = 'Sterownik nie obsuguje tej waciwoci natywnie: [%s]';

  cSConnectionIsNotOpened = 'Jeszcze nie nawizano poczenia';
  cSInvalidOpInAutoCommit = 'Bdna operacja w trybie AutoCommit';
  cSInvalidOpInNonAutoCommit = 'Bdna operacja przy wyczonym AutoCommit';
  cSInvalidOpPrepare = 'Przygotowanie transakcji moliwe jest tylko przy pierwszym(!) Starttransaction';

  cSConnectionIsNotAssigned = 'Nie przypisano komponentu poczenia do bazy danych';
  cSQueryIsEmpty = 'Zapytanie SQL jest puste';
  cSCanNotExecuteMoreQueries = 'Nie mona wykona wicej ni jednego zapytania';
  cSOperationIsNotAllowed1 = 'Niedozwolona operacja w trybie FORWARD ONLY';
  cSOperationIsNotAllowed2 = 'Niedozwolona operacja w trybie READ ONLY';
  cSOperationIsNotAllowed3 = 'Niedozwolona operacja w trybie %s';
  cSOperationIsNotAllowed4 = 'Niedozwolona operacja przy zamknitym rdle danych';
  cSNoMoreRecords = 'Nie ma ju wicej rekordw wynikowych';
  cSCanNotOpenResultSet = 'Nie mona otworzy danych wynikowych';
  cSCanNotOpenDataSetWhenDestroying ='Nie mona otworzy dataset gdy componentstate to dsDestroying';
  cSCircularLink = 'Datasource tworzy powizanie cykliczne';
  cSBookmarkWasNotFound = 'Nie znaleziono zakadki (Bookmark)';
  cSIncorrectSearchFieldsNumber = 'Bdna liczba pl do wyszukiwania';
  cSInvalidOperationInTrans = 'Bdna operacja w trybie transakcji';
  cSIncorrectSymbol = 'Bdny symbol w licie pl "%s".';
  cSIncorrectToken = 'Bdny wyraz za ":"';
  cSIncorrectParamChar = 'Bdna warto dla ParamChar';

  cSSelectedTransactionIsolation = 'Wybrany poziom izolacji transakcji nie jest obsugiwany';
  cSDriverNotSupported = 'Nie obsugiwany sterownik %s';
  cSPattern2Long = 'Wzorzec jest zbyt dugi';
  cSDriverNotCapableOutParameters = 'Sterownik nie potrafi obsuy parametrw';
  cSStatementIsNotAllowed = 'Niedozwolone wyraenie';
  cSStoredProcIsNotAllowed = 'Niedozwolona procedura skadowana';
  cSCannotPerformOperation = 'Nie mona wykona operacji na zamknitym zbiorze danych';
  cSInvalidState = 'Bdny stan';
  cSErrorConvertion = 'Bd konwersji';
  cSDataTypeDoesNotSupported = 'Nieobsugiwany typ danych';
  cSUnsupportedParameterType = 'Nieobsugiwany typ parametru';
  cSUnsupportedDataType = 'Nieobsugiwany typ danych';
  cSErrorConvertionField = 'Bd konwersji pola "%s" na SQLType "%s"';
  cSBadOCI = 'Za wersja OCI [%s]. Wymagana wersja 8.0.3 lub starsza';
  cSConnect2AsUser = 'Poczenie z "%s" jako uytkownik "%s"';
  cSUnknownError = 'Nieznany bd';
  cSFieldNotFound1 = 'Nie znaleziono pola "%s"';
  cSFieldNotFound2 = 'Nie znaleziono pola %d';

  cSLoginPromptFailure = 'Nie znaleziono domylnego dialogu logowania. Prosz doda DBLogDlg do sekcji uses gwnego pliku aplikacji.';

  cSPropertyQuery = 'Zapytanie moe chwil potrwa na wikszej bazie danych!';
  cSPropertyTables = 'Powiniene ucili Katalog i/lub Schemat.';
  cSPropertyColumns = 'Powiniene ucili Katalog, Schemat i/lub Nazw Tabeli.';
  cSPropertyProcedures = 'Powiniene ucili Katalog i/lub Schemat.';
  cSPropertySequences = 'Powiniene ucili Katalog i/lub Schemat.';
  cSPropertyExecute = 'Czy mimo to wykona zapytanie?';

  cSFormTest = 'Test Edytora SQL ZEOS';
  cSButtonClose = '&Zamknij';
  cSFormEditor = 'Edytor SQL ZEOS';
  cSTabSheetSelect = 'Wybr SQL';
  cSMenuLoad = 'aduj';
  cSMenuSave = 'Zapisz';
  cSButtonGenerate = '&Generuj';
  cSButtonCheck = '&Sprawd';
  cSButtonTest = '&Test';
  cSButtonOk = '&OK';
  cSButtonCancel = 'A&nuluj';
  cSTableAlias = '&Alias tabeli';
  cSReplaceSQL = 'Za&mie SQL';
  cSDialogOpenTitle = 'Otwrz plik SQL';
  cSDialogSaveTitle = 'Zapisz plik SQL';
  cSSQLEditor = 'Edytor SQL';
  cSDatabaseDialog = 'Otwrz istniejc baz';

  cSUpdateSQLNoResult = 'Update Refresh SQL nie zwrcio adnych danych';
  cSUpdateSQLRefreshStatementcount ='Wyraenie Update Refresh SQL musi zwrci 1 rekord danych';

  {$IFDEF FPC}
  cSNotEditing = 'Dataset nie jest w trybie "edit" lub "insert"';
  cSFieldTypeMismatch = 'Niezgodno typw dla pola ''%s'', oczekiwano: %s otrzymano: %s';
  cSFieldSizeMismatch = 'Niezgodno rozmiarw pola ''%s'', oczekiwano: %d otrzymano: %d';
  {$ENDIF}
  cSNeedField               = 'Pole %s jest wymagane.';

  cSFailedtoInitPrepStmt   = 'Nie udao si zainicjalizowa przygotowanego zapytania';
  cSFailedtoPrepareStmt    = 'Bd w wyraeniu podczas procesu przygotowania';
  cSFailedToBindAllValues  = 'Bd aplikacji podczas przypisywania danych';
  cSAttemptExecOnBadPrep   = 'Prba uruchomienia wyraenia przed zakoczeniem przygotowywania.';
  cSBindingFailure         = 'Bd przypisywania zbioru parametrw';
  cSPreparedStmtExecFailure = 'Bd wykonania przygotowanego zapytania';
  cSBoundVarStrIndexMissing = 'Nie istnieje zmienna licznikowa "%s"';
  cSBindVarOutOfRange      = 'Warto zmiennej licznikowej poza zakresem: %d';
  cSFailedToBindResults    = 'Bd aplikacji podczas czenia do wynikw zapytania';
  cSPreviousResultStillOpen = 'Poprzedni zbir wynikowy tego wyraenia jest nadal otwarty';

//FOS+ 07112006
  cSRefreshRowOnlySupportedWithUpdateObject = 'Metoda refreshrow jest obsugiwana tylko przez obiekt typu "update"';
  cSMustBeInBrowseMode = 'Operacja jest dozwolona tylko w stanie dsBROWSE';

  cSUnKnownParamDataType = 'Nieznany Param.DataType';
  cSFieldReadOnly        = 'Nie mona przypisa do pola tylko do odczytu wartoci: %d';
  cSInvalidUpdateCount     = 'Liczba zaktualizowanych rekordw: %d. tylko jeden rekord powinien by zaktualizowany.';

  cSRowBufferWidthExceeded ='Przekroczono rozmiar bufora. Sprbuj uy mniejszej liczby kolumn lub duszych kolumn w zapytaniu SQL.';

{$ELSE} // default: ENGLISH

  cSSQLError1 = 'SQL Error: %s';
  cSSQLError2 = 'SQL Error: %s Code: %d';
  cSSQLError3 = 'SQL Error: %s Code: %d SQL: %s';
  cSSQLError4 = 'SQL Error: %s Code: %d Message: %s';

  cSListCapacityError = 'List capacity out of bounds (%d)';
  cSListCountError = 'List count out of bounds (%d)';
  cSListIndexError = 'List index out of bounds (%d)';

  cSClonningIsNotSupported = 'Clonning is not supported by this class';
  cSImmutableOpIsNotAllowed = 'The operation is not allowed on not changeable collections';
  cSStackIsEmpty = 'Stack is empty';
  cSVariableWasNotFound = 'Variable "%s" was not found';
  cSFunctionWasNotFound = 'Function "%s" was not found';
  cSInternalError = 'Internal error';
  cSSyntaxErrorNear = 'Syntax error near "%s"';
  cSSyntaxError = 'Syntax error';
  cSUnknownSymbol = 'Unknown symbol "%s"';
  cSUnexpectedExprEnd = 'Unexpected end of expression';
  cSRightBraceExpected = ') expected';
  cSParametersError = '%d parameters were expected but %d were found';
  cSParamValueExceeded = 'value of param %d exceeded';
  cSExpectedMoreParams = 'More than two parameters are expected';
  cSInvalidVarByteArray = 'Invalid VarByte array';
  cSVariableAlreadyExists = 'Variable "%s" already exists';
  cSTypesMismatch = 'Types mismatch';
  cSUnsupportedVariantType = 'Unsupported variant type';
  cSUnsupportedOperation = 'Unsupported operation';

  cSTokenizerIsNotDefined = 'Tokenizer is not defined';
  cSLibraryNotFound = 'None of the dynamic libraries can be found or is not loadable: %s !'#10#13'Use TZConnection.LibraryLocation if the location is invalid.';
  cSEncodeDateIsNotSupported = 'This version does not support isc_encode_sql_date';
  cSEncodeTimeIsNotSupported = 'This version does not support isc_encode_sql_time';
  cSEncodeTimestampIsNotSupported = 'This version does not support isc_encode_sql_timestamp';
  cSDecodeDateIsNotSupported = 'This version does not support isc_decode_sql_date';
  cSDecodeTimeIsNotSupported = 'This version does not support isc_decode_sql_time';
  cSDecodeTimestampIsNotSupported = 'This version does not support isc_decode_sql_timestamp';

  cSCanNotRetrieveResultSetData = 'Cannot retrieve Resultset data';
  cSRowBufferIsNotAssigned = 'Row buffer is not assigned';
  cSColumnIsNotAccessable = 'Column with index %d is not accessable';
  cSConvertionIsNotPossible = 'Convertion is not possible for column %d from %s to %s';
  cSCanNotAccessBlobRecord = 'Cannot access blob record in column %d with type %s';
  cSRowDataIsNotAvailable = 'Row data is not available';
  cSResolverIsNotSpecified = 'Resolver is not specified for this ResultSet';
  cSResultsetIsAlreadyOpened = 'Resultset is already open';
  cSCanNotUpdateEmptyRow = 'Cannot update an empty row';
  cSCanNotUpdateDeletedRow = 'Cannot update a deleted row';
  cSCanNotDeleteEmptyRow = 'Cannot delete an empty row';
  cSCannotUseCommit = 'You cannot use COMMIT in AUTOCOMMIT mode';
  cSCannotUseRollBack = 'You cannot use ROLLBACK in AUTOCOMMIT mode';
  cSCanNotUpdateComplexQuery = 'Cannot update a complex query with more then one table';
  cSCanNotUpdateThisQueryType = 'Cannot update this query type';
  cSDriverWasNotFound = 'Requested database driver was not found';
  cSCanNotConnectToServer = 'Cannot connect to SQL server';
  cSTableIsNotSpecified = 'Table is not specified';
  cSLiveResultSetsAreNotSupported = 'Live query is not supported by this class';
  cSInvalidInputParameterCount = 'Input parameter count is less then expected';
  cSIsolationIsNotSupported = 'Transaction isolation level is not supported';
  cSColumnWasNotFound = 'Column with name "%s" was not found';
  cSWrongTypeForBlobParameter = 'Wrong type for Blob parameter';
  cSIncorrectConnectionURL = 'Incorrect connection URL: %s';
  cSUnsupportedProtocol = 'Unsupported protocol: %s';
  cSUnsupportedByDriver    = 'Driver can not support this feature natively: [%s]';

  cSConnectionIsNotOpened = 'Connection is not opened yet';
  cSInvalidOpInAutoCommit = 'Invalid operation in AutoCommit mode';
  cSInvalidOpInNonAutoCommit = 'Invalid operation in non AutoCommit mode';
  cSInvalidOpPrepare = 'Prepare transaction only possible on matching first(!) Starttransaction';

  cSConnectionIsNotAssigned = 'Database connection component is not assigned';
  cSQueryIsEmpty = 'SQL Query is empty';
  cSCanNotExecuteMoreQueries = 'Cannot execute more then one query';
  cSOperationIsNotAllowed1 = 'Operation is not allowed in FORWARD ONLY mode';
  cSOperationIsNotAllowed2 = 'Operation is not allowed in READ ONLY mode';
  cSOperationIsNotAllowed3 = 'Operation is not allowed in %s mode';
  cSOperationIsNotAllowed4 = 'Operation is not allowed for closed dataset';
  cSNoMoreRecords = 'No more records in the Resultset';
  cSCanNotOpenResultSet = 'Can not open a Resultset';
  cSCanNotOpenDataSetWhenDestroying ='Cannot open a dataset when the componentstate is dsDestroying';
  cSCircularLink = 'Datasource makes a circular link';
  cSBookmarkWasNotFound = 'Bookmark was not found';
  cSIncorrectSearchFieldsNumber = 'Incorrect number of search field values';
  cSInvalidOperationInTrans = 'Invalid operation in explicit transaction mode';
  cSIncorrectSymbol = 'Incorrect symbol in field list "%s".';
  cSIncorrectToken = 'Incorrect token followed by ":"';
  cSIncorrectParamChar = 'Invalid value for ParamChar';

  cSSelectedTransactionIsolation = 'Selected transaction isolation level is not supported';
  cSDriverNotSupported = 'Driver not supported %s';
  cSPattern2Long = 'Pattern is too long';
  cSDriverNotCapableOutParameters = 'Driver is not capable to handle parameters';
  cSStatementIsNotAllowed = 'Statement is not allowed';
  cSStoredProcIsNotAllowed = 'The stored proc is not allowed';
  cSCannotPerformOperation = 'Can not perform operation on closed Resultset';
  cSInvalidState = 'Invalid state';
  cSErrorConvertion = 'Convertion error';
  cSDataTypeDoesNotSupported = 'Data type is not supported';
  cSUnsupportedParameterType = 'Unsupported parameter type';
  cSUnsupportedDataType = 'Unsupported data type';
  cSErrorConvertionField = 'Conversion error for field "%s" to SQLType "%s"';
  cSBadOCI = 'Bad OCI version [%s]. Version 8.0.3 or older is required';
  cSConnect2AsUser = 'Connect to "%s" as user "%s"';
  cSUnknownError = 'Unknown error';
  cSFieldNotFound1 = 'Field "%s" was not found';
  cSFieldNotFound2 = 'Field %d was not found';

  cSLoginPromptFailure = 'Can not find default login prompt dialog. Please add DBLogDlg to the uses section of your main file.';

  cSPropertyQuery = 'The Query may last a while on large databases!';
  cSPropertyTables = 'You should limit it by Catalog and/or Schema.';
  cSPropertyColumns = 'You should limit it by Catalog, Schema and/or TableName.';
  cSPropertyProcedures = 'You should limit it by Catalog and/or Schema.';
  cSPropertySequences = 'You should limit it by Catalog and/or Schema.';
  cSPropertyExecute = 'Should the Query be executed anyway?';

  cSFormTest = 'ZEOS SQL Editor Test';
  cSButtonClose = '&Close';
  cSFormEditor = 'ZEOS SQL Editor';
  cSTabSheetSelect = 'Select SQL';
  cSMenuLoad = 'Load';
  cSMenuSave = 'Save';
  cSButtonGenerate = '&Generate';
  cSButtonCheck = 'C&heck';
  cSButtonTest = '&Test';
  cSButtonOk = '&OK';
  cSButtonCancel = '&Cancel';
  cSTableAlias = 'T&able alias';
  cSReplaceSQL = '&Replace SQL';
  cSDialogOpenTitle = 'Open SQL File';
  cSDialogSaveTitle = 'Save SQL File';
  cSSQLEditor = 'SQL Editor';
  cSDatabaseDialog = 'Open existing database';

  cSUpdateSQLNoResult = 'Update Refresh SQL delivered no resultset';
  cSUpdateSQLRefreshStatementcount ='Update Refresh SQL Statement count must be 1';

  {$IFDEF FPC}
  cSNotEditing = 'Dataset not in edit or insert mode';
  cSFieldTypeMismatch = 'Type mismatch for field ''%s'', expecting: %s actual: %s';
  cSFieldSizeMismatch = 'Size mismatch for field ''%s'', expecting: %d actual: %d';
  {$ENDIF}
  cSNeedField               = 'Field %s is required, but not supplied.';

  cSFailedtoInitPrepStmt   = 'Prepared statement failed to initialize';
  cSFailedtoPrepareStmt    = 'Statement failed during prepare process';
  cSFailedToBindAllValues  = 'Application failed to pre-bind all values';
  cSAttemptExecOnBadPrep   = 'Attempt made to execute a statement before a successful preparation.';
  cSBindingFailure         = 'Failed to bind parameter set';
  cSPreparedStmtExecFailure = 'Prepared statement failed to execute';
  cSBoundVarStrIndexMissing = 'Bound variable text index "%s" does not exist';
  cSBindVarOutOfRange      = 'Bound variable index out of range: %d';
  cSFailedToBindResults    = 'Application failed to bind to the result set';
  cSPreviousResultStillOpen = 'Previous resultset of this statement is still open';

//FOS+ 07112006
  cSRefreshRowOnlySupportedWithUpdateObject = 'The refreshrow method is only supported with an update object';
  cSMustBeInBrowseMode = 'Operation is only allowed in dsBROWSE state';

  cSUnKnownParamDataType = 'Unknown Param.DataType';
  cSFieldReadOnly        = 'Readonly field can''t be assigned a value: %s';
  cSInvalidUpdateCount     = '%d record(s) updated. Only one record should have been updated.';

  cSRowBufferWidthExceeded ='Row buffer width exceeded. Try using fewer or longer columns in SQL query.';

{$ENDIF} // POLISH

{$ENDIF} // CZECH

{$ENDIF} // RUSSIAN

{$ENDIF}   // INDONESIAN <--- added by tohenk

{$ENDIF}   // ROMANA

{$ENDIF} //SPANISH

{$ENDIF} // GERMAN

{$ENDIF} // DUTCH

{$ENDIF} // PORTUGUESE
{$ENDIF FRENCH}
type
  TMessageToRaw = function(const AMessage: String; Const RawCP: Word): RawByteString;

var
  MessageCodePage: Word;
  SSQLError1: String;
  SSQLError2: String;
  SSQLError3: String;
  SSQLError4: String;

  SListCapacityError: String;
  SListCountError: String;
  SListIndexError: String;

  SClonningIsNotSupported: String;
  SImmutableOpIsNotAllowed: String;
  SStackIsEmpty: String;
  SVariableWasNotFound: String;
  SFunctionWasNotFound: String;
  SInternalError: String;
  SSyntaxErrorNear: String;
  SSyntaxError: String;
  SUnknownSymbol: String;
  SUnexpectedExprEnd: String;
  SRightBraceExpected: String;
  SParametersError: String;
  SParamValueExceeded: String;
  SExpectedMoreParams: String;
  SInvalidVarByteArray: String;
  SVariableAlreadyExists: String;
  STypesMismatch: String;
  SUnsupportedVariantType: String;
  SUnsupportedOperation: String;

  STokenizerIsNotDefined: String;
  SLibraryNotFound: String;
  SLibraryNotCompatible: String;
  SEncodeDateIsNotSupported: String;
  SEncodeTimeIsNotSupported: String;
  SEncodeTimestampIsNotSupported: String;
  SDecodeDateIsNotSupported: String;
  SDecodeTimeIsNotSupported: String;
  SDecodeTimestampIsNotSupported: String;

  SCanNotRetrieveResultSetData: String;
  SRowBufferIsNotAssigned: String;
  SColumnIsNotAccessable: String;
  SConvertionIsNotPossible: String;
  SCanNotAccessBlobRecord: String;
  SRowDataIsNotAvailable: String;
  SResolverIsNotSpecified: String;
  SResultsetIsAlreadyOpened: String;
  SCanNotUpdateEmptyRow: String;
  SCanNotUpdateDeletedRow: String;
  SCanNotDeleteEmptyRow: String;
  SCannotUseCommit: String;
  SCannotUseRollBack: String;
  SCanNotUpdateComplexQuery: String;
  SCanNotUpdateThisQueryType: String;
  SDriverWasNotFound: String;
  SCanNotConnectToServer: String;
  STableIsNotSpecified: String;
  SLiveResultSetsAreNotSupported: String;
  SInvalidInputParameterCount: String;
  SIsolationIsNotSupported: String;
  SColumnWasNotFound: String;
  SWrongTypeForBlobParameter: String;
  SIncorrectConnectionURL: String;
  SUnsupportedProtocol: String;
  SUnsupportedByDriver   : String;

  SConnectionIsNotOpened: String;
  SInvalidOpInAutoCommit: String;
  SInvalidOpInNonAutoCommit: String;
  SInvalidOpPrepare: String;

  SConnectionIsNotAssigned: String;
  SQueryIsEmpty: String;
  SCanNotExecuteMoreQueries: String;
  SOperationIsNotAllowed1: String;
  SOperationIsNotAllowed2: String;
  SOperationIsNotAllowed3: String;
  SOperationIsNotAllowed4: String;
  SNoMoreRecords: String;
  SCanNotOpenResultSet: String;
  SCanNotOpenDataSetWhenDestroying: String;
  SCircularLink: String;
  SBookmarkWasNotFound: String;
  SIncorrectSearchFieldsNumber: String;
  SInvalidOperationInTrans: String;
  SIncorrectSymbol: String;
  SIncorrectToken: String;
  SIncorrectParamChar: String;

  SSelectedTransactionIsolation: String;
  SDriverNotSupported: String;
  SPattern2Long: String;
  SDriverNotCapableOutParameters: String;
  SStatementIsNotAllowed: String;
  SStoredProcIsNotAllowed: String;
  SCannotPerformOperation: String;
  SInvalidState: String;
  SErrorConvertion: String;
  SDataTypeDoesNotSupported: String;
  SUnsupportedParameterType: String;
  SUnsupportedDataType: String;
  SErrorConvertionField: String;
  SBadOCI: String;
  SConnect2AsUser: String;
  SUnknownError: String;
  SFieldNotFound1: String;
  SFieldNotFound2: String;

  SLoginPromptFailure: String;

  SPropertyQuery: String;
  SPropertyTables: String;
  SPropertyColumns: String;
  SPropertyProcedures: String;
  SPropertySequences: String;
  SPropertyExecute: String;

  SFormTest: String;
  SButtonClose: String;
  SFormEditor: String;
  STabSheetSelect: String;
  SMenuLoad: String;
  SMenuSave: String;
  SButtonGenerate: String;
  SButtonCheck: String;
  SButtonTest: String;
  SButtonOk: String;
  SButtonCancel: String;
  STableAlias: String;
  SReplaceSQL: String;
  SDialogOpenTitle: String;
  SDialogSaveTitle: String;
  SSQLEditor: String;
  SDatabaseDialog: String;

  SUpdateSQLNoResult: String;
  SUpdateSQLRefreshStatementcount: String;
  {$IFDEF FPC}
  SNotEditing: String;
  SFieldTypeMismatch: String;
  SFieldSizeMismatch: String;
  {$ENDIF}
  SNeedField: String;

  SFailedtoInitPrepStmt: String;
  SFailedtoPrepareStmt: String;
  SFailedToBindAllValues: String;
  SAttemptExecOnBadPrep: String;
  SBindingFailure: String;
  SPreparedStmtExecFailure: String;
  SBoundVarStrIndexMissing: String;
  SBindVarOutOfRange: String;
  SFailedToBindResults: String;
  SPreviousResultStillOpen: String;


  SRefreshRowOnlySupportedWithUpdateObject: String;
  SMustBeInBrowseMode: String;

  SUnKnownParamDataType: String;
  SFieldReadOnly: String;
  SInvalidUpdateCount: String;

  SRowBufferWidthExceeded: String;

implementation

procedure loadmessages;
begin
  MessageCodePage := cCodePage;

  SSQLError1 := cSSQLError1;
  SSQLError2 := cSSQLError2;
  SSQLError3 := cSSQLError3;
  SSQLError4 := cSSQLError4;

  SListCapacityError := cSListCapacityError;
  SListCountError := cSListCountError;
  SListIndexError := cSListIndexError;

  SClonningIsNotSupported := cSClonningIsNotSupported;
  SImmutableOpIsNotAllowed := cSImmutableOpIsNotAllowed;
  SStackIsEmpty := cSStackIsEmpty;
  SVariableWasNotFound := cSVariableWasNotFound;
  SFunctionWasNotFound := cSFunctionWasNotFound;
  SInternalError := cSInternalError;
  SSyntaxErrorNear := cSSyntaxErrorNear;
  SSyntaxError := cSSyntaxError;
  SUnknownSymbol := cSUnknownSymbol;
  SUnexpectedExprEnd := cSUnexpectedExprEnd;
  SRightBraceExpected := cSRightBraceExpected;
  SParametersError := cSParametersError;
  SParamValueExceeded := cSParamValueExceeded;

  SExpectedMoreParams := cSExpectedMoreParams;
  SInvalidVarByteArray := cSInvalidVarByteArray;
  SVariableAlreadyExists := cSVariableAlreadyExists;
  STypesMismatch := cSTypesMismatch;
  SUnsupportedVariantType := cSUnsupportedVariantType;
  SUnsupportedOperation := cSUnsupportedOperation;

  STokenizerIsNotDefined := cSTokenizerIsNotDefined;
  SLibraryNotFound := cSLibraryNotFound;
  SLibraryNotCompatible := cSLibraryNotCompatible;
  SEncodeDateIsNotSupported := cSEncodeDateIsNotSupported;
  SEncodeTimeIsNotSupported := cSEncodeTimeIsNotSupported;
  SEncodeTimestampIsNotSupported := cSEncodeTimestampIsNotSupported;
  SDecodeDateIsNotSupported := cSDecodeDateIsNotSupported;
  SDecodeTimeIsNotSupported := cSDecodeTimeIsNotSupported;
  SDecodeTimestampIsNotSupported := cSDecodeTimestampIsNotSupported;

  SCanNotRetrieveResultSetData := cSCanNotRetrieveResultSetData;
  SRowBufferIsNotAssigned := cSRowBufferIsNotAssigned;
  SColumnIsNotAccessable := cSColumnIsNotAccessable;
  SConvertionIsNotPossible := cSConvertionIsNotPossible;
  SCanNotAccessBlobRecord := cSCanNotAccessBlobRecord;
  SRowDataIsNotAvailable := cSRowDataIsNotAvailable;
  SResolverIsNotSpecified := cSResolverIsNotSpecified;
  SResultsetIsAlreadyOpened := cSResultsetIsAlreadyOpened;
  SCanNotUpdateEmptyRow := cSCanNotUpdateEmptyRow;
  SCanNotUpdateDeletedRow := cSCanNotUpdateDeletedRow;
  SCanNotDeleteEmptyRow := cSCanNotDeleteEmptyRow;
  SCannotUseCommit := cSCannotUseCommit;
  SCannotUseRollBack := cSCannotUseRollBack;
  SCanNotUpdateComplexQuery := cSCanNotUpdateComplexQuery;
  SCanNotUpdateThisQueryType := cSCanNotUpdateThisQueryType;
  SDriverWasNotFound := cSDriverWasNotFound;
  SCanNotConnectToServer := cSCanNotConnectToServer;
  STableIsNotSpecified := cSTableIsNotSpecified;
  SLiveResultSetsAreNotSupported := cSLiveResultSetsAreNotSupported;
  SInvalidInputParameterCount := cSInvalidInputParameterCount;
  SIsolationIsNotSupported := cSIsolationIsNotSupported;
  SColumnWasNotFound := cSColumnWasNotFound;
  SWrongTypeForBlobParameter := cSWrongTypeForBlobParameter;
  SIncorrectConnectionURL := cSIncorrectConnectionURL;
  SUnsupportedProtocol := cSUnsupportedProtocol;
  SUnsupportedByDriver := cSUnsupportedByDriver;

  SConnectionIsNotOpened := cSConnectionIsNotOpened;
  SInvalidOpInAutoCommit := cSInvalidOpInAutoCommit;
  SInvalidOpInNonAutoCommit := cSInvalidOpInNonAutoCommit;
  SInvalidOpPrepare := cSInvalidOpPrepare;

  SConnectionIsNotAssigned := cSConnectionIsNotAssigned;
  SQueryIsEmpty := cSQueryIsEmpty;
  SCanNotExecuteMoreQueries := cSCanNotExecuteMoreQueries;
  SOperationIsNotAllowed1 := cSOperationIsNotAllowed1;
  SOperationIsNotAllowed2 := cSOperationIsNotAllowed2;
  SOperationIsNotAllowed3 := cSOperationIsNotAllowed3;
  SOperationIsNotAllowed4 := cSOperationIsNotAllowed4;
  SNoMoreRecords := cSNoMoreRecords;
  SCanNotOpenResultSet := cSCanNotOpenResultSet;
  SCanNotOpenDataSetWhenDestroying := cSCanNotOpenDataSetWhenDestroying;
  SCircularLink := cSCircularLink;
  SBookmarkWasNotFound := cSBookmarkWasNotFound;
  SIncorrectSearchFieldsNumber := cSIncorrectSearchFieldsNumber;
  SInvalidOperationInTrans := cSInvalidOperationInTrans;
  SIncorrectSymbol := cSIncorrectSymbol;
  SIncorrectToken := cSIncorrectToken;
  SIncorrectParamChar := cSIncorrectParamChar;

  SSelectedTransactionIsolation := cSSelectedTransactionIsolation;
  SDriverNotSupported := cSDriverNotSupported;
  SPattern2Long := cSPattern2Long;
  SDriverNotCapableOutParameters := cSDriverNotCapableOutParameters;
  SStatementIsNotAllowed := cSStatementIsNotAllowed;
  SStoredProcIsNotAllowed := cSStoredProcIsNotAllowed;
  SCannotPerformOperation := cSCannotPerformOperation;
  SInvalidState := cSInvalidState;
  SErrorConvertion := cSErrorConvertion;
  SDataTypeDoesNotSupported := cSDataTypeDoesNotSupported;
  SUnsupportedParameterType := cSUnsupportedParameterType;
  SUnsupportedDataType := cSUnsupportedDataType;
  SErrorConvertionField := cSErrorConvertionField;
  SBadOCI := cSBadOCI;
  SConnect2AsUser := cSConnect2AsUser;
  SUnknownError := cSUnknownError;
  SFieldNotFound1 := cSFieldNotFound1;
  SFieldNotFound2 := cSFieldNotFound2;

  SLoginPromptFailure := cSLoginPromptFailure;

  SPropertyQuery := cSPropertyQuery;
  SPropertyTables := cSPropertyTables;
  SPropertyColumns := cSPropertyColumns;
  SPropertyProcedures := cSPropertyProcedures;
  SPropertySequences := cSPropertySequences;
  SPropertyExecute := cSPropertyExecute;

  SFormTest := cSFormTest;
  SButtonClose := cSButtonClose;
  SFormEditor := cSFormEditor;
  STabSheetSelect := cSTabSheetSelect;
  SMenuLoad := cSMenuLoad;
  SMenuSave := cSMenuSave;
  SButtonGenerate := cSButtonGenerate;
  SButtonCheck := cSButtonCheck;
  SButtonTest := cSButtonTest;
  SButtonOk := cSButtonOk;
  SButtonCancel := cSButtonCancel;
  STableAlias := cSTableAlias;
  SReplaceSQL := cSReplaceSQL;
  SDialogOpenTitle := cSDialogOpenTitle;
  SDialogSaveTitle := cSDialogSaveTitle;
  SSQLEditor := cSSQLEditor;
  SDatabaseDialog := cSDatabaseDialog;

  SUpdateSQLNoResult := cSUpdateSQLNoResult;
  SUpdateSQLRefreshStatementcount := cSUpdateSQLRefreshStatementcount;
  {$IFDEF FPC}
  SNotEditing := cSNotEditing;
  SFieldTypeMismatch := cSFieldTypeMismatch;
  SFieldSizeMismatch := cSFieldSizeMismatch;
  {$ENDIF}
  SNeedField := cSNeedField;

  SFailedtoInitPrepStmt := cSFailedtoInitPrepStmt;
  SFailedtoPrepareStmt := cSFailedtoPrepareStmt;
  SFailedToBindAllValues := cSFailedToBindAllValues;
  SAttemptExecOnBadPrep := cSAttemptExecOnBadPrep;
  SBindingFailure := cSBindingFailure;
  SPreparedStmtExecFailure := cSPreparedStmtExecFailure;
  SBoundVarStrIndexMissing := cSBoundVarStrIndexMissing;
  SBindVarOutOfRange := cSBindVarOutOfRange;
  SFailedToBindResults := cSFailedToBindResults;
  SPreviousResultStillOpen := cSPreviousResultStillOpen;

  SRefreshRowOnlySupportedWithUpdateObject := cSRefreshRowOnlySupportedWithUpdateObject;
  SMustBeInBrowseMode := cSMustBeInBrowseMode;

  SUnKnownParamDataType := cSUnKnownParamDataType;
  SFieldReadOnly := cSFieldReadOnly;
  SInvalidUpdateCount := cSInvalidUpdateCount;

  SRowBufferWidthExceeded := cSRowBufferWidthExceeded;
end;

initialization
  loadmessages;
end.




